/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.abilities;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jujutsucraftaddon")
public class SongOfTimeAbility {
    private static final Map<LivingEntity, PlayerState> playerStates = new HashMap<LivingEntity, PlayerState>();
    private static final Map<BlockPos, BlockState> worldStates = new HashMap<BlockPos, BlockState>();
    private static long savedTime;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.getServer().m_129921_() % 200 == 0) {
            SongOfTimeAbility.saveState(event.getServer());
        }
    }

    private static void saveState(MinecraftServer server) {
        savedTime = server.m_129783_().m_46468_();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            playerStates.put((LivingEntity)player, new PlayerState((LivingEntity)player));
        }
        for (ServerLevel level : server.m_129785_()) {
            for (Entity entity : level.m_8583_()) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                playerStates.put(livingEntity, new PlayerState(livingEntity));
            }
        }
    }

    private static void playOcarinaAnimation(ServerPlayer player) {
        player.m_21011_(player.m_7655_(), true);
        for (int i = 0; i < 20; ++i) {
            player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, player.m_20185_(), player.m_20186_() + 2.0, player.m_20189_(), Math.random(), 1.0, Math.random());
        }
    }

    public static void activateSongOfTime(MinecraftServer server, ServerPlayer player) {
        SongOfTimeAbility.playOcarinaAnimation(player);
        for (ServerPlayer p : server.m_6846_().m_11314_()) {
            if (!playerStates.containsKey(p)) continue;
            PlayerState state = playerStates.get(p);
            Vec3 startPos = p.m_20182_();
            Vec3 endPos = new Vec3(state.x, state.y, state.z);
            for (int i = 0; i <= 20; ++i) {
                Vec3 interpolated = startPos.m_165921_(endPos, (double)i / 20.0);
                p.m_6034_(interpolated.f_82479_, interpolated.f_82480_, interpolated.f_82481_);
                server.execute(() -> {});
            }
            p.m_21219_();
            for (MobEffectInstance effect : state.effects) {
                p.m_7292_(new MobEffectInstance(effect));
            }
            p.m_150109_().m_6211_();
            for (int i = 0; i < state.inventory.size(); ++i) {
                p.m_150109_().m_6836_(i, state.inventory.get(i).m_41777_());
            }
            if (p instanceof LivingEntity) {
                p.m_21153_(state.health);
            }
            CompoundTag nbt = state.nbtData.m_6426_();
            p.m_20258_(nbt);
        }
        Vec3 _center = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
        Level world = player.m_9236_();
        List<Entity> _entfound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(300.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
        for (Entity p : _entfound) {
            if (!playerStates.containsKey(p)) continue;
            PlayerState state = playerStates.get(p);
            Vec3 startPos = p.m_20182_();
            Vec3 endPos = new Vec3(state.x, state.y, state.z);
            for (int i = 0; i <= 20; ++i) {
                Vec3 interpolated = startPos.m_165921_(endPos, (double)i / 20.0);
                p.m_6034_(interpolated.f_82479_, interpolated.f_82480_, interpolated.f_82481_);
                server.execute(() -> {});
            }
            if (!(p instanceof LivingEntity)) continue;
            ((LivingEntity)p).m_21153_(state.health);
            ((LivingEntity)p).m_21219_();
            for (MobEffectInstance effect : state.effects) {
                ((LivingEntity)p).m_7292_(new MobEffectInstance(effect));
            }
            if (p instanceof LivingEntity) {
                ((LivingEntity)p).m_21153_(state.health);
            }
            CompoundTag nbt = state.nbtData.m_6426_();
            p.m_20258_(nbt);
        }
        server.m_129783_().m_8615_(savedTime);
    }

    public static void activateSongOfStorms(MinecraftServer server, ServerPlayer player) {
        SongOfTimeAbility.playOcarinaAnimation(player);
        server.m_129783_().m_8606_(0, 6000, true, true);
    }

    public static void activateSongOfSnow(MinecraftServer server, ServerPlayer player) {
        SongOfTimeAbility.playOcarinaAnimation(player);
        server.m_129783_().m_8606_(0, 6000, true, false);
    }

    public static void activateEponasSong(ServerPlayer player) {
        SongOfTimeAbility.playOcarinaAnimation(player);
        Horse horse = (Horse)EntityType.f_20457_.m_20615_(player.m_9236_());
        horse.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        horse.m_30651_(true);
        horse.m_30586_(player.m_20148_());
        horse.m_6593_(player.m_7755_());
        horse.m_7910_(0.3375f);
        player.m_9236_().m_7967_((Entity)horse);
        player.m_20329_((Entity)horse);
    }

    public static void activateSunsSong(MinecraftServer server, ServerPlayer player) {
        SongOfTimeAbility.playOcarinaAnimation(player);
        long time = server.m_129783_().m_46468_();
        server.m_129783_().m_8615_(time < 12000L ? 18000L : 0L);
    }

    public static void activateSongOfHealing(ServerPlayer player) {
        SongOfTimeAbility.playOcarinaAnimation(player);
        player.m_21153_(player.m_21233_());
        player.m_21219_();
    }

    public static void activateBoleroOfFire(ServerPlayer player) {
        SongOfTimeAbility.playOcarinaAnimation(player);
        player.m_20254_(5);
    }

    public static void activateSerenadeOfWater(ServerPlayer player) {
        SongOfTimeAbility.playOcarinaAnimation(player);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 6000, 1));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 6000, 1));
    }

    public static void activateNocturneOfShadow(ServerPlayer player) {
        SongOfTimeAbility.playOcarinaAnimation(player);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 6000, 1));
    }

    private static class PlayerState {
        private final double x;
        private final double y;
        private final double z;
        private final float health;
        private final CompoundTag nbtData;
        private final List<MobEffectInstance> effects;
        private final List<ItemStack> inventory;

        public PlayerState(LivingEntity player) {
            this.x = player.m_20185_();
            this.y = player.m_20186_();
            this.z = player.m_20189_();
            this.health = player.m_21223_();
            this.nbtData = new CompoundTag();
            player.m_20223_(this.nbtData);
            this.effects = player.m_21220_().stream().map(effect -> new MobEffectInstance(effect)).collect(Collectors.toList());
            if (player instanceof Player) {
                Player p = (Player)player;
                this.inventory = p.m_150109_().f_35974_.stream().map(ItemStack::m_41777_).collect(Collectors.toList());
            } else {
                this.inventory = List.of();
            }
        }
    }
}

