/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.abilities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jujutsucraftaddon")
public class FireBlastAbility {
    private static final int BLAST_RADIUS = 5;
    private static final int FIRE_DURATION = 80;
    private static final int FIRE_LIFETIME = 60;
    private static final List<ScheduledFireRemoval> scheduledRemovals = new ArrayList<ScheduledFireRemoval>();

    public static void createFireBlast(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        BlockPos centerPos = player.m_20183_();
        ArrayList<BlockPos> fireBlocks = new ArrayList<BlockPos>();
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                BlockPos pos = centerPos.m_7918_(x, 0, z);
                if (!serverLevel.m_8055_(pos).m_60795_()) continue;
                serverLevel.m_7731_(pos, Blocks.f_50084_.m_49966_(), 3);
                fireBlocks.add(pos);
            }
        }
        FireBlastAbility.igniteEntities(serverLevel, centerPos);
        scheduledRemovals.add(new ScheduledFireRemoval(serverLevel, fireBlocks, 60));
    }

    private static void igniteEntities(ServerLevel level, BlockPos centerPos) {
        List nearbyEntities = level.m_45933_(null, new AABB((double)(centerPos.m_123341_() - 5), (double)centerPos.m_123342_(), (double)(centerPos.m_123343_() - 5), (double)(centerPos.m_123341_() + 5), (double)(centerPos.m_123342_() + 2), (double)(centerPos.m_123343_() + 5)));
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity) || entity instanceof Player) continue;
            entity.m_20254_(4);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<ScheduledFireRemoval> iterator = scheduledRemovals.iterator();
            while (iterator.hasNext()) {
                ScheduledFireRemoval removal = iterator.next();
                --removal.ticksLeft;
                if (removal.ticksLeft > 0) continue;
                for (BlockPos blockPos : removal.blockPositions) {
                    if (!removal.level.m_8055_(blockPos).m_60713_(Blocks.f_50084_)) continue;
                    removal.level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                }
                iterator.remove();
            }
        }
    }

    private static class ScheduledFireRemoval {
        private final ServerLevel level;
        private final List<BlockPos> blockPositions;
        private int ticksLeft;

        public ScheduledFireRemoval(ServerLevel level, List<BlockPos> blockPositions, int ticksLeft) {
            this.level = level;
            this.blockPositions = blockPositions;
            this.ticksLeft = ticksLeft;
        }
    }
}

