/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.abilities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jujutsucraftaddon")
public class EarthWallAbility {
    private static final int WALL_WIDTH = 20;
    private static final int WALL_HEIGHT = 10;
    private static final int WALL_LIFETIME = 100;
    private static final double KNOCKBACK_FORCE = 1.5;
    private static final List<ScheduledWallRemoval> scheduledRemovals = new ArrayList<ScheduledWallRemoval>();

    public static void createEarthWall(LivingEntity player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        float yaw = player.m_146908_();
        int dirX = (int)Math.round(-Math.sin(Math.toRadians(yaw)));
        int dirZ = (int)Math.round(Math.cos(Math.toRadians(yaw)));
        BlockPos startPos = player.m_20183_().m_7918_(dirX * 3, 0, dirZ * 3);
        ArrayList<BlockPos> placedBlocks = new ArrayList<BlockPos>();
        for (int x = -10; x <= 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                BlockPos pos = Math.abs(dirX) > Math.abs(dirZ) ? startPos.m_7918_(0, y, x) : startPos.m_7918_(x, y, 0);
                if (!serverLevel.m_8055_(pos).m_60795_()) continue;
                serverLevel.m_7731_(pos, Blocks.f_50069_.m_49966_(), 3);
                placedBlocks.add(pos);
            }
        }
        EarthWallAbility.knockbackEntities(serverLevel, startPos, dirX, dirZ);
        scheduledRemovals.add(new ScheduledWallRemoval(serverLevel, placedBlocks, 100));
    }

    private static void knockbackEntities(ServerLevel level, BlockPos wallPos, int dirX, int dirZ) {
        double range = 12.0;
        List nearbyEntities = level.m_45933_(null, new AABB((double)wallPos.m_123341_() - range, (double)wallPos.m_123342_(), (double)wallPos.m_123343_() - range, (double)wallPos.m_123341_() + range, (double)(wallPos.m_123342_() + 10), (double)wallPos.m_123343_() + range));
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity) || entity instanceof Player) continue;
            double knockbackX = (double)dirX * 1.5;
            double knockbackZ = (double)dirZ * 1.5;
            entity.m_20334_(knockbackX, 0.5, knockbackZ);
            if (entity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("forge:ranged_ammo")))) {
                entity.m_146870_();
            }
            entity.f_19864_ = true;
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<ScheduledWallRemoval> iterator = scheduledRemovals.iterator();
            while (iterator.hasNext()) {
                ScheduledWallRemoval removal = iterator.next();
                --removal.ticksLeft;
                if (removal.ticksLeft > 0) continue;
                for (BlockPos blockPos : removal.blockPositions) {
                    if (!removal.level.m_8055_(blockPos).m_60713_(Blocks.f_50069_)) continue;
                    removal.level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                }
                iterator.remove();
            }
        }
    }

    private static class ScheduledWallRemoval {
        private final ServerLevel level;
        private final List<BlockPos> blockPositions;
        private int ticksLeft;

        public ScheduledWallRemoval(ServerLevel level, List<BlockPos> blockPositions, int ticksLeft) {
            this.level = level;
            this.blockPositions = blockPositions;
            this.ticksLeft = ticksLeft;
        }
    }
}

