/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.abilities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jujutsucraftaddon")
public class CuttingSlashAbility {
    private static final double SLASH_LENGTH = 15.0;
    private static final double RADIUS = 5.0;
    private static final double DAMAGE = 20.0;
    private static final List<CuttingSlashInstance> activeSlashes = new ArrayList<CuttingSlashInstance>();

    public static void useCuttingSlash(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        Vec3 startPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 direction = player.m_20154_().m_82541_();
        activeSlashes.add(new CuttingSlashInstance(player, startPos, direction));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<CuttingSlashInstance> iterator = activeSlashes.iterator();
            while (iterator.hasNext()) {
                CuttingSlashInstance instance = iterator.next();
                instance.tick();
                if (!instance.isComplete()) continue;
                iterator.remove();
            }
        }
    }

    private static class CuttingSlashInstance {
        private final Player player;
        private final Vec3 startPos;
        private final Vec3 direction;
        private boolean completed = false;

        public CuttingSlashInstance(Player player, Vec3 startPos, Vec3 direction) {
            this.player = player;
            this.startPos = startPos;
            this.direction = direction;
        }

        public void tick() {
            if (this.completed) {
                return;
            }
            ServerLevel level = (ServerLevel)this.player.m_9236_();
            Vec3 endPos = this.startPos.m_82549_(this.direction.m_82490_(15.0));
            AABB slashArea = new AABB(this.startPos, endPos).m_82400_(5.0);
            List entitiesInRange = level.m_45933_(null, slashArea);
            for (Entity entity : entitiesInRange) {
                if (entity instanceof LivingEntity && entity != this.player) {
                    ((LivingEntity)entity).m_6469_(this.player.m_269291_().m_269425_(), 20.0f);
                }
                if (!(entity instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity;
                BlockPos pos = new BlockPos((int)itemEntity.m_20185_(), (int)itemEntity.m_20186_(), (int)itemEntity.m_20189_());
                level.m_46961_(BlockPos.m_274561_((double)itemEntity.m_20185_(), (double)itemEntity.m_20186_(), (double)itemEntity.m_20189_()), false);
            }
            this.completed = true;
        }

        public boolean isComplete() {
            return this.completed;
        }
    }
}

