/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon.abilities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jujutsucraftaddon")
public class BoomerangAbility {
    private static final double SPEED = 1.5;
    private static final int MAX_DISTANCE = 20;
    private static final float EXPLOSION_STRENGTH = 2.5f;
    private static final double ARC_CURVE = 0.3;
    private static final double ROTATION_SPEED = 40.0;
    private static final List<BoomerangInstance> activeBoomerangs = new ArrayList<BoomerangInstance>();

    public static void throwBoomerang(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        ItemStack mainHandItem = player.m_21205_();
        if (mainHandItem.m_41619_()) {
            return;
        }
        Vec3 startPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 direction = player.m_20154_().m_82541_().m_82490_(1.5);
        ItemEntity boomerang = new ItemEntity((Level)serverLevel, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, mainHandItem.m_41777_());
        boomerang.m_32061_();
        boomerang.m_20256_(direction);
        serverLevel.m_7967_((Entity)boomerang);
        player.m_21008_(player.m_7655_(), ItemStack.f_41583_);
        activeBoomerangs.add(new BoomerangInstance(player, boomerang, direction, 0));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<BoomerangInstance> iterator = activeBoomerangs.iterator();
            while (iterator.hasNext()) {
                BoomerangInstance instance = iterator.next();
                instance.tick();
                if (!instance.isComplete()) continue;
                iterator.remove();
            }
        }
    }

    private static class BoomerangInstance {
        private final Player player;
        private final ItemEntity boomerang;
        private Vec3 velocity;
        private int ticksTraveled;
        private boolean returning = false;

        public BoomerangInstance(Player player, ItemEntity boomerang, Vec3 velocity, int ticksTraveled) {
            this.player = player;
            this.boomerang = boomerang;
            this.velocity = velocity;
            this.ticksTraveled = ticksTraveled;
        }

        public void tick() {
            if (!this.boomerang.m_6084_()) {
                return;
            }
            ServerLevel level = (ServerLevel)this.player.m_9236_();
            Vec3 currentPos = this.boomerang.m_20182_();
            ++this.ticksTraveled;
            this.boomerang.m_146922_(this.boomerang.m_146908_() + 40.0f);
            double arcOffset = Math.sin((double)this.ticksTraveled * 0.2) * 0.3;
            Vec3 curvedVelocity = new Vec3(this.velocity.f_82479_ + arcOffset, this.velocity.f_82480_, this.velocity.f_82481_);
            for (Entity entity : level.m_45933_(null, new AABB(currentPos, currentPos).m_82400_(1.0))) {
                if (!(entity instanceof LivingEntity) || entity == this.player) continue;
                this.explodeWithoutDestroying(level, currentPos);
                this.returnToPlayer();
                return;
            }
            if (this.ticksTraveled >= 20 && !this.returning) {
                this.returnToPlayer();
            }
            if (!this.returning) {
                this.boomerang.m_20256_(curvedVelocity);
            } else {
                Vec3 directionToPlayer = this.player.m_20182_().m_82520_(0.0, (double)this.player.m_20192_(), 0.0).m_82546_(currentPos).m_82541_().m_82490_(1.5);
                this.boomerang.m_20256_(directionToPlayer);
                if ((double)this.boomerang.m_20270_((Entity)this.player) < 1.5) {
                    this.completeReturn();
                }
            }
        }

        private void explodeWithoutDestroying(ServerLevel level, Vec3 pos) {
            level.m_254849_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, 2.5f, Level.ExplosionInteraction.NONE);
        }

        private void returnToPlayer() {
            this.returning = true;
        }

        private void completeReturn() {
            if (this.player.m_21205_().m_41619_()) {
                this.player.m_21008_(this.player.m_7655_(), this.boomerang.m_32055_());
            } else {
                this.player.m_36356_(this.boomerang.m_32055_());
            }
            this.boomerang.m_146870_();
        }

        public boolean isComplete() {
            return !this.boomerang.m_6084_();
        }
    }
}

