/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon;

import com.jujutsu.jujutsucraftaddon.JujutsucraftaddonMod;
import com.jujutsu.jujutsucraftaddon.JujutsucraftaddonModNetworkHandler;
import com.jujutsu.jujutsucraftaddon.network.JujutsucraftaddonModVariables;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TextureSyncPacket {
    private final String texture;
    private final String displayName;

    public TextureSyncPacket(String texture, String displayName) {
        this.texture = texture;
        this.displayName = displayName;
    }

    public static void encode(TextureSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130070_(packet.texture);
        buffer.m_130070_(packet.displayName);
    }

    public static TextureSyncPacket decode(FriendlyByteBuf buffer) {
        String texture = buffer.m_130277_();
        String displayName = buffer.m_130277_();
        return new TextureSyncPacket(texture, displayName);
    }

    public static void handle(TextureSyncPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            String texture = packet.texture;
            String displayName = packet.displayName;
            System.out.println("Received texture: " + texture + " from: " + displayName);
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (context.getSender() != null) {
                ServerPlayer player = context.getSender();
                player.getCapability(JujutsucraftaddonModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                    if (capability.MobTexture != texture.toLowerCase() && capability.MobTexture.length() < 4) {
                        capability.SkinName1 = displayName;
                        capability.MobTexture = texture.toLowerCase();
                    } else if (capability.MobTexture2 != texture.toLowerCase() && capability.MobTexture2.length() < 4) {
                        capability.SkinName2 = displayName;
                        capability.MobTexture2 = texture.toLowerCase();
                    } else if (capability.MobTexture3 != texture.toLowerCase() && capability.MobTexture3.length() < 4) {
                        capability.SkinName3 = displayName;
                        capability.MobTexture3 = texture.toLowerCase();
                    }
                    capability.ShadowName = displayName;
                    capability.Shadow = texture.toLowerCase();
                    try {
                        capability.syncPlayerVariables((Entity)player);
                    }
                    catch (Exception e) {
                        System.out.println("Failed to sync player variables: " + e.getMessage());
                        e.printStackTrace();
                    }
                });
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String sendTextureToServer(LivingEntity livingEntity) {
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer livingRenderer = entityRenderDispatcher.m_114382_((Entity)livingEntity);
        ResourceLocation resourceLocation = livingRenderer.m_5478_((Entity)livingEntity);
        String textureLocation = resourceLocation.toString().toLowerCase();
        String displayName = livingEntity.m_5446_().getString();
        JujutsucraftaddonModNetworkHandler.INSTANCE.sendToServer((Object)new TextureSyncPacket(textureLocation, displayName));
        return textureLocation;
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        JujutsucraftaddonMod.addNetworkMessage(TextureSyncPacket.class, TextureSyncPacket::encode, TextureSyncPacket::decode, TextureSyncPacket::handle);
    }
}

