/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class PlayerAnimatedRenderer
extends LivingEntityRenderer<AbstractClientPlayer, EntityModel<AbstractClientPlayer>> {
    private final ResourceLocation PLAYER_SKIN;

    public PlayerAnimatedRenderer(EntityRendererProvider.Context context, ResourceLocation skin, EntityModel<AbstractClientPlayer> model) {
        super(context, model, 0.5f);
        this.PLAYER_SKIN = skin;
    }

    protected RenderType getRenderType(AbstractClientPlayer player, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(player));
    }

    public ResourceLocation getTextureLocation(AbstractClientPlayer entity) {
        return this.PLAYER_SKIN;
    }

    public void render(AbstractClientPlayer entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        try {
            super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        }
        catch (Exception e) {
            matrixStack.m_85849_();
        }
    }

    public Vec3 getRenderOffset(AbstractClientPlayer player, float partialTicks) {
        return player.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_((Entity)player, partialTicks);
    }

    protected void setupRotations(AbstractClientPlayer player, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = player.m_20998_(partialTicks);
        if (player.m_21255_()) {
            super.m_7523_((LivingEntity)player, poseStack, ageInTicks, rotationYaw, partialTicks);
            f3 = (float)player.m_21256_() + partialTicks;
            f2 = Mth.m_14036_((float)(f3 * f3 / 100.0f), (float)0.0f, (float)1.0f);
            if (!player.m_21209_()) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(f2 * (-90.0f - player.m_5686_(partialTicks))));
            }
        } else if (f > 0.0f) {
            super.m_7523_((LivingEntity)player, poseStack, ageInTicks, rotationYaw, partialTicks);
            f3 = player.m_20069_() ? -90.0f : -90.0f - player.m_5686_(partialTicks);
            f2 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(f2));
            if (player.m_6067_()) {
                poseStack.m_252880_(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.m_7523_((LivingEntity)player, poseStack, ageInTicks, rotationYaw, partialTicks);
        }
        if (ModList.get().isLoaded("playeranimator")) {
            IAnimatedPlayer animatedPlayer = (IAnimatedPlayer)player;
            AnimationApplier animationPlayer = animatedPlayer.playerAnimator_getAnimation();
            animationPlayer.setTickDelta(partialTicks);
            if (animationPlayer.isActive()) {
                Vec3f position = animationPlayer.get3DTransform("body", TransformType.POSITION, Vec3f.ZERO);
                poseStack.m_85837_((double)((Float)position.getX()).floatValue(), (double)((Float)position.getY()).floatValue() + 0.7, (double)((Float)position.getZ()).floatValue());
                Vec3f rotation = animationPlayer.get3DTransform("body", TransformType.ROTATION, Vec3f.ZERO);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(((Float)rotation.getZ()).floatValue()));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(((Float)rotation.getY()).floatValue()));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(((Float)rotation.getX()).floatValue()));
                poseStack.m_85837_(0.0, -0.7, 0.0);
            }
        }
    }
}

