/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.jujutsucraftaddon;

import com.jujutsu.jujutsucraftaddon.JujutsucraftaddonModNetworkHandler;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModBlockEntities;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModBlocks;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModEnchantments;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModEntities;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModFluidTypes;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModFluids;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModItems;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModMenus;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModMobEffects;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModParticleTypes;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModSounds;
import com.jujutsu.jujutsucraftaddon.init.JujutsucraftaddonModTabs;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jujutsucraftaddon")
public class JujutsucraftaddonMod {
    public static final Logger LOGGER = LogManager.getLogger(JujutsucraftaddonMod.class);
    public static final String MODID = "jujutsucraftaddon";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("jujutsucraftaddon", "jujutsucraftaddon"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Queue<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public JujutsucraftaddonMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        JujutsucraftaddonModNetworkHandler.registerMessages();
        this.registerModComponents(bus);
    }

    private void registerModComponents(IEventBus bus) {
        JujutsucraftaddonModSounds.REGISTRY.register(bus);
        JujutsucraftaddonModBlocks.REGISTRY.register(bus);
        JujutsucraftaddonModBlockEntities.REGISTRY.register(bus);
        JujutsucraftaddonModItems.REGISTRY.register(bus);
        JujutsucraftaddonModEntities.REGISTRY.register(bus);
        JujutsucraftaddonModEnchantments.REGISTRY.register(bus);
        JujutsucraftaddonModTabs.REGISTRY.register(bus);
        JujutsucraftaddonModMobEffects.REGISTRY.register(bus);
        JujutsucraftaddonModParticleTypes.REGISTRY.register(bus);
        JujutsucraftaddonModMenus.REGISTRY.register(bus);
        JujutsucraftaddonModFluids.REGISTRY.register(bus);
        JujutsucraftaddonModFluidTypes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID++, messageType, encoder, decoder, messageConsumer);
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processQueuedWork();
        }
    }

    private void processQueuedWork() {
        ArrayList<AbstractMap.SimpleEntry> completedTasks = new ArrayList<AbstractMap.SimpleEntry>();
        for (AbstractMap.SimpleEntry simpleEntry : workQueue) {
            int remainingTicks = (Integer)simpleEntry.getValue() - 1;
            simpleEntry.setValue(remainingTicks);
            if (remainingTicks > 0) continue;
            completedTasks.add(simpleEntry);
        }
        completedTasks.forEach(task -> {
            try {
                ((Runnable)task.getKey()).run();
            }
            catch (Exception e) {
                LOGGER.error("Error executing queued task", (Throwable)e);
            }
        });
        workQueue.removeAll(completedTasks);
    }
}

