/*
 * Decompiled with CFR 0.152.
 */
package com.github.cpburnz.minecraft_prometheus_exporter;

import com.github.cpburnz.minecraft_prometheus_exporter.ServerConfig;
import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.Collector;
import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.GaugeMetricFamily;
import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.Histogram;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class MinecraftCollector
extends Collector
implements Collector.Describable {
    private static final Logger LOG = LogUtils.getLogger();
    private static final double[] TICK_BUCKETS = new double[]{0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1.0};
    private final ServerConfig config;
    private final Histogram dim_tick_seconds;
    private final ConcurrentHashMap<ResourceKey<Level>, Histogram.Timer> dim_tick_timers;
    private final MinecraftServer mc_server;
    private final Histogram server_tick_seconds;
    @Nullable
    private Histogram.Timer server_tick_timer;

    public MinecraftCollector(ServerConfig config, MinecraftServer mc_server) {
        this.config = config;
        this.dim_tick_timers = new ConcurrentHashMap(3);
        this.mc_server = mc_server;
        this.server_tick_seconds = ((Histogram.Builder)((Histogram.Builder)Histogram.build().buckets(TICK_BUCKETS).name("mc_server_tick_seconds")).help("Stats on server tick times.")).create();
        this.dim_tick_seconds = ((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().buckets(TICK_BUCKETS).name("mc_dimension_tick_seconds")).labelNames("id", "name")).help("Stats on dimension tick times.")).create();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        try {
            GaugeMetricFamily player_list = this.collectPlayerList();
            List<Collector.MetricFamilySamples> server_ticks = this.server_tick_seconds.collect();
            GaugeMetricFamily dim_chunks_loaded = this.collectDimensionChunksLoaded();
            List<Collector.MetricFamilySamples> dim_ticks = this.dim_tick_seconds.collect();
            GaugeMetricFamily entities = null;
            int entities_init = 0;
            if (this.config.collector_mc_entities) {
                entities = this.collectEntitiesTotal();
                entities_init = 1;
            }
            ArrayList<Collector.MetricFamilySamples> metrics = new ArrayList<Collector.MetricFamilySamples>(1 + entities_init + server_ticks.size() + 1 + dim_ticks.size());
            metrics.add(player_list);
            if (entities != null) {
                metrics.add(entities);
            }
            metrics.addAll(server_ticks);
            metrics.add(dim_chunks_loaded);
            metrics.addAll(dim_ticks);
            return metrics;
        }
        catch (Exception e) {
            LOG.error("Failed to collect metrics.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private GaugeMetricFamily collectDimensionChunksLoaded() {
        GaugeMetricFamily metric = MinecraftCollector.newDimensionChunksLoadedMetric();
        for (ServerLevel world : this.mc_server.getAllLevels()) {
            ResourceKey dim = world.dimension();
            String id_str = Integer.toString(MinecraftCollector.getDimensionId((ResourceKey<Level>)dim));
            String name = dim.location().getPath();
            int loaded = world.getChunkSource().getLoadedChunksCount();
            metric.addMetric(List.of(id_str, name), loaded);
        }
        return metric;
    }

    private GaugeMetricFamily collectEntitiesTotal() {
        HashMap<EntityKey, Integer> entity_totals = new HashMap<EntityKey, Integer>();
        for (ServerLevel world : this.mc_server.getAllLevels()) {
            ResourceKey dim_resource = world.dimension();
            int dim_id = MinecraftCollector.getDimensionId((ResourceKey<Level>)dim_resource);
            String dim = dim_resource.location().getPath();
            for (Entity entity : world.getAllEntities()) {
                if (entity instanceof Player) continue;
                String entity_type = entity instanceof ItemEntity ? "Item" : entity.getName().getString();
                EntityKey entity_key = new EntityKey(dim, dim_id, entity_type);
                entity_totals.merge(entity_key, 1, Integer::sum);
            }
        }
        GaugeMetricFamily metric = MinecraftCollector.newEntitiesTotalMetric();
        for (Map.Entry entry : entity_totals.entrySet()) {
            EntityKey entity_key = (EntityKey)entry.getKey();
            double total = ((Integer)entry.getValue()).intValue();
            String dim_id_str = Integer.toString(entity_key.dim_id);
            metric.addMetric(List.of(entity_key.dim, dim_id_str, entity_key.type), total);
        }
        return metric;
    }

    private GaugeMetricFamily collectPlayerList() {
        GaugeMetricFamily metric = MinecraftCollector.newPlayerListMetric();
        for (ServerPlayer player : this.mc_server.getPlayerList().getPlayers()) {
            GameProfile profile = player.getGameProfile();
            String id_str = profile.getId().toString();
            String name = profile.getName();
            metric.addMetric(List.of(id_str, name), 1.0);
        }
        return metric;
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        ArrayList<Collector.MetricFamilySamples> descs = new ArrayList<Collector.MetricFamilySamples>();
        descs.add(MinecraftCollector.newPlayerListMetric());
        if (this.config.collector_mc_entities) {
            descs.add(MinecraftCollector.newEntitiesTotalMetric());
        }
        descs.addAll(this.server_tick_seconds.describe());
        descs.add(MinecraftCollector.newDimensionChunksLoadedMetric());
        descs.addAll(this.dim_tick_seconds.describe());
        return descs;
    }

    private static int getDimensionId(ResourceKey<Level> dim) {
        if (dim.equals((Object)Level.OVERWORLD)) {
            return 0;
        }
        if (dim.equals((Object)Level.END)) {
            return 1;
        }
        if (dim.equals((Object)Level.NETHER)) {
            return -1;
        }
        String name = dim.location().getPath();
        return name.hashCode();
    }

    private static GaugeMetricFamily newDimensionChunksLoadedMetric() {
        return new GaugeMetricFamily("mc_dimension_chunks_loaded", "The number of loaded dimension chunks.", List.of("id", "name"));
    }

    private static GaugeMetricFamily newEntitiesTotalMetric() {
        return new GaugeMetricFamily("mc_entities_total", "The number of entities in each dimension by type.", List.of("dim", "dim_id", "type"));
    }

    private static GaugeMetricFamily newPlayerListMetric() {
        return new GaugeMetricFamily("mc_player_list", "The players connected to the server.", List.of("id", "name"));
    }

    public void startDimensionTick(ResourceKey<Level> dim) {
        String name = dim.location().getPath();
        Histogram.Timer timer = this.dim_tick_timers.get(dim);
        if (timer != null) {
            switch (this.config.collector_mc_dimension_tick_errors) {
                case IGNORE: {
                    break;
                }
                case LOG: {
                    LOG.debug("Dimension {} tick started before stopping previous tick.", (Object)name);
                    break;
                }
                case STRICT: {
                    throw new IllegalStateException("Dimension " + name + " tick started before stopping previous tick.");
                }
            }
            timer.close();
            timer = null;
        }
        String id_str = Integer.toString(MinecraftCollector.getDimensionId(dim));
        timer = ((Histogram.Child)this.dim_tick_seconds.labels(id_str, name)).startTimer();
        this.dim_tick_timers.put(dim, timer);
    }

    public void startServerTick() {
        if (this.server_tick_timer != null) {
            throw new IllegalStateException("Server tick started before stopping previous tick.");
        }
        this.server_tick_timer = this.server_tick_seconds.startTimer();
    }

    public void stopDimensionTick(ResourceKey<Level> dim) {
        String name = dim.location().getPath();
        Histogram.Timer timer = this.dim_tick_timers.remove(dim);
        if (timer == null) {
            switch (this.config.collector_mc_dimension_tick_errors) {
                case IGNORE: {
                    break;
                }
                case LOG: {
                    LOG.debug("Dimension {} tick stopped without an active tick.", (Object)name);
                    break;
                }
                case STRICT: {
                    throw new IllegalStateException("Dimension " + name + " tick stopped without an active tick.");
                }
            }
            return;
        }
        timer.close();
    }

    public void stopServerTick() {
        if (this.server_tick_timer == null) {
            throw new IllegalStateException("Server tick stopped without an active tick.");
        }
        this.server_tick_timer.observeDuration();
        this.server_tick_timer = null;
    }

    private record EntityKey(String dim, int dim_id, String type) {
    }
}

