/*
 * Decompiled with CFR 0.152.
 */
package de.hellbz.forge.Utils;

import de.hellbz.forge.Utils.Config;
import de.hellbz.forge.Utils.Data;
import de.hellbz.forge.Utils.FileOperation;
import de.hellbz.forge.Utils.Net;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class Remote {
    private static final String API_URL = "https://api.hellbz.de/update/forge-server-starter/";

    public static void checkForUpdate() {
        String localVersionPath = "/res/modInfo.json";
        String remoteVersionUrl = "https://raw.githubusercontent.com/HellBz/Forge-Server-Starter/master" + localVersionPath;
        String localVersion = Data.getJsonValue((String)FileOperation.downloadOrReadFile(localVersionPath).getContent(), "version");
        if (Config.configProps.getProperty("unique_id_request", "true").equals("true")) {
            try {
                Remote.requestUniqueID(localVersion);
            }
            catch (IOException e) {
                Data.LogDebug("An Error Occurs, while calling API : " + e);
            }
        }
        FileOperation remoteContent = FileOperation.downloadOrReadFile(remoteVersionUrl);
        String remoteVersion = null;
        if (remoteContent.getResponseCode() == 200) {
            remoteVersion = Data.getJsonValue((String)remoteContent.getContent(), "version");
        }
        if ((remoteVersion != null || localVersion != null) && Net.isConnected) {
            Data.LogDebug("Local version: " + localVersion);
            Data.LogDebug("Remote version: " + remoteVersion);
            Data.VersionComparator versionComparator = new Data.VersionComparator();
            String committedDate = Remote.getGitHubCommittedDate("https://github.com/HellBz/Forge-Server-Starter/commits/master/res/modInfo.json");
            if (versionComparator.compare(localVersion, remoteVersion) < 0) {
                Data.LogWarning("----------------------------------------------------------------");
                Data.LogWarning("\u001b[0;96mUpdate is available\u001b[0m, New Version: \u001b[0;92m" + remoteVersion + "\u001b[0m" + ", Your local Version is. " + "\u001b[1;31m" + localVersion + " " + "\u001b[0m");
                Data.LogWarning("Latest Update if from: " + committedDate + " on GitHub.");
                Data.LogWarning("You find the newest Versions there:");
                Data.LogWarning("https://www.curseforge.com/minecraft/mc-mods/forge-server-starter");
                Data.LogWarning("----------------------------------------------------------------");
            } else {
                Data.LogInfo("----------------------------------------------------------------");
                Data.LogInfo("You have the latest version of F-S-S, with: \u001b[0;92m" + remoteVersion + "\u001b[0m");
                Data.LogInfo("Latest Update if from: " + committedDate + " on GitHub.");
                Data.LogInfo("You find all Versions there:");
                Data.LogInfo("https://www.curseforge.com/minecraft/mc-mods/forge-server-starter");
                Data.LogInfo("----------------------------------------------------------------");
            }
        }
    }

    public static String getGitHubCommittedDate(String url) {
        Pattern pattern;
        Matcher matcher;
        FileOperation remoteReadResult;
        String committedDate = null;
        if (Net.isConnected && (remoteReadResult = FileOperation.downloadOrReadFile(url)).getResponseCode() == 200 && (matcher = (pattern = Pattern.compile("\"committedDate\":\"(.*?)\"")).matcher(remoteReadResult.getContent().toString())).find()) {
            committedDate = matcher.group(1);
        }
        return committedDate;
    }

    public static void requestUniqueID(String localVersion) throws IOException {
        String uniqueId = Config.configProps.getProperty("unique_id", "");
        String response = Remote.sendApiRequest(localVersion, uniqueId);
        Data.LogDebug("API-UniqueID-Response: " + response);
        try {
            JSONObject dataObject;
            JSONObject jsonResponse = new JSONObject(response);
            String newUniqueId = null;
            if (jsonResponse.has("data") && !jsonResponse.isNull("data") && (dataObject = jsonResponse.getJSONObject("data")).has("unique_id") && !dataObject.isNull("unique_id")) {
                newUniqueId = dataObject.getString("unique_id");
            }
            if (newUniqueId != null && !newUniqueId.equals(uniqueId)) {
                Data.updateProperty("server_starter.conf", "unique_id", newUniqueId);
            }
            if (jsonResponse.has("error") && !jsonResponse.isNull("error") && jsonResponse.has("message") && !jsonResponse.isNull("message") && jsonResponse.getBoolean("error")) {
                Data.LogDebug("API-UniqueID, \u001b[1;31m" + jsonResponse.getString("message") + "\u001b[0m");
            }
        }
        catch (JSONException e) {
            System.err.println("Fehler beim Parsen der JSON-Antwort: " + e.getMessage());
        }
    }

    private static String sendApiRequest(String localVersion, String uniqueId) throws IOException {
        int responseCode;
        String urlString = "https://api.hellbz.de/update/forge-server-starter/?version=" + URLEncoder.encode(localVersion, StandardCharsets.UTF_8.name()) + (!uniqueId.isEmpty() ? "&unique_id=" + URLEncoder.encode(uniqueId, StandardCharsets.UTF_8.name()) : "") + (Config.macAddress != null ? "&macAddress=" + URLEncoder.encode(Config.macAddress, StandardCharsets.UTF_8.name()) : "");
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        String propertiesToPostData = Data.propertiesToURL("server.properties");
        if (propertiesToPostData != null) {
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = propertiesToPostData.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
        }
        if ((responseCode = connection.getResponseCode()) == 200) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                String string = response.toString();
                return string;
            }
        }
        throw new IOException("Failed to get response from the server. HTTP Response Code: " + responseCode);
    }
}

