/*
 * Decompiled with CFR 0.152.
 */
package de.hellbz.forge.Utils.ModLoader;

import de.hellbz.forge.Utils.Data;
import de.hellbz.forge.Utils.FileOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class NeoForge {
    public static Map<String, Map<String, Object>> getVersions() {
        String neoJsonUrl = "https://maven.neoforged.net/api/maven/versions/releases/net/neoforged/neoforge";
        FileOperation getVersionJSON = FileOperation.downloadOrReadFile(neoJsonUrl);
        if (getVersionJSON.getResponseCode() == 200) {
            String jsonString = (String)getVersionJSON.getContent();
            if (jsonString != null) {
                try {
                    JSONObject jsonObject = new JSONObject(jsonString);
                    JSONArray versionsArray = jsonObject.getJSONArray("versions");
                    TreeMap<String, Map<String, Object>> NeoVersions = new TreeMap<String, Map<String, Object>>(Collections.reverseOrder(new Data.VersionComparator()));
                    Data.VersionComparator versionComparator = new Data.VersionComparator();
                    for (int i = 0; i < versionsArray.length(); ++i) {
                        String version = versionsArray.getString(i);
                        String mcVersion = version.split("\\.")[0] + "." + version.split("\\.")[1];
                        Map versionInfo = NeoVersions.getOrDefault("1." + mcVersion, new HashMap());
                        ArrayList versionsObject = versionInfo.getOrDefault("versions", new ArrayList());
                        ArrayList<String> versionsList = new ArrayList<String>();
                        if (versionsObject instanceof List) {
                            for (Object item : (List)versionsObject) {
                                if (item instanceof String) {
                                    versionsList.add((String)item);
                                    continue;
                                }
                                Data.LogDebug("An element was not a String, has been skipped: " + item);
                            }
                        }
                        versionsList.add(version);
                        Collections.reverse(versionsList);
                        versionInfo.put("versions", versionsList);
                        if (!NeoVersions.containsKey("1." + mcVersion) || versionComparator.compare(version, (String)((Map)NeoVersions.get("1." + mcVersion)).get("latest")) > 0) {
                            versionInfo.put("latest", version);
                        }
                        NeoVersions.put("1." + mcVersion, versionInfo);
                    }
                    return NeoVersions;
                }
                catch (Exception e) {
                    Data.LogError("Invalid JSON format.");
                    e.printStackTrace();
                    return null;
                }
            }
            Data.LogError("Failed to load JSON.");
            return null;
        }
        Data.LogError("Fehler beim Lesen der Remote-Datei. Response-Code: " + getVersionJSON.getResponseCode());
        return null;
    }

    public static Map<String, String> getFileLinks(String build) {
        String fileURL = "https://maven.neoforged.net/releases/net/neoforged/neoforge/" + build + "/neoforge-" + build + "-installer.jar";
        String localFilePath = "/neoforge-" + build + "-installer.jar";
        HashMap<String, String> links = new HashMap<String, String>();
        links.put("fileURL", fileURL);
        links.put("localFilePath", localFilePath);
        return links;
    }
}

