/*
 * Decompiled with CFR 0.152.
 */
package de.hellbz.forge.Utils.ModLoader;

import de.hellbz.forge.Utils.Config;
import de.hellbz.forge.Utils.Data;
import de.hellbz.forge.Utils.FileOperation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Forge {
    public static Map<String, Map<String, Object>> getVersions() {
        String forgeJsonUrl = "https://files.minecraftforge.net/net/minecraftforge/forge/promotions_slim.json";
        FileOperation getVersionJSON = FileOperation.downloadOrReadFile(forgeJsonUrl);
        if (getVersionJSON.getResponseCode() == 200) {
            String jsonString = (String)getVersionJSON.getContent();
            if (jsonString != null) {
                try {
                    TreeMap<String, Map<String, Object>> forgeVersions = new TreeMap<String, Map<String, Object>>(Collections.reverseOrder(new Data.VersionComparator()));
                    JSONObject jsonObject = new JSONObject(jsonString);
                    JSONObject promosObject = jsonObject.getJSONObject("promos");
                    Data.VersionComparator versionComparator = new Data.VersionComparator();
                    Iterator<String> keys = promosObject.keys();
                    while (keys.hasNext()) {
                        String key = keys.next();
                        String mcVersion = key.replace("-latest", "").replace("-recommended", "");
                        String forgeVersion = promosObject.getString(key);
                        int check_1_5_2 = versionComparator.compare(mcVersion, "1.5.2");
                        if (check_1_5_2 < 0) continue;
                        Map versionInfo = forgeVersions.getOrDefault(mcVersion, new HashMap());
                        versionInfo.put("versions", versionInfo.getOrDefault("versions", new JSONArray()));
                        ((JSONArray)versionInfo.get("versions")).put(forgeVersion);
                        if (key.endsWith("-recommended")) {
                            versionInfo.put("recommended", forgeVersion);
                        } else {
                            versionInfo.put("latest", forgeVersion);
                        }
                        forgeVersions.put(mcVersion, versionInfo);
                    }
                    return forgeVersions;
                }
                catch (Exception e) {
                    Data.LogError("Invalid JSON format.");
                    e.printStackTrace();
                    return null;
                }
            }
            Data.LogError("Failed to load JSON.");
            return null;
        }
        Data.LogError("Fehler beim Lesen der Remote-Datei. Response-Code: " + getVersionJSON.getResponseCode());
        return null;
    }

    public static Map<String, String> getFileLinks(String version, String build) {
        String fileURL = "";
        String localFilePath = "";
        Data.VersionComparator versionComparator = new Data.VersionComparator();
        int check_1_7_10 = versionComparator.compare(version, "1.7.10");
        int check_1_7_10_pre = versionComparator.compare(version, "1.7.10_pre4");
        int check_1_7_2 = versionComparator.compare(version, "1.7.2");
        int check_1_5_2 = versionComparator.compare(version, "1.5.2");
        if (check_1_5_2 < 0) {
            Data.LogError("!!! Version " + version + " is below 1.5.2 and not Supported for Forge-Server.");
            Config.startupError = true;
        } else if (check_1_7_10 == 0) {
            fileURL = "https://maven.minecraftforge.net/net/minecraftforge/forge/" + version + "-" + build + "-" + version + "/forge-" + version + "-" + build + "-" + version + "-installer.jar";
            localFilePath = "/forge-" + version + "-" + build + "-installer.jar";
        } else if (check_1_7_10_pre == 0) {
            fileURL = "https://maven.minecraftforge.net/net/minecraftforge/forge/" + version + "-" + build + "-prerelease/forge-" + version + "-" + build + "-prerelease-installer.jar";
            localFilePath = "/forge-1.7.10-" + build + "-universal.zip";
        } else if (check_1_7_2 == 0) {
            fileURL = "https://maven.minecraftforge.net/net/minecraftforge/forge/" + version + "-" + build + "-mc172/forge-" + version + "-" + build + "-mc172-installer.jar";
            localFilePath = "/forge-" + version + "-" + build + "-installer.jar";
        } else {
            fileURL = "https://maven.minecraftforge.net/net/minecraftforge/forge/" + version + "-" + build + "/forge-" + version + "-" + build + "-installer.jar";
            localFilePath = "/forge-" + version + "-" + build + "-installer.jar";
        }
        HashMap<String, String> links = new HashMap<String, String>();
        links.put("fileURL", fileURL);
        links.put("localFilePath", localFilePath);
        return links;
    }
}

