/*
 * Decompiled with CFR 0.152.
 */
package de.hellbz.forge.Utils;

import de.hellbz.forge.Utils.Config;
import de.hellbz.forge.Utils.Data;
import de.hellbz.forge.Utils.FileOperation;
import de.hellbz.forge.Utils.ModLoader.Forge;
import de.hellbz.forge.Utils.ModLoader.NeoForge;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Loader {
    public static boolean checkLoaderVersion() throws IOException {
        File[] currentFiles = Config.rootFolder.listFiles();
        Pattern pattern_auto = Pattern.compile("forge-auto-install.txt", 2);
        Boolean autoFile = false;
        String loaderType = null;
        try {
            for (int i = 0; i < currentFiles.length; ++i) {
                Matcher matcher_auto = pattern_auto.matcher(currentFiles[i].getName());
                Matcher matcher_forge = Config.Pattern_Forge.matcher(currentFiles[i].getName());
                if (matcher_auto.find()) {
                    autoFile = true;
                }
                if (!matcher_forge.find()) continue;
                return false;
            }
        }
        catch (Exception e) {
            Config.startupError = true;
            Data.LogWarning(e.getMessage());
        }
        File autoConfigFile = new File("forge-auto-install.txt");
        Config.forgeVersions = Forge.getVersions();
        Config.neoVersions = NeoForge.getVersions();
        if (autoFile.booleanValue() && autoConfigFile.exists()) {
            FileReader autoReader = new FileReader(autoConfigFile);
            Config.autoProps = new Properties();
            Config.autoProps.load(autoReader);
            autoReader.close();
            Config.minecraftVersion = Config.autoProps.getProperty("minecraftVersion");
            loaderType = Config.autoProps.getProperty("loaderType");
            Config.loaderVersion = Config.autoProps.getProperty("loaderVersion");
            if (Config.minecraftVersion == null || Config.minecraftVersion.trim().isEmpty() || loaderType == null || loaderType.trim().isEmpty() || Config.loaderVersion == null || Config.loaderVersion.trim().isEmpty()) {
                FileOperation.downloadOrReadFile("/res/forge-auto-install.txt", Config.rootFolder + File.separator + "forge-auto-install.txt");
                Data.LogWarning("Found Error in the \"forge-auto-install.txt\", saved the File correct, please check the File.");
                Config.startupError = true;
                return false;
            }
            if (!Config.minecraftVersion.matches("(?i)^[0-9.]+$|^latest$")) {
                Data.LogWarning("The Setting minecraftVersion in \"forge-auto-install.txt\", must be \"1.20.4\" or \"latest\".");
                Config.startupError = true;
                return false;
            }
            if (!Config.loaderVersion.matches("(?i)^[0-9.]+$|^latest$|^recommended$")) {
                Data.LogWarning("The Setting loaderVersion in \"forge-auto-install.txt\", must be \"1.20.4\" or \"latest\" or \"recommended\".");
                Config.startupError = true;
                return false;
            }
            if (!loaderType.matches("(?i)^forge$|^(neo)?forge$")) {
                Data.LogWarning("The Setting loaderType in \"forge-auto-install.txt\", must be \"forge\" or \"neoforge\".");
                Config.startupError = true;
                return false;
            }
            if (loaderType.equalsIgnoreCase("forge")) {
                Config.isForge = true;
                if (Config.minecraftVersion.equalsIgnoreCase("latest")) {
                    Config.minecraftVersion = Config.forgeVersions.keySet().iterator().next();
                }
                if (Config.forgeVersions.containsKey(Config.minecraftVersion) && Config.loaderVersion.equalsIgnoreCase("latest")) {
                    Config.loaderVersion = Config.forgeVersions.get(Config.minecraftVersion).get("latest").toString();
                } else if (Config.forgeVersions.containsKey(Config.minecraftVersion) && Config.forgeVersions.get(Config.minecraftVersion).containsKey("recommended") && Config.loaderVersion.equalsIgnoreCase("recommended")) {
                    Config.loaderVersion = Config.forgeVersions.get(Config.minecraftVersion).get("recommended").toString();
                }
            } else if (loaderType.equalsIgnoreCase("neoforge")) {
                Config.isForge = false;
                if (Config.minecraftVersion.equalsIgnoreCase("latest")) {
                    Config.minecraftVersion = Config.neoVersions.keySet().iterator().next();
                }
                if (Config.neoVersions.containsKey(Config.minecraftVersion) && Config.loaderVersion.equalsIgnoreCase("latest")) {
                    Config.loaderVersion = Config.neoVersions.get(Config.minecraftVersion).get("latest").toString();
                }
            }
            Data.LogInfo("Found \"forge-auto-install.txt\" with Minecraft-Version " + Config.minecraftVersion + " and " + (Config.isForge ? "Forge" : "NeoForge") + " " + Config.loaderVersion);
            return true;
        }
        Data.LogWarning("Not found the \"forge-auto-install.txt\", start guided installation-Process.");
        Data.LogInfo("FORGE is available in the following Versions:");
        String ForgeVersionsAsString = String.join((CharSequence)", ", Config.forgeVersions.keySet());
        Data.LogInfo(ForgeVersionsAsString);
        Data.LogInfo("NeoFORGED is available in the following Versions:");
        String NeoForgeVersionsAsString = String.join((CharSequence)", ", Config.neoVersions.keySet());
        Data.LogInfo(NeoForgeVersionsAsString);
        Scanner in = new Scanner(System.in);
        String latestMinecraftReleaseVersion = null;
        FileOperation fileDownload = FileOperation.downloadOrReadFile("https://piston-meta.mojang.com/mc/game/version_manifest_v2.json");
        if (fileDownload != null && fileDownload.getResponseCode() == 200) {
            latestMinecraftReleaseVersion = Data.getJsonValue(fileDownload.getContent().toString(), "latest/release");
        }
        Data.LogInfo("Wich MINECRAFT-Version you like to install [ eg. " + latestMinecraftReleaseVersion + " ]:");
        String mcVersionInput = in.nextLine();
        StringBuilder mcVersionFiltered = new StringBuilder();
        Config.minecraftVersion = String.valueOf(mcVersionInput);
        if (Config.forgeVersions.containsKey(Config.minecraftVersion)) {
            Data.LogInfo("Wich FORGE-Version you like to install [ Latest:  " + (Config.forgeVersions.containsKey(Config.minecraftVersion) ? (String)Config.forgeVersions.get(Config.minecraftVersion).get("latest") : "") + ", Recommended:  " + (Config.forgeVersions.containsKey(Config.minecraftVersion) ? (String)Config.forgeVersions.get(Config.minecraftVersion).get("recommended") : "") + " ]:");
            Data.LogInfo("You can also install all other Versions, listed on this Site: https://files.minecraftforge.net/net/minecraftforge/forge/index_" + Config.minecraftVersion + ".html");
        }
        if (Config.neoVersions.containsKey(Config.minecraftVersion)) {
            Data.LogInfo("Wich NeoFORGED-Version you like to install [ Latest:  " + (Config.neoVersions.containsKey(Config.minecraftVersion) ? (String)Config.neoVersions.get(Config.minecraftVersion).get("latest") : "") + " ]:");
            Data.LogInfo("You can also install all other Versions, listed on this Site: https://projects.neoforged.net/neoforged/neoforge");
        }
        if (!Config.forgeVersions.containsKey(Config.minecraftVersion) && !Config.neoVersions.containsKey(Config.minecraftVersion)) {
            Data.LogError("The Minecraft-Version \"" + Config.minecraftVersion + "\" not exists, restart Downloader.");
            Loader.checkLoaderVersion();
            return false;
        }
        String LoaderVersionInput = in.nextLine();
        Config.loaderVersion = String.valueOf(LoaderVersionInput);
        Pattern pattern = Pattern.compile(Config.loaderVersion);
        Matcher neoMatcher = pattern.matcher(Config.neoVersions.toString());
        if (neoMatcher.find()) {
            Config.isForge = false;
            return true;
        }
        Config.isForge = true;
        return true;
    }

    public static boolean downloadLoader() {
        if (Config.minecraftVersion == null || Config.loaderVersion == null) {
            Data.LogWarning("One of the variables (minecraftVersion or loaderVersion) is not set properly.");
            Config.startupError = true;
            return false;
        }
        Map<String, String> links = null;
        links = !Config.isForge ? NeoForge.getFileLinks(Config.loaderVersion) : Forge.getFileLinks(Config.minecraftVersion, Config.loaderVersion);
        if (!Config.startupError) {
            FileOperation fileDownload = FileOperation.downloadOrReadFile(links.get("fileURL"), Config.rootFolder + links.get("localFilePath"));
            if (fileDownload != null && fileDownload.getResponseCode() == 200) {
                Data.LogInfo("Loader downloaded: " + links.get("fileURL") + " to " + Config.rootFolder + links.get("localFilePath"));
                return true;
            }
            Data.LogError("Error reading remote file. Response code: " + fileDownload.getResponseCode());
            return false;
        }
        return false;
    }

    public static boolean checkLocalInstaller() {
        return Loader.checkLocalInstaller(false);
    }

    public static boolean checkLocalInstaller(boolean output) {
        File[] currentFiles = Config.rootFolder.listFiles();
        try {
            for (int i = 0; i < currentFiles.length; ++i) {
                Matcher matcherForge = Config.Pattern_Forge.matcher(currentFiles[i].getName());
                Matcher matcherNeoForge = Config.Pattern_NeoForge.matcher(currentFiles[i].getName());
                if (matcherForge.find()) {
                    Config.minecraftVersion = matcherForge.group(1);
                    Config.loaderVersion = matcherForge.group(2);
                    Config.installerFile = currentFiles[i].getName();
                    if (output) {
                        Data.LogInfo("Match found INSTALLER with MC-Version " + Config.minecraftVersion + " and Forge " + Config.loaderVersion);
                    }
                    return true;
                }
                if (!matcherNeoForge.find()) continue;
                Config.minecraftVersion = "1." + matcherNeoForge.group(1);
                Config.loaderVersion = matcherNeoForge.group(1);
                Config.installerFile = currentFiles[i].getName();
                if (output) {
                    Data.LogInfo("Match found INSTALLER with MC-Version " + Config.minecraftVersion + " and NeoForge " + Config.loaderVersion);
                }
                return true;
            }
        }
        catch (Exception e) {
            Config.startupError = true;
            Data.LogWarning(e.getMessage());
        }
        return false;
    }

    public static boolean installLoader() {
        if (Config.installerFile != null) {
            try {
                Process start;
                String filename = new File(Config.installerFile).getName();
                Data.LogInfo("Attempting to start Server " + Config.installerFile);
                Data.LogDebug("Filename: " + filename);
                Data.LogDebug("Directory: " + Config.rootFolder);
                Data.LogInfo("Starting installation of Loader, installer output incoming");
                Data.LogInfo("Check log from installer for more information");
                String javaStart = "java";
                if (Config.configProps.getProperty("java_path") != null && !Config.configProps.getProperty("java_path").equals("java")) {
                    javaStart = Config.configProps.getProperty("java_path");
                    Data.LogDebug("Use for Installer Custom Java Path: " + Config.configProps.getProperty("java_path"));
                }
                Process installer = start = new ProcessBuilder(javaStart, "-jar", Config.installerFile, "nogui", "--installServer").directory(Config.rootFolder).start();
                Scanner serverLog = new Scanner(start.getInputStream());
                while (serverLog.hasNextLine()) {
                    String println = serverLog.nextLine();
                    Data.LogCustom(println, "FORGE-Installer", "\u001b[35m");
                }
                installer.waitFor();
                File libraries_dir = new File("libraries/");
                if (libraries_dir.exists()) {
                    File installerFileRunSh;
                    File installerFileRunBat;
                    File installerFileLog;
                    Data.LogInfo("Done installing loader...");
                    Data.LogInfo("Deleting leftover Files, after installation!");
                    File installerFile = new File(Config.rootFolder + File.separator + Config.installerFile);
                    if (installerFile.exists()) {
                        Files.delete(installerFile.toPath());
                    }
                    if ((installerFileLog = new File(Config.rootFolder + File.separator + Config.installerFile + ".log")).exists()) {
                        Files.delete(installerFileLog.toPath());
                    }
                    if ((installerFileRunBat = new File(Config.rootFolder + File.separator + "run.bat")).exists()) {
                        Files.delete(installerFileRunBat.toPath());
                    }
                    if ((installerFileRunSh = new File(Config.rootFolder + File.separator + "run.sh")).exists()) {
                        Files.delete(installerFileRunSh.toPath());
                    }
                    return false;
                }
                Data.LogWarning("Problem while installing FORGE, \"libraries\"-Folder not successfully created.");
                Config.startupError = true;
                return true;
            }
            catch (IOException | InterruptedException e) {
                Data.LogWarning("Problem while installing Loader from " + Config.rootFolder + File.separator + ' ' + e);
                Config.startupError = true;
                return true;
            }
        }
        Data.LogWarning("No \"libraries\"-Folders and no Installer-File could be found!");
        Config.startupError = true;
        return true;
    }

    public static void checkLoaderFolder() {
        Data.LogDebug("Current Path: " + Config.rootFolder);
        if (Config.librariesFolder.exists() && Config.librariesFolder.isDirectory() && (Config.minecraftForgeFolder.exists() && Config.minecraftForgeFolder.isDirectory() || Config.neoForgeFolder.exists() && Config.neoForgeFolder.isDirectory())) {
            boolean bl = Config.isForge = Config.minecraftForgeFolder.exists() && Config.minecraftForgeFolder.isDirectory();
            File loaderFolder = Config.isForge ? Config.minecraftForgeFolder : (Config.neoForgeFolder.exists() && Config.neoForgeFolder.isDirectory() ? Config.neoForgeFolder : null);
            Pattern pattern = Config.isForge ? Pattern.compile("(?<minecraftVersion>[.0-9]+)-(?<loaderVersion>[.0-9]+)") : Pattern.compile("(?<minecraftVersion>\\d+\\.\\d+)\\.(?<loaderVersion>\\d+).*");
            String LoaderPath = loaderFolder.getPath().replace("\\", "/");
            Data.LogDebug(LoaderPath + " exists");
            FileFilter folderFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && new File(file, "unix_args.txt").exists() && new File(file, "win_args.txt").exists();
                }
            };
            File[] versionFolders = loaderFolder.listFiles(folderFilter);
            if (versionFolders != null && versionFolders.length > 0) {
                Arrays.sort(versionFolders, Comparator.comparing(File::getName, new Data.VersionComparator()).reversed());
                File latestVersionFolder = versionFolders[0];
                if (latestVersionFolder != null) {
                    String systemPrefix = Config.OS.contains("win") ? "win_" : "unix_";
                    String startFolder = "libraries" + File.separator;
                    int librariesIndex = latestVersionFolder.getAbsolutePath().indexOf(startFolder);
                    if (librariesIndex >= 0) {
                        startFolder = latestVersionFolder.getAbsolutePath().substring(librariesIndex);
                    }
                    Data.LogDebug("Using " + (Config.OS.contains("win") ? "WINDOWS" : "UNIX") + " System-Parameter for " + (Config.isForge ? "Forge" : "NeoForge") + " folder");
                    Config.startupFile = startFolder + File.separator + systemPrefix + "args.txt";
                    Matcher matcher = pattern.matcher(latestVersionFolder.getName());
                    if (matcher.matches()) {
                        Config.minecraftVersion = Config.isForge ? matcher.group("minecraftVersion") : "1." + matcher.group("minecraftVersion");
                        Config.loaderVersion = Config.isForge ? matcher.group("loaderVersion") : latestVersionFolder.getName();
                        Data.LogInfo("Found Minecraft: " + Config.minecraftVersion + " with " + (Config.isForge ? "Forge" : "NeoForge") + "-Version: " + Config.loaderVersion);
                    }
                    Data.LogDebug("Found MC-Version: " + Config.minecraftVersion);
                    Data.LogDebug("Found Loader-Version: " + Config.loaderVersion);
                    Data.LogDebug("Startup-File: " + Config.startupFile);
                    Data.LogDebug("Required files exist in the latest version folder of " + loaderFolder.getPath());
                } else {
                    Data.LogDebug("Required files do not exist in the latest version folder of " + loaderFolder.getPath());
                }
            }
        }
    }

    public static void checkLocalFolder() {
        Data.VersionComparator versionComparator = new Data.VersionComparator();
        if (versionComparator.compare(Config.minecraftVersion, "1.17.0") < 0 || Config.isForge && versionComparator.compare(Config.minecraftVersion, "1.20.4") >= 0) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return Config.Pattern_Forge_startfile.matcher(name).matches();
                }
            };
            File[] matchingFiles = Config.rootFolder.listFiles(filter);
            if (matchingFiles != null && matchingFiles.length > 0) {
                File matchingFile = matchingFiles[0];
                Matcher matcher = Config.Pattern_Forge_startfile.matcher(matchingFile.getName());
                if (matcher.matches()) {
                    Config.minecraftVersion = matcher.group(1);
                    Config.loaderVersion = matcher.group(2);
                    Config.startupFile = matchingFile.getName();
                    Data.LogInfo("Found Minecraft: " + Config.minecraftVersion + " with Forge " + Config.loaderVersion);
                    return;
                }
                Data.LogDebug("Found file in root directory:");
                Data.LogDebug("File: " + matchingFile.getName());
                Data.LogDebug("Absolute path: " + matchingFile.getAbsolutePath());
                Data.LogDebug("Size: " + matchingFile.length() + " bytes");
                Data.LogDebug("Last modified: " + matchingFile.lastModified());
            } else {
                Data.LogWarning("No Forge-Version could be Found!");
                Config.startupError = true;
            }
        }
    }
}

