/*
 * Decompiled with CFR 0.152.
 */
package de.hellbz.forge.Utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class FileOperation {
    private final int responseCode;
    private final Object content;
    private final Object additionalData;

    public FileOperation(int responseCode, Object content, Object additionalData) {
        this.responseCode = responseCode;
        this.content = content;
        this.additionalData = additionalData;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Object getContent() {
        return this.content;
    }

    public Object getAdditionalData() {
        return this.additionalData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileOperation callUrlWithoutResponse(String urlString) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                FileOperation fileOperation = new FileOperation(responseCode, "URL successfully called, response ignored.", null);
                return fileOperation;
            }
            FileOperation fileOperation = new FileOperation(responseCode, null, "Server returned an error.");
            return fileOperation;
        }
        catch (IOException e) {
            FileOperation fileOperation = new FileOperation(500, null, "URL call failed: " + e.getMessage());
            return fileOperation;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static FileOperation downloadOrReadFile(File source) {
        return FileOperation.downloadOrReadFile(source, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileOperation downloadOrReadFile(File source, String destinationPath) {
        try (InputStream in = Files.newInputStream(source.toPath(), new OpenOption[0]);){
            FileOperation fileOperation = FileOperation.readFileContent(in, destinationPath);
            return fileOperation;
        }
        catch (IOException e) {
            return new FileOperation(500, null, "File-Operation failed: " + e.getMessage());
        }
    }

    public static FileOperation downloadOrReadFile(String source) {
        return FileOperation.downloadOrReadFile(source, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileOperation downloadOrReadFile(String source, String destinationPath) {
        boolean isUrl = source.toLowerCase().startsWith("http://") || source.toLowerCase().startsWith("https://");
        try (InputStream in = isUrl ? new URL(source).openStream() : (FileOperation.class.getResourceAsStream(source) != null ? FileOperation.class.getResourceAsStream(source) : Files.newInputStream(Paths.get(source, new String[0]), new OpenOption[0]));){
            FileOperation fileOperation = FileOperation.readFileContent(in, destinationPath);
            return fileOperation;
        }
        catch (IOException e) {
            return new FileOperation(500, null, "File-Operation failed: " + e.getMessage());
        }
    }

    private static FileOperation readFileContent(InputStream in, String destinationPath) throws IOException {
        String line;
        if (destinationPath != null && !destinationPath.isEmpty()) {
            Files.copy(in, Paths.get(destinationPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            return new FileOperation(200, "Datei erfolgreich gespeichert", true);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        StringBuilder content = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            content.append(line).append("\n");
        }
        return new FileOperation(200, content.toString(), null);
    }

    public static void main(String[] args) {
        FileOperation localReadResult = FileOperation.downloadOrReadFile(new File("local_file.txt"));
        System.out.println("Lokaler Dateiinhalt: " + localReadResult.getContent());
        FileOperation localSaveReadResult = FileOperation.downloadOrReadFile(new File("local_file.txt"), "destination_path.txt");
        System.out.println("Lokaler Dateiinhalt (gespeichert): " + localSaveReadResult.getContent());
        FileOperation localExtractResult = FileOperation.downloadOrReadFile("/res/version.xml", "version.xml");
        System.out.println("Lokaler Dateiinhalt (gespeichert): " + localExtractResult.getContent());
        FileOperation remoteReadResult = FileOperation.downloadOrReadFile("https://example.com/remote_file.txt");
        if (remoteReadResult.getResponseCode() == 200) {
            System.out.println("Remote-Dateiinhalt: " + remoteReadResult.getContent());
        } else {
            System.out.println("Fehler beim Lesen der Remote-Datei. Response-Code: " + remoteReadResult.getResponseCode());
            System.out.println("Zus\u00e4tzliche Informationen: " + remoteReadResult.getAdditionalData());
        }
        FileOperation remoteSaveReadResult = FileOperation.downloadOrReadFile("https://mediafilez.forgecdn.net/files/5113/957/Server-Files-0.2.48.zip", "Server-Files-0.2.48.zip");
        if (remoteSaveReadResult.getResponseCode() == 200) {
            System.out.println("Remote-Dateiinhalt (gespeichert): " + remoteSaveReadResult.getContent());
            System.out.println("Datei erfolgreich gespeichert: " + remoteSaveReadResult.getAdditionalData());
        } else {
            System.out.println("Fehler beim Lesen der Remote-Datei. Response-Code: " + remoteSaveReadResult.getResponseCode());
            System.out.println("Zus\u00e4tzliche Informationen: " + remoteSaveReadResult.getAdditionalData());
        }
    }
}

