/*
 * Decompiled with CFR 0.152.
 */
package de.hellbz.forge.Utils;

import de.hellbz.forge.Utils.Config;
import de.hellbz.forge.Utils.Data;
import de.hellbz.forge.Utils.FileOperation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;

public class Document {
    public static void Eula() throws IOException {
        File eulaFile = new File("eula.txt");
        boolean eulaFileWrite = false;
        if (eulaFile.exists()) {
            Properties eulaProps = new Properties();
            FileReader eulaReader = new FileReader(eulaFile);
            eulaProps.load(eulaReader);
            eulaReader.close();
            if (Objects.equals(eulaProps.getProperty("eula"), "false")) {
                eulaFileWrite = true;
                Data.LogInfo("Set Eula-File to true");
            } else {
                Data.LogInfo("Eula-File is already accepted.");
            }
        } else if (eulaFile.createNewFile()) {
            eulaFileWrite = true;
            Data.LogInfo("Creating a new Eula-File");
        }
        if (eulaFileWrite) {
            FileWriter eulaWriter = new FileWriter(eulaFile);
            Properties eulaPropsNew = new Properties();
            eulaPropsNew.setProperty("eula", "true");
            eulaPropsNew.store(eulaWriter, "By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).");
            eulaWriter.close();
        }
    }

    public static void StartFile() {
        Data.LogInfo("Creating " + (Config.OS.contains("win") ? "WINDOWS" : "UNIX") + "  Start-File.");
        try {
            Files.write(Paths.get(Config.rootFolder + File.separator + "start_server." + (Config.OS.contains("win") ? "bat" : "sh"), new String[0]), (Config.OS.contains("win") ? Config.fileStartWinFileString : Config.fileStartLnxFileString).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.write(Paths.get(Config.rootFolder + File.separator + "generate_auto_installation_file." + (Config.OS.contains("win") ? "bat" : "sh"), new String[0]), (Config.OS.contains("win") ? Config.fileAutoWinFileString : Config.fileAutoLnxFileString).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            FileOperation.downloadOrReadFile("/res/start_server" + (Config.OS.contains("win") ? "_win" : "_lnx") + ".txt", Config.rootFolder + File.separator + "start_server." + (Config.OS.contains("win") ? "bat" : "sh"));
            FileOperation.downloadOrReadFile("/res/generate_auto_installation_file" + (Config.OS.contains("win") ? "_win" : "_lnx") + ".txt", Config.rootFolder + File.separator + "generate_auto_installation_file." + (Config.OS.contains("win") ? "bat" : "sh"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void LogFile() {
        if (Objects.equals(Config.configProps.getProperty("log_to_file"), "true")) {
            String logFolder = "logs" + File.separator;
            File directory = new File(logFolder);
            if (!directory.exists() && !directory.mkdirs()) {
                return;
            }
            File file = new File(logFolder + "server-starter.log");
            if (file.exists() && file.isFile() && !file.delete()) {
                return;
            }
            if (!file.exists()) {
                try {
                    boolean isFileCreated = file.createNewFile();
                    if (!isFileCreated) {
                        Data.LogDebug("The file \"server-starter.log\" could not be created.");
                    }
                }
                catch (IOException e) {
                    Data.LogDebug("Failed to create the file: " + file.getPath() + " Message: " + e);
                }
            }
        }
    }

    public static boolean checkExist(String startup_file) {
        if (startup_file != null) {
            File check_file = new File(startup_file);
            if (!check_file.exists()) {
                Data.LogWarning("Start-File cannot be Found. ");
                Config.startupError = true;
                return false;
            }
            Config.startupError = false;
            return true;
        }
        Data.LogWarning("Start-File is empty!");
        Config.startupError = true;
        return false;
    }

    public static byte[] cacheFile(String remoteFileURL, String localFileURL, long cacheTimeMillis) throws IOException {
        byte[] fileContent;
        Throwable throwable;
        URL remoteURL = new URL(remoteFileURL);
        Path localFilePath = Paths.get(localFileURL, new String[0]);
        Path parentDirectory = localFilePath.getParent();
        if (parentDirectory != null && !Files.exists(parentDirectory, new LinkOption[0])) {
            Files.createDirectories(parentDirectory, new FileAttribute[0]);
        }
        if (Files.exists(localFilePath, new LinkOption[0])) {
            long lastModifiedTime = Files.getLastModifiedTime(localFilePath, new LinkOption[0]).toMillis();
            long currentTime = new Date().getTime();
            if (currentTime - lastModifiedTime < cacheTimeMillis) {
                return Files.readAllBytes(localFilePath);
            }
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            throwable = null;
            try (InputStream in = remoteURL.openStream();){
                int bytesRead;
                byte[] data = new byte[1024];
                while ((bytesRead = in.read(data)) != -1) {
                    buffer.write(data, 0, bytesRead);
                }
                fileContent = buffer.toByteArray();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            if (Files.exists(localFilePath, new LinkOption[0])) {
                return Files.readAllBytes(localFilePath);
            }
            throw e;
        }
        throwable = null;
        try (OutputStream out = Files.newOutputStream(localFilePath, new OpenOption[0]);){
            out.write(fileContent);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        return fileContent;
    }

    public static String getJarFileName() {
        String defaultName = "minecraft_server.jar";
        try {
            Path jarPath = Paths.get(System.getProperty("java.class.path"), new String[0]);
            if (Files.exists(jarPath, new LinkOption[0]) && Files.isRegularFile(jarPath, new LinkOption[0])) {
                defaultName = jarPath.getFileName().toString();
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        return defaultName;
    }

    public static boolean getJarFileName(boolean checkExistence) {
        if (!checkExistence) {
            return false;
        }
        try {
            Path jarPath = Paths.get(System.getProperty("java.class.path"), new String[0]);
            return Files.exists(jarPath, new LinkOption[0]) && Files.isRegularFile(jarPath, new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(Document.getJarFileName());
        System.out.println(Document.getJarFileName(true));
    }
}

