/*
 * Decompiled with CFR 0.152.
 */
package de.hellbz.forge.Utils;

import de.hellbz.forge.Utils.Config;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Data {
    public static final String TXT_RESET = "\u001b[0m";
    public static final String TXT_BLACK = "\u001b[30m";
    public static final String TXT_RED = "\u001b[31m";
    public static final String TXT_GREEN = "\u001b[32m";
    public static final String TXT_YELLOW = "\u001b[33m";
    public static final String TXT_BLUE = "\u001b[34m";
    public static final String TXT_PURPLE = "\u001b[35m";
    public static final String TXT_CYAN = "\u001b[36m";
    public static final String TXT_WHITE = "\u001b[37m";
    public static final String BG_BLACK = "\u001b[40m";
    public static final String BG_RED = "\u001b[41m";
    public static final String BG_GREEN = "\u001b[42m";
    public static final String BG_YELLOW = "\u001b[43m";
    public static final String BG_BLUE = "\u001b[44m";
    public static final String BG_PURPLE = "\u001b[45m";
    public static final String BG_CYAN = "\u001b[46m";
    public static final String BG_WHITE = "\u001b[47m";
    public static final String RESET = "\u001b[0m";
    public static final String BLACK = "\u001b[0;30m";
    public static final String RED = "\u001b[0;31m";
    public static final String GREEN = "\u001b[0;32m";
    public static final String YELLOW = "\u001b[0;33m";
    public static final String BLUE = "\u001b[0;34m";
    public static final String PURPLE = "\u001b[0;35m";
    public static final String CYAN = "\u001b[0;36m";
    public static final String WHITE = "\u001b[0;37m";
    public static final String BLACK_BOLD = "\u001b[1;30m";
    public static final String RED_BOLD = "\u001b[1;31m";
    public static final String GREEN_BOLD = "\u001b[1;32m";
    public static final String YELLOW_BOLD = "\u001b[1;33m";
    public static final String BLUE_BOLD = "\u001b[1;34m";
    public static final String PURPLE_BOLD = "\u001b[1;35m";
    public static final String CYAN_BOLD = "\u001b[1;36m";
    public static final String WHITE_BOLD = "\u001b[1;37m";
    public static final String BLACK_UNDERLINED = "\u001b[4;30m";
    public static final String RED_UNDERLINED = "\u001b[4;31m";
    public static final String GREEN_UNDERLINED = "\u001b[4;32m";
    public static final String YELLOW_UNDERLINED = "\u001b[4;33m";
    public static final String BLUE_UNDERLINED = "\u001b[4;34m";
    public static final String PURPLE_UNDERLINED = "\u001b[4;35m";
    public static final String CYAN_UNDERLINED = "\u001b[4;36m";
    public static final String WHITE_UNDERLINED = "\u001b[4;37m";
    public static final String BLACK_BACKGROUND = "\u001b[40m";
    public static final String RED_BACKGROUND = "\u001b[41m";
    public static final String GREEN_BACKGROUND = "\u001b[42m";
    public static final String YELLOW_BACKGROUND = "\u001b[43m";
    public static final String BLUE_BACKGROUND = "\u001b[44m";
    public static final String PURPLE_BACKGROUND = "\u001b[45m";
    public static final String CYAN_BACKGROUND = "\u001b[46m";
    public static final String WHITE_BACKGROUND = "\u001b[47m";
    public static final String BLACK_BRIGHT = "\u001b[0;90m";
    public static final String RED_BRIGHT = "\u001b[0;91m";
    public static final String GREEN_BRIGHT = "\u001b[0;92m";
    public static final String YELLOW_BRIGHT = "\u001b[0;93m";
    public static final String BLUE_BRIGHT = "\u001b[0;94m";
    public static final String PURPLE_BRIGHT = "\u001b[0;95m";
    public static final String CYAN_BRIGHT = "\u001b[0;96m";
    public static final String WHITE_BRIGHT = "\u001b[0;97m";
    public static final String BLACK_BOLD_BRIGHT = "\u001b[1;90m";
    public static final String RED_BOLD_BRIGHT = "\u001b[1;91m";
    public static final String GREEN_BOLD_BRIGHT = "\u001b[1;92m";
    public static final String YELLOW_BOLD_BRIGHT = "\u001b[1;93m";
    public static final String BLUE_BOLD_BRIGHT = "\u001b[1;94m";
    public static final String PURPLE_BOLD_BRIGHT = "\u001b[1;95m";
    public static final String CYAN_BOLD_BRIGHT = "\u001b[1;96m";
    public static final String WHITE_BOLD_BRIGHT = "\u001b[1;97m";
    public static final String BLACK_BACKGROUND_BRIGHT = "\u001b[0;100m";
    public static final String RED_BACKGROUND_BRIGHT = "\u001b[0;101m";
    public static final String GREEN_BACKGROUND_BRIGHT = "\u001b[0;102m";
    public static final String YELLOW_BACKGROUND_BRIGHT = "\u001b[0;103m";
    public static final String BLUE_BACKGROUND_BRIGHT = "\u001b[0;104m";
    public static final String PURPLE_BACKGROUND_BRIGHT = "\u001b[0;105m";
    public static final String CYAN_BACKGROUND_BRIGHT = "\u001b[0;106m";
    public static final String WHITE_BACKGROUND_BRIGHT = "\u001b[0;107m";

    public static void LogInfo(String message) {
        System.out.println(Data.CurrentTime() + TXT_GREEN + "[F-S-S/INFO] " + "\u001b[0m" + message);
        try {
            Data.doLog(Data.CurrentTime() + "[F-S-S/INFO] " + Data.cleanLog(message));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void LogWarning(String message) {
        System.out.println(Data.CurrentTime() + TXT_YELLOW + "[F-S-S/WARNING] " + "\u001b[0m" + message);
        try {
            Data.doLog(Data.CurrentTime() + "[F-S-S/WARNING] " + Data.cleanLog(message));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void LogError(String message) {
        System.out.println(Data.CurrentTime() + TXT_RED + "[F-S-S/ERROR] " + "\u001b[0m" + message);
        try {
            Data.doLog(Data.CurrentTime() + "[F-S-S/ERROR] " + Data.cleanLog(message));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void LogDebug(String message) {
        if (Objects.equals(Config.configProps.getProperty("debug"), "true")) {
            System.out.println(Data.CurrentTime() + TXT_CYAN + "[F-S-S/DEBUG] " + "\u001b[0m" + message);
            try {
                Data.doLog(Data.CurrentTime() + "[F-S-S/DEBUG] " + Data.cleanLog(message));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void LogCustom(String message, String name, String color) {
        System.out.println(Data.CurrentTime() + color + "[F-S-S/" + name + "] " + "\u001b[0m" + message);
        try {
            Data.doLog(Data.CurrentTime() + "[F-S-S/" + name + "] " + Data.cleanLog(message));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String CurrentTime() {
        if (!Config.configProps.getProperty("timezone").equals("UTC")) {
            ZoneId z = ZoneId.of(Config.configProps.getProperty("timezone"));
            return "[" + ZonedDateTime.now(z).format(DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT)) + "] ";
        }
        return "[" + ZonedDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT)) + "] ";
    }

    private static String cleanLog(String message) {
        return message.replaceAll("\\x1b\\[[\\d;]*m", "");
    }

    public static void doLog(String message) throws IOException {
        if (Objects.equals(Config.configProps.getProperty("log_to_file"), "true")) {
            FileWriter fileWriter = new FileWriter("logs/server-starter.log", true);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println(message);
            printWriter.close();
        }
    }

    public static boolean isReallyHeadless() {
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        try {
            GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            return screenDevices == null || screenDevices.length == 0;
        }
        catch (HeadlessException e) {
            e.printStackTrace();
            return true;
        }
    }

    public static void checkContent(String startup_file) {
        File check_file = new File(startup_file);
        Scanner file_content = null;
        try {
            file_content = new Scanner(check_file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        while (file_content != null && file_content.hasNext()) {
            String line = file_content.nextLine();
            if (!line.toLowerCase().contains("xmx") && !line.toLowerCase().contains("xms")) continue;
            Data.LogWarning("Illegal characters found in Server-Args ");
            Config.startupError = true;
        }
    }

    static String getFromXML(String xmlContent, String xpathExpression) {
        if (xmlContent == null || xmlContent.trim().isEmpty() || !xmlContent.contains("<") || !xmlContent.contains(">")) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlContent)));
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            XPathExpression expr = xpath.compile(xpathExpression);
            return (String)expr.evaluate(doc, XPathConstants.STRING);
        }
        catch (Exception e) {
            Data.LogError("Failed to read content from XML: " + e.getMessage());
            return null;
        }
    }

    public static String getJsonValue(String json, String path) {
        try {
            boolean isArray;
            char firstChar = json.trim().charAt(0);
            boolean bl = isArray = firstChar == '[';
            if (isArray) {
                JSONArray jsonArray = new JSONArray(json);
                return Data.getValueFromJSONArray(jsonArray, path);
            }
            JSONObject jsonObject = new JSONObject(json);
            return Data.getValueFromJSONObject(jsonObject, path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getValueFromJSONObject(JSONObject jsonObject, String path) {
        String[] parts = path.split("/");
        JSONObject currentObject = jsonObject;
        for (int i = 0; i < parts.length - 1; ++i) {
            if (!currentObject.has(parts[i])) {
                return null;
            }
            currentObject = currentObject.getJSONObject(parts[i]);
        }
        return currentObject.optString(parts[parts.length - 1]);
    }

    private static String getValueFromJSONArray(JSONArray jsonArray, String path) {
        String[] parts = path.split("/");
        int index = Integer.parseInt(parts[0]);
        JSONObject currentObject = jsonArray.getJSONObject(index);
        for (int i = 1; i < parts.length - 1; ++i) {
            if (!currentObject.has(parts[i])) {
                return null;
            }
            currentObject = currentObject.getJSONObject(parts[i]);
        }
        return currentObject.optString(parts[parts.length - 1]);
    }

    public static boolean containsMemoryParameters(String[] args) {
        return Arrays.stream(args).map(String::toLowerCase).anyMatch(arg -> arg.contains("-xmx") || arg.contains("-xms"));
    }

    public static void logSelectedSystemProperties() {
        List<String> relevantProperties = Arrays.asList("java.home", "java.version", "java.runtime.version", "java.vm.version", "java.vm.name", "java.vm.vendor", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "user.name", "user.dir", "user.home", "java.class.path", "java.vm.specification.version", "sun.management.compiler", "user.timezone");
        Properties properties = System.getProperties();
        relevantProperties.forEach(prop -> {
            if (properties.containsKey(prop)) {
                Data.LogDebug(prop + ": " + properties.getProperty((String)prop));
            }
        });
    }

    public static void updateProperty(String propertiesFilePath, String key, String newValue) throws IOException {
        ArrayList<String> updatedLines = new ArrayList<String>();
        boolean keyUpdated = false;
        Path filePath = Paths.get(propertiesFilePath, new String[0]);
        List<String> lines = Files.readAllLines(filePath, StandardCharsets.UTF_8);
        for (String line : lines) {
            if (line.startsWith(key + "=")) {
                updatedLines.add(key + "=" + newValue);
                keyUpdated = true;
                continue;
            }
            updatedLines.add(line);
        }
        if (!keyUpdated) {
            updatedLines.add("");
            updatedLines.add("#Auto added \"" + key + "\" with function updateProperty()");
            updatedLines.add(key + "=" + newValue);
        }
        Files.write(filePath, updatedLines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static String propertiesToURL(String propertiesFilePath) {
        File file = new File(propertiesFilePath);
        if (!file.exists()) {
            return null;
        }
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            properties.load(fileInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        String[] keys = new String[]{"motd", "max-players", "level-seed", "gamemode", "server-ip", "server-port", "query.port", "rcon.port"};
        StringBuilder postData = new StringBuilder();
        for (String key : keys) {
            String value = properties.getProperty(key);
            if (value == null) continue;
            if (postData.length() != 0) {
                postData.append('&');
            }
            try {
                postData.append(URLEncoder.encode(key, StandardCharsets.UTF_8.name()));
                postData.append('=');
                postData.append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
            }
            catch (IOException e) {
                Data.LogWarning("Decoding Problem: " + Config.rootFolder + File.separator + ' ' + e);
            }
        }
        return postData.toString();
    }

    public static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                byte[] mac;
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp() || (mac = networkInterface.getHardwareAddress()) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : ""));
                }
                return sb.toString();
            }
        }
        catch (SocketException e) {
            return null;
        }
        return null;
    }

    public static class VersionComparator
    implements Comparator<String> {
        @Override
        public int compare(String v1, String v2) {
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String sanitizedV1 = v1.replaceAll("[^\\d.]", "");
            String sanitizedV2 = v2.replaceAll("[^\\d.]", "");
            String[] parts1 = sanitizedV1.split("\\.");
            String[] parts2 = sanitizedV2.split("\\.");
            int minLength = Math.min(parts1.length, parts2.length);
            for (int i = 0; i < minLength; ++i) {
                if (parts1[i].equals(parts2[i])) continue;
                if (parts1[i].matches("\\d+") && parts2[i].matches("\\d+")) {
                    int num1 = Integer.parseInt(parts1[i]);
                    int num2 = Integer.parseInt(parts2[i]);
                    return Integer.compare(num1, num2);
                }
                return parts1[i].compareTo(parts2[i]);
            }
            return Integer.compare(parts1.length, parts2.length);
        }
    }
}

