/*
 * Decompiled with CFR 0.152.
 */
package de.hellbz.forge.Utils;

import de.hellbz.forge.Utils.Data;
import de.hellbz.forge.Utils.Document;
import de.hellbz.forge.Utils.FileOperation;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class Config {
    public static final String PROPERTIES_FILE = "server_starter.conf";
    public static String startupFile = null;
    public static String[] startupParameter = null;
    public static boolean startupError = false;
    public static Properties configProps;
    public static Properties autoProps;
    public static String[] CMD_ARRAY;
    public static String installerFile;
    public static boolean isForge;
    public static String minecraftVersion;
    public static String loaderVersion;
    public static File rootFolder;
    public static File librariesFolder;
    public static File minecraftForgeFolder;
    public static Pattern Pattern_Forge;
    public static Pattern Pattern_Forge_startfile;
    public static Map<String, Map<String, Object>> forgeVersions;
    public static File neoForgeFolder;
    public static Pattern Pattern_NeoForge;
    public static Map<String, Map<String, Object>> neoVersions;
    public static String macAddress;
    public static final String OS;
    public static Integer javaVersion;
    public static String fileStartLnxFileString;
    public static String fileStartWinFileString;
    public static String fileAutoLnxFileString;
    public static String fileAutoWinFileString;

    public static void initServerConfig() throws IOException {
        File configFile = new File(PROPERTIES_FILE);
        if (!configFile.exists()) {
            FileOperation.downloadOrReadFile("/res/server_starter.conf", rootFolder + File.separator + PROPERTIES_FILE);
        }
        FileReader configReader = new FileReader(configFile);
        configProps = new Properties();
        configProps.load(configReader);
        configReader.close();
    }

    static {
        CMD_ARRAY = null;
        installerFile = null;
        isForge = false;
        minecraftVersion = null;
        loaderVersion = null;
        rootFolder = new File("./");
        librariesFolder = new File(rootFolder, "libraries");
        minecraftForgeFolder = new File(librariesFolder, "net/minecraftforge/forge");
        Pattern_Forge = Pattern.compile("forge-([.0-9]+)-([.0-9]+)-(universal|installer).([jar|zip]+)", 2);
        Pattern_Forge_startfile = Pattern.compile("(minecraftforge-universal-|forge-)([0-9.]+)-([0-9.]+)(\\.jar|universal\\.jar|-universal\\.jar|-shim\\.jar)", 2);
        forgeVersions = null;
        neoForgeFolder = new File(librariesFolder, "net/neoforged/neoforge");
        Pattern_NeoForge = Pattern.compile("neoforge-(\\d+\\.\\d+\\.\\d+)(?:-beta)?-installer\\.(?:jar|zip)", 2);
        neoVersions = null;
        macAddress = Data.getMacAddress();
        OS = System.getProperty("os.name").toLowerCase();
        javaVersion = (int)Double.parseDouble(System.getProperty("java.class.version"));
        fileStartLnxFileString = "java -jar " + Document.getJarFileName() + " -Xmx1024M -Xms1024M nogui";
        fileStartWinFileString = "@echo off\n" + fileStartLnxFileString + "\npause\n";
        fileAutoLnxFileString = "java -jar " + Document.getJarFileName() + " -autoFile nogui";
        fileAutoWinFileString = "@echo off\n" + fileAutoLnxFileString + "\npause\n";
        try {
            Config.initServerConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String timezone = configProps.getProperty("timezone", "UTC");
        if (timezone != null && !timezone.isEmpty() && !timezone.equals("UTC")) {
            System.setProperty("user.timezone", timezone);
        }
    }
}

