/*
 * Decompiled with CFR 0.152.
 */
package de.hellbz.forge;

import de.hellbz.forge.Utils.Config;
import de.hellbz.forge.Utils.Data;
import de.hellbz.forge.Utils.Document;
import de.hellbz.forge.Utils.FileOperation;
import de.hellbz.forge.Utils.Loader;
import de.hellbz.forge.Utils.Net;
import de.hellbz.forge.Utils.Remote;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;

public class ServerStarter {
    public static void main(String[] args) throws IOException, InterruptedException {
        if (Arrays.toString(args).toLowerCase().contains("-autofile")) {
            FileOperation.downloadOrReadFile("/res/forge-auto-install.txt", Config.rootFolder + File.separator + "forge-auto-install.txt");
            Data.LogWarning("Auto Installation-File successfully created.");
            Data.LogError("EXIT FORGE-Server-Starter ");
            Data.LogError("-----------------------------------------------");
            System.exit(-1);
        }
        Data.LogInfo("Checking System ...");
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        Config.startupParameter = arguments.toArray(new String[0]);
        Data.logSelectedSystemProperties();
        Data.LogDebug("server_starter.conf: " + Config.configProps.toString());
        String joinedStartupParameter = Arrays.toString(Config.startupParameter);
        Data.LogDebug("STARTUP-PARAMETER: \u001b[36m" + joinedStartupParameter + "\u001b[0m");
        String joinedStartupArgs = Arrays.toString(args);
        Data.LogDebug("STARTUP-ARGS: \u001b[36m" + joinedStartupArgs + "\u001b[0m");
        Data.LogDebug("-----------------------------------------------");
        if (Data.isReallyHeadless()) {
            Data.LogDebug("This is Headless Client");
        } else if (Data.containsMemoryParameters(args) || Data.containsMemoryParameters(Config.startupParameter)) {
            Data.LogDebug("SCRIPT USE -Xmx and -Xms for Start.");
        } else {
            Config.startupError = true;
            Data.LogWarning("Please use -Xmx and -Xms for startup this script.");
            if (!Data.isReallyHeadless()) {
                JOptionPane.showMessageDialog(null, "Script only works in Batch-Mode!\nA startup file for Batch-Mode has been created.");
            }
            Document.StartFile();
        }
        if (!Config.startupError) {
            if (!Net.isConnected) {
                Data.LogInfo("Place your Forge-Installer-JAR directly next to the current JAR.");
                Config.startupError = true;
            } else {
                Remote.checkForUpdate();
            }
        }
        if (!Config.librariesFolder.exists() && !Config.startupError && !Loader.checkLocalInstaller() && Loader.checkLoaderVersion()) {
            Loader.downloadLoader();
        }
        if (!Config.librariesFolder.exists() && !Config.startupError && Loader.checkLocalInstaller(true)) {
            Data.LogInfo("Check for Loader-Installation-File ...");
            Loader.installLoader();
        }
        if (Config.librariesFolder.exists() && !Config.startupError) {
            Loader.checkLoaderFolder();
            Loader.checkLocalFolder();
        }
        if (!Config.startupError) {
            if (Document.checkExist(Config.startupFile)) {
                Data.checkContent(Config.startupFile);
                Data.LogInfo("Building Startup-Parameter ...");
                ArrayList<String> where = new ArrayList<String>();
                String javaPath = Config.configProps.getProperty("java_path");
                String timezone = Config.configProps.getProperty("timezone", "UTC");
                if (javaPath != null && !javaPath.equals("java")) {
                    where.add(javaPath);
                    Data.LogDebug("Use Custom Java Path: " + javaPath);
                } else {
                    where.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
                    Data.LogDebug("Use Standard Java Path");
                }
                if (timezone != null && !timezone.isEmpty() && !timezone.equals("UTC")) {
                    where.add("-Duser.timezone=" + timezone);
                }
                Data.LogDebug(Config.startupFile);
                if (Config.startupFile.endsWith(".jar")) {
                    where.add("-jar");
                    Collections.addAll(where, Config.startupParameter);
                    where.add(Config.startupFile);
                } else {
                    File installerFileJavaArgs = new File(Config.rootFolder + File.separator + "user_jvm_args.txt");
                    if (installerFileJavaArgs.exists()) {
                        where.add("@user_jvm_args.txt");
                    } else {
                        Collections.addAll(where, Config.startupParameter);
                    }
                    where.add("@" + System.getProperty("user.dir") + File.separator + Config.startupFile);
                    if (Config.javaVersion < 60) {
                        Data.LogWarning("The Java-Class-Version is with \"" + Config.javaVersion + "\" too low to start the Server!");
                        Config.startupError = true;
                    }
                }
                where.add("nogui");
                Config.CMD_ARRAY = new String[where.size()];
                where.toArray(Config.CMD_ARRAY);
            } else {
                Data.LogWarning("The Start-File \"" + Config.startupFile + "\" does not exist!");
            }
        }
        if (!Config.startupError) {
            Document.Eula();
        }
        if (!Config.startupError) {
            if (Config.CMD_ARRAY != null) {
                Data.LogInfo("");
                Data.LogInfo("Server is Running in TimeZone: " + Config.configProps.getProperty("timezone"));
                Data.LogInfo("Setup your own timezone in server_starter.conf");
                Data.LogInfo("");
                Data.LogInfo("Start " + (Config.isForge ? "Forge" : "NeoForge") + " " + Config.loaderVersion + " Server");
                Data.LogInfo("-----------------------------------------------");
                Data.LogDebug("Startup-ARRAY \u001b[34m" + Arrays.toString(Config.CMD_ARRAY) + "\u001b[0m");
                Process serverProcess = new ProcessBuilder(Config.CMD_ARRAY).inheritIO().start();
                int exitCode = serverProcess.waitFor();
                if (exitCode == 0) {
                    Data.LogWarning("Server is successfully stopped.");
                    System.exit(0);
                } else {
                    Data.LogError("Server is Crashed with Exit-Code: " + exitCode);
                    Data.LogWarning("Please check your files and upload them to the server again if necessary. ");
                    Data.LogError("EXIT Server-Starter ");
                    System.exit(Integer.parseInt(String.valueOf(exitCode)));
                }
            } else {
                Config.startupError = true;
                Data.LogWarning("Could not build Start-Parameter!");
            }
        }
        if (Config.startupError) {
            Data.LogError("EXIT FORGE-Server-Starter ");
            Data.LogError("-----------------------------------------------");
            System.exit(-1);
        }
    }

    static {
        Document.LogFile();
        Data.LogInfo("-----------------------------------------------");
        Data.LogInfo("FORGE-Server-Starter");
        Data.LogInfo("Now support MinecraftForge and NeoForged");
        Data.LogInfo("");
        Data.LogInfo("By \u001b[32mHellBz\u001b[0m.de");
        Data.LogInfo("");
        Data.LogInfo("-----------------------------------------------");
    }
}

