/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server.storage;

import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import net.minecraft.world.level.GameType;
import org.mindrot.jbcrypt.BCrypt;
import top.seraphjack.simplelogin.SLConfig;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.server.storage.StorageProvider;

public class StorageProviderSQL
implements StorageProvider {
    private final Connection conn;

    public StorageProviderSQL(Connection conn) {
        this.conn = conn;
        try {
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS sl_entries\n(\n    username        varchar(32),\n    defaultGameType tinyint,\n    password        varchar(255),\n    PRIMARY KEY (username)\n)");
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to initialize database", e);
        }
    }

    @Override
    public boolean checkPassword(String username, String password) {
        try {
            PreparedStatement st = this.conn.prepareStatement("SELECT password\nFROM sl_entries\nWHERE username = ?");
            st.setString(1, username);
            ResultSet rs = st.executeQuery();
            if (!rs.next()) {
                return false;
            }
            return BCrypt.checkpw((String)password, (String)rs.getString("password"));
        }
        catch (SQLException ex) {
            SimpleLogin.logger.error("Error looking up password", (Throwable)ex);
            return false;
        }
    }

    @Override
    public void unregister(String username) {
        try {
            PreparedStatement st = this.conn.prepareStatement("DELETE\nFROM sl_entries\nWHERE username = ?");
            st.setString(1, username);
            st.execute();
        }
        catch (SQLException ex) {
            SimpleLogin.logger.error("Error deleting entry", (Throwable)ex);
        }
    }

    @Override
    public boolean registered(String username) {
        try {
            PreparedStatement st = this.conn.prepareStatement("SELECT EXISTS(SELECT * from sl_entries WHERE username = ?)");
            st.setString(1, username);
            ResultSet rs = st.executeQuery();
            return rs.next() && rs.getBoolean(1);
        }
        catch (SQLException ex) {
            SimpleLogin.logger.error("Error looking up entry", (Throwable)ex);
            return false;
        }
    }

    @Override
    public void register(String username, String password) {
        if (this.registered(username)) {
            return;
        }
        try {
            PreparedStatement st = this.conn.prepareStatement("INSERT INTO sl_entries (username, password, defaultGameType)\nVALUES (?, ?, ?)");
            st.setString(1, username);
            st.setString(2, BCrypt.hashpw((String)password, (String)BCrypt.gensalt()));
            st.setInt(3, (Integer)SLConfig.SERVER.defaultGameType.get());
            st.execute();
        }
        catch (SQLException ex) {
            SimpleLogin.logger.error("Error registering entry", (Throwable)ex);
        }
    }

    @Override
    public void save() {
    }

    @Override
    public GameType gameType(String username) {
        try {
            PreparedStatement st = this.conn.prepareStatement("SELECT defaultGameType\nFROM sl_entries\nwhere username = ?");
            st.setString(1, username);
            ResultSet rs = st.executeQuery();
            if (!rs.next()) {
                return null;
            }
            return GameType.m_46393_((int)rs.getInt("defaultGameType"));
        }
        catch (SQLException ex) {
            SimpleLogin.logger.error("Error looking up entry", (Throwable)ex);
            return GameType.m_46393_((int)((Integer)SLConfig.SERVER.defaultGameType.get()));
        }
    }

    @Override
    public void setGameType(String username, GameType gameType) {
        try {
            PreparedStatement st = this.conn.prepareStatement("UPDATE sl_entries\nSET defaultGameType=?\nWHERE username = ?");
            st.setInt(1, gameType.m_46392_());
            st.setString(2, username);
            st.execute();
        }
        catch (SQLException ex) {
            SimpleLogin.logger.error("Error updating entry", (Throwable)ex);
        }
    }

    @Override
    public void changePassword(String username, String newPassword) {
        try {
            PreparedStatement st = this.conn.prepareStatement("UPDATE sl_entries\nSET password=?\nWHERE username = ?");
            st.setString(1, BCrypt.hashpw((String)newPassword, (String)BCrypt.gensalt()));
            st.setString(2, username);
            st.execute();
        }
        catch (SQLException ex) {
            SimpleLogin.logger.error("Error updating entry", (Throwable)ex);
        }
    }

    @Override
    public boolean dirty() {
        return false;
    }

    @Override
    public Collection<String> getAllRegisteredUsername() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        try {
            ResultSet rs = this.conn.createStatement().executeQuery("SELECT username\nFROM sl_entries");
            while (rs.next()) {
                builder.add((Object)rs.getString("username"));
            }
        }
        catch (SQLException ex) {
            SimpleLogin.logger.error("Error looking up entry", (Throwable)ex);
        }
        return builder.build();
    }
}

