/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block_entity.DynamicSpawnerBlockEntity;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class UpdateDynamicSpawnerPacket {
    final BlockPos pos;
    final ResourceLocation type;
    final DynamicSpawnerBlockEntity.ExpRange expRange;

    public UpdateDynamicSpawnerPacket(BlockPos pos, ResourceLocation type, DynamicSpawnerBlockEntity.ExpRange expRange) {
        this.pos = pos;
        this.type = type;
        this.expRange = expRange;
    }

    public static void encoder(UpdateDynamicSpawnerPacket packet, FriendlyByteBuf buff) {
        buff.m_130064_(packet.pos);
        buff.m_130085_(packet.type);
        buff.writeInt(packet.expRange.min);
        buff.writeInt(packet.expRange.max);
    }

    public static UpdateDynamicSpawnerPacket decoder(FriendlyByteBuf buff) {
        try {
            BlockPos pos = buff.m_130135_();
            ResourceLocation type = buff.m_130281_();
            DynamicSpawnerBlockEntity.ExpRange range = new DynamicSpawnerBlockEntity.ExpRange(buff.readInt(), buff.readInt());
            return new UpdateDynamicSpawnerPacket(pos, type, range);
        }
        catch (Throwable t) {
            return new UpdateDynamicSpawnerPacket(BlockPos.f_121853_, PacketHandler.ERRORED, DynamicSpawnerBlockEntity.ExpRange.VANILLA);
        }
    }

    public static void handler(UpdateDynamicSpawnerPacket packet, Supplier<NetworkEvent.Context> context) {
        if (packet.type.equals((Object)PacketHandler.ERRORED) && packet.pos.equals((Object)BlockPos.f_121853_)) {
            ServerPlayer sender = context.get().getSender();
            StructureGelMod.LOGGER.warn("An invalid packet ({}) was sent to the server from {} at {} in {}", packet.getClass().getSimpleName(), sender.m_36316_().getName(), sender.m_20183_(), sender.m_9236_().m_46472_().m_135782_());
            return;
        }
        context.get().enqueueWork(() -> {
            BlockEntity patt2769$temp;
            BlockPos pos;
            ServerLevel level = ((NetworkEvent.Context)context.get()).getSender().m_284548_();
            BlockState state = level.m_8055_(pos = packet.pos);
            if (state.m_60734_() == SGRegistry.Blocks.DYNAMIC_SPAWNER.get() && (patt2769$temp = level.m_7702_(pos)) instanceof DynamicSpawnerBlockEntity) {
                DynamicSpawnerBlockEntity spawner = (DynamicSpawnerBlockEntity)patt2769$temp;
                DynamicSpawnerType dynSpawn = DynamicSpawnerType.REGISTRY.get(packet.type);
                if (dynSpawn != null) {
                    spawner.setSpawner(dynSpawn);
                }
                spawner.setExpRange(packet.expRange);
                spawner.m_6596_();
                level.m_7260_(pos, state, state, 3);
            } else {
                StructureGelMod.LOGGER.warn("Attempted to set DynamicSpawnerBlockEntity data for the wrong block.", new Object[0]);
            }
        });
        context.get().setPacketHandled(true);
    }
}

