/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.network.UpdateBuildingToolPacket;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.SoundActions;

public abstract class BuildingToolMode {
    public static final Codec<BuildingToolMode> CODEC = ResourceLocation.f_135803_.xmap(name -> BuildingToolModes.REGISTRY.get((ResourceLocation)name), mode -> mode.getName());
    protected final ResourceLocation name;
    private final int modelIndex;
    private final ResourceLocation iconTexture;
    private final Component component;
    private final String descKey;
    private final Map<String, ToolModeProperty<?>> properties;

    protected BuildingToolMode(String nameStr, int modelIndex) {
        ResourceLocation name;
        this.name = name = StructureGelMod.locate(nameStr);
        this.modelIndex = modelIndex;
        this.iconTexture = new ResourceLocation(name.m_135827_(), "textures/item/building_tool_" + name.m_135815_() + ".png");
        this.component = Component.m_237115_((String)("item.structure_gel.building_tool.mode." + name.toString()));
        this.descKey = "item.structure_gel.building_tool.mode.description." + name.toString();
        ArrayList props = new ArrayList();
        this.addProperties(props);
        this.properties = (Map)props.stream().collect(ImmutableMap.toImmutableMap(ToolModeProperty::getKey, Function.identity()));
    }

    public abstract boolean hasBlockPalette();

    public void onRightClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
    }

    public void onRightClickAir(Level level, Player player, BlockPos clickedPos, ItemStack stack) {
    }

    public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
    }

    public void onMiddleClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.readPalleteFrom(level, clickedPos);
            BuildingToolItem.setPallete(stack, pallete);
            PacketHandler.sendToClient(UpdateBuildingToolPacket.builder().toClient().pallete(pallete).build(), serverPlayer);
            BuildingToolMode.sendMessage(player, pallete.m_146338_().size() == 1 ? "info.structure_gel.building_tool.message.select_state" : "info.structure_gel.building_tool.message.select_pallete", ((BlockState)((WeightedEntry.Wrapper)pallete.m_146338_().get(0)).m_146310_()).m_60734_().m_49954_().getString());
            BuildingToolMode.playSound(player, SoundEvents.f_12019_);
        }
    }

    public void onMiddleClickAir(Level level, Player player, BlockPos clickedPos, ItemStack stack) {
    }

    public void addProperties(List<ToolModeProperty<?>> properties) {
    }

    protected boolean setBlock(Level level, BlockPos pos, BlockState state, ActionHistory.ActionBuilder actionBuilder) {
        return this.setBlock(level, pos, state, null, actionBuilder);
    }

    protected boolean setBlock(Level level, BlockPos pos, BlockState state, @Nullable CompoundTag blockEntityTag, ActionHistory.ActionBuilder actionBuilder) {
        return this.setBlock(level, pos, (BlockState old) -> state, blockEntityTag, actionBuilder);
    }

    protected boolean setBlock(Level level, BlockPos pos, Function<BlockState, BlockState> modifyState, ActionHistory.ActionBuilder actionBuilder) {
        return this.setBlock(level, pos, modifyState, null, actionBuilder);
    }

    protected boolean setBlock(Level level, BlockPos pos, Function<BlockState, BlockState> modifyState, @Nullable CompoundTag blockEntityTag, ActionHistory.ActionBuilder actionBuilder) {
        CompoundTag oldBETag;
        BlockState oldState = level.m_8055_(pos);
        BlockState newState = modifyState.apply(oldState);
        if (newState == null) {
            return false;
        }
        BlockEntity oldBlockEntity = level.m_7702_(pos);
        if (oldBlockEntity != null) {
            oldBETag = oldBlockEntity.m_187482_();
            Clearable.m_18908_((Object)oldBlockEntity);
            level.m_7731_(pos, Blocks.f_50375_.m_49966_(), 2);
        } else {
            oldBETag = null;
        }
        int flags = 3;
        if (newState.m_61138_((Property)BlockStateProperties.f_61401_) || newState.m_61138_((Property)BlockStateProperties.f_61391_)) {
            flags += 16;
        }
        boolean ret = level.m_7731_(pos, newState, flags);
        BlockEntity newBlockEntity = level.m_7702_(pos);
        if (newBlockEntity != null && blockEntityTag != null) {
            newBlockEntity.m_142466_(blockEntityTag);
        }
        if (ret) {
            actionBuilder.changeBlock(pos, oldState, oldBETag, newState, blockEntityTag);
        }
        return ret;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public int modelIndex() {
        return this.modelIndex;
    }

    public ResourceLocation getIconTexture() {
        return this.iconTexture;
    }

    public Component getComponent() {
        return this.component;
    }

    public String getDescKey() {
        return this.descKey;
    }

    public abstract Object[] getDescArgs();

    public Map<String, ToolModeProperty<?>> getProperties() {
        return this.properties;
    }

    public int getReachDistance(ItemStack stack) {
        return 2;
    }

    public int forPosesWithin(Vec3i cornerA, Vec3i cornerB, Function<BlockPos, Boolean> action) {
        int total = 0;
        BoundingBox area = BoundingBox.m_162375_((Vec3i)cornerA, (Vec3i)cornerB);
        for (int x = area.m_162395_(); x <= area.m_162399_(); ++x) {
            for (int z = area.m_162398_(); z <= area.m_162401_(); ++z) {
                for (int y = area.m_162396_(); y <= area.m_162400_(); ++y) {
                    if (!action.apply(new BlockPos(x, y, z)).booleanValue()) continue;
                    ++total;
                }
            }
        }
        return total;
    }

    protected void setPos(ItemStack stack, int index, BlockPos pos, Player player, boolean message) {
        if (BuildingToolItem.setPos(stack, index, (Vec3i)pos) && message) {
            BuildingToolMode.sendMessage(player, "info.structure_gel.building_tool.message.set_pos", index + 1, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            BuildingToolMode.playSound(player, pos, SoundEvents.f_12632_, 1.0f - 0.6f * (float)index);
        }
    }

    public void clearPoses(ItemStack stack, Player player) {
        if (BuildingToolItem.getPos(stack, 0).isPresent() || BuildingToolItem.getPos(stack, 1).isPresent()) {
            BuildingToolMode.sendMessage(player, "info.structure_gel.building_tool.message.clear_poses", new Object[0]);
            BuildingToolMode.playSound(player, player.m_20183_(), SoundEvents.f_11681_);
        }
        BuildingToolItem.clearPoses(stack);
    }

    protected static void sendMessage(Player player, String translationKey, Object ... args) {
        BuildingToolMode.sendMessage(player, translationKey, Style.f_131099_, args);
    }

    protected static void sendMessage(Player player, String translationKey, Style style, Object ... args) {
        player.m_5661_((Component)Component.m_237110_((String)translationKey, (Object[])args).m_6270_(style), true);
    }

    protected static void playSound(Player player, SoundEvent sound) {
        BuildingToolMode.playSound(player, player.m_20183_(), sound);
    }

    protected static void playSound(Player player, BlockPos pos, SoundEvent sound) {
        BuildingToolMode.playSound(player, pos, sound, 1.0f + player.m_9236_().m_213780_().m_188501_() * 0.2f);
    }

    protected static void playSound(Player player, BlockPos pos, SoundEvent sound, float pitch) {
        player.m_9236_().m_5594_(null, pos, sound, SoundSource.BLOCKS, 0.8f, pitch);
    }

    protected static void playSound(Player player, BlockState state) {
        LiquidBlock liquidBlock;
        SoundEvent emptySound;
        Block block = state.m_60734_();
        SoundEvent sound = block instanceof LiquidBlock ? ((emptySound = (liquidBlock = (LiquidBlock)block).getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY)) == null ? SoundEvents.f_11778_ : emptySound) : state.m_60827_().m_56777_();
        BuildingToolMode.playSound(player, sound);
    }

    public String toString() {
        return "BuildingToolMode[" + this.name + "]";
    }

    protected static void sendPlaceMessage(Player player, ToolModeProperty.Replace replaceMode, int placedBlocks, WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete) {
        int palleteSize;
        BuildingToolMode.sendPlaceMessage(player, replaceMode, placedBlocks, palleteSize, (palleteSize = pallete.m_146338_().size()) > 0 ? (BlockState)((WeightedEntry.Wrapper)pallete.m_146338_().get(0)).m_146310_() : Blocks.f_50069_.m_49966_());
    }

    protected static void sendPlaceMessage(Player player, ToolModeProperty.Replace replaceMode, int placedBlocks, int palleteSize, BlockState messageState) {
        String message = replaceMode.usePlaceMessage ? (palleteSize == 1 ? "info.structure_gel.building_tool.message.place_blocks_with" : (placedBlocks > 1 ? "info.structure_gel.building_tool.message.place_blocks" : "info.structure_gel.building_tool.message.place_block")) : (palleteSize == 1 ? "info.structure_gel.building_tool.message.replace_blocks_with" : (placedBlocks > 1 ? "info.structure_gel.building_tool.message.replace_blocks" : "info.structure_gel.building_tool.message.replace_block"));
        BuildingToolMode.sendMessage(player, message, placedBlocks, palleteSize == 1 ? messageState.m_60734_().m_49954_().getString() : "");
        if (placedBlocks > 0) {
            BuildingToolMode.playSound(player, messageState);
        }
    }

    public static BoundingBox getCloneDestBounds(CapturedBlocks captured, BlockPos targetPos, BlockState targetedBlock, Vec3 playerPos, boolean placeOneBlockAbove) {
        Vec3i bbLength = captured.getBounds().m_71053_();
        BlockPos start = targetPos.m_7918_(-bbLength.m_123341_() + bbLength.m_123341_() / 2, 0, -bbLength.m_123343_() + bbLength.m_123343_() / 2);
        if (placeOneBlockAbove) {
            start = start.m_7494_();
        }
        BoundingBox destBB = BoundingBox.m_162375_((Vec3i)start, (Vec3i)start.m_121955_(bbLength));
        int x = destBB.m_162395_();
        int z = destBB.m_162398_();
        int dx = destBB.m_162399_();
        int dz = destBB.m_162401_();
        LinkedList<Vec3i> edgePositions = new LinkedList<Vec3i>();
        edgePositions.add(new Vec3i(x, 0, z));
        edgePositions.add(new Vec3i(x, 0, dz));
        edgePositions.add(new Vec3i(dx, 0, z));
        edgePositions.add(new Vec3i(dx, 0, dz));
        edgePositions.sort(Comparator.comparingDouble(v -> new Vec3((double)v.m_123341_() + 0.5, (double)v.m_123342_(), (double)v.m_123343_() + 0.5).m_82554_(playerPos)));
        Vec3i closestCorner = (Vec3i)edgePositions.getFirst();
        BlockPos center = destBB.m_162394_();
        return destBB.m_71045_(center.m_123341_() - closestCorner.m_123341_(), 0, center.m_123343_() - closestCorner.m_123343_());
    }

    public static Set<BlockPos> getReplacePositions(Level level, BlockPos clickedPos, int radius) {
        BlockState state = level.m_8055_(clickedPos);
        if (state.m_60795_()) {
            return Collections.emptySet();
        }
        Block clickedBlock = state.m_60734_();
        HashSet<BlockPos> allPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> posesToSearch = new HashSet<BlockPos>();
        posesToSearch.add(clickedPos);
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>(9);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    offsets.add(new Vec3i(x, y, z));
                }
            }
        }
        while (!posesToSearch.isEmpty()) {
            HashSet<BlockPos> newPoses = new HashSet<BlockPos>();
            for (BlockPos pos : posesToSearch) {
                if (pos.m_123333_((Vec3i)clickedPos) > radius) continue;
                allPositions.add(pos);
                for (Vec3i delta : offsets) {
                    BlockPos offset = pos.m_121955_(delta);
                    if (allPositions.contains(offset) || !level.m_8055_(offset).m_60713_(clickedBlock)) continue;
                    newPoses.add(offset);
                }
            }
            posesToSearch = newPoses;
        }
        return allPositions;
    }

    public static Set<BlockPos> getExtendPositions(Level level, BlockPos clickedPos, Direction clickedFace) {
        BlockState state = level.m_8055_(clickedPos);
        if (state.m_60795_() || !level.m_8055_(clickedPos.m_121945_(clickedFace)).m_60795_()) {
            return Collections.emptySet();
        }
        Direction.Axis axis = clickedFace.m_122434_();
        Block clickedBlock = state.m_60734_();
        HashSet<BlockPos> allPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> posesToSearch = new HashSet<BlockPos>();
        posesToSearch.add(clickedPos);
        ArrayList<Vec3i> dirs = new ArrayList<Vec3i>(9);
        for (int a = -1; a <= 1; ++a) {
            for (int b = -1; b <= 1; ++b) {
                Vec3i vec = switch (axis) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.Axis.X -> new Vec3i(0, a, b);
                    case Direction.Axis.Y -> new Vec3i(a, 0, b);
                    case Direction.Axis.Z -> new Vec3i(a, b, 0);
                };
                dirs.add(vec);
            }
        }
        while (!posesToSearch.isEmpty()) {
            HashSet<BlockPos> newPoses = new HashSet<BlockPos>();
            for (BlockPos pos : posesToSearch) {
                if (pos.m_123333_((Vec3i)clickedPos) > 64) continue;
                allPositions.add(pos);
                for (Vec3i dir : dirs) {
                    BlockPos offset = pos.m_121955_(dir);
                    if (allPositions.contains(offset) || !level.m_8055_(offset).m_60713_(clickedBlock) || !level.m_8055_(offset.m_121945_(clickedFace)).m_60795_()) continue;
                    newPoses.add(offset);
                }
            }
            posesToSearch = newPoses;
        }
        return allPositions.stream().map(p -> p.m_121945_(clickedFace)).collect(Collectors.toSet());
    }

    public static Set<BlockPos> getFloodPositions(Level level, BlockPos clickedPos, Direction clickedFace, ToolModeProperty.Replace replace) {
        BlockPos startPos = clickedPos.m_121945_(clickedFace);
        if (!replace.shouldReplace(level, level.m_8055_(startPos), startPos)) {
            return Collections.emptySet();
        }
        HashSet<BlockPos> allPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> posesToSearch = new HashSet<BlockPos>();
        posesToSearch.add(startPos);
        Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        while (!posesToSearch.isEmpty()) {
            HashSet<BlockPos> newPoses = new HashSet<BlockPos>();
            for (BlockPos pos : posesToSearch) {
                if (pos.m_123333_((Vec3i)startPos) > 64) continue;
                allPositions.add(pos);
                for (Direction dir : dirs) {
                    BlockPos offset = pos.m_121945_(dir);
                    if (allPositions.contains(offset) || !replace.shouldReplace(level, level.m_8055_(offset), offset)) continue;
                    newPoses.add(offset);
                }
            }
            posesToSearch = newPoses;
        }
        return allPositions;
    }

    public static Set<BlockPos> getLinePositions(BlockPos cornerA, BlockPos cornerB) {
        HashSet<BlockPos> poses = new HashSet<BlockPos>();
        double magnitude = Math.sqrt(cornerA.m_123331_((Vec3i)cornerB));
        if (magnitude == 0.0) {
            poses.add(cornerA);
            return poses;
        }
        int x = cornerA.m_123341_();
        int y = cornerA.m_123342_();
        int z = cornerA.m_123343_();
        double dX = (double)(x - cornerB.m_123341_()) / magnitude;
        double dY = (double)(y - cornerB.m_123342_()) / magnitude;
        double dZ = (double)(z - cornerB.m_123343_()) / magnitude;
        BlockPos pos = cornerA;
        int i = 0;
        while (!pos.equals((Object)cornerB) && (double)i < magnitude + 1.0) {
            pos = cornerA.m_7918_((int)(-Math.round(dX * (double)i)), (int)(-Math.round(dY * (double)i)), (int)(-Math.round(dZ * (double)i)));
            ++i;
            poses.add(pos);
        }
        return poses;
    }

    public static abstract class ForCorners
    extends BuildingToolMode {
        private final boolean resetPosesAfterAction;

        protected ForCorners(String name, int modelIndex, boolean resetPosesAfterAction) {
            super(name, modelIndex);
            this.resetPosesAfterAction = resetPosesAfterAction;
        }

        public boolean hasSelectionBox() {
            return true;
        }

        @Override
        public void onRightClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            this.setPosition(player, clickedPos, stack, true);
        }

        @Override
        public void onRightClickAir(Level level, Player player, BlockPos clickedPos, ItemStack stack) {
            this.setPosition(player, clickedPos, stack, true);
        }

        public void setPosition(Player player, BlockPos clickedPos, ItemStack stack, boolean message) {
            if (!player.m_6144_()) {
                this.setPositionA(player, clickedPos, stack, message);
            } else {
                this.setPositionB(player, clickedPos, stack, message);
            }
        }

        public void setPositionA(Player player, BlockPos clickedPos, ItemStack stack, boolean message) {
            this.setPos(stack, 0, clickedPos, player, message);
        }

        public void setPositionB(Player player, BlockPos clickedPos, ItemStack stack, boolean message) {
            this.setPos(stack, 1, clickedPos, player, message);
        }

        @Override
        public void onMiddleClickAir(Level level, Player player, BlockPos clickedPos, ItemStack stack) {
            this.clearPoses(stack, player);
        }

        @Override
        public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            Optional<BlockPos> pos0 = BuildingToolItem.getPos(stack, 0);
            Optional<BlockPos> pos1 = BuildingToolItem.getPos(stack, 1);
            if (pos0.isPresent() && pos1.isPresent()) {
                if (this.resetPosesAfterAction) {
                    BuildingToolItem.clearPoses(stack);
                }
                if (level.m_46749_(pos0.get()) && level.m_46749_(pos1.get())) {
                    this.performAction(level, player, clickedPos, stack, pos0.get(), pos1.get());
                } else {
                    ForCorners.sendMessage(player, "info.structure_gel.building_tool.message.pos_unloaded", new Object[0]);
                }
                return;
            }
            ArrayList<String> missingPoses = new ArrayList<String>(1);
            if (pos0.isEmpty()) {
                missingPoses.add(Integer.toString(1));
            }
            if (pos1.isEmpty()) {
                missingPoses.add(Integer.toString(2));
            }
            ForCorners.sendMessage(player, "info.structure_gel.building_tool.message.missing_pos", Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[]{"[" + String.join((CharSequence)", ", missingPoses) + "]"});
        }

        protected abstract void performAction(Level var1, Player var2, BlockPos var3, ItemStack var4, BlockPos var5, BlockPos var6);
    }
}

