/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.SmartBoundingBox;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BuildingToolBounds {
    public static final double CORNER_WIDTH = 0.3;
    public static final double CLICK_RANGE = 10.0;

    public static boolean handleBoundingBoxClick(ItemStack stack, Player player) {
        BuildingToolMode.ForCorners cornerMode;
        BuildingToolMode buildingToolMode = BuildingToolItem.getMode(stack);
        if (buildingToolMode instanceof BuildingToolMode.ForCorners && (cornerMode = (BuildingToolMode.ForCorners)buildingToolMode).hasSelectionBox() && BuildingToolItem.hasCompleteSelection(stack)) {
            SmartBoundingBox.CornerType selectedCorner = BuildingToolItem.getSelectedCorner(stack);
            BlockPos posA = BuildingToolItem.getPos(stack, 0).get();
            BlockPos posB = BuildingToolItem.getPos(stack, 1).get();
            Vec3 lookVec = player.m_20154_();
            Vec3 playerPos = player.m_146892_();
            if (selectedCorner == null) {
                Vec3 cornerWidthVec = new Vec3(0.3, 0.3, 0.3);
                for (SmartBoundingBox.Corner corner : SmartBoundingBox.fromCorners((Vec3i)posA, (Vec3i)posB).getCorners()) {
                    Vec3i cornerPos = corner.getPoint();
                    Vec3 c = new Vec3((double)cornerPos.m_123341_(), (double)cornerPos.m_123342_(), (double)cornerPos.m_123343_());
                    AABB aabb = new AABB(c.m_82546_(cornerWidthVec), c.m_82549_(cornerWidthVec));
                    Optional clickPos = aabb.m_82371_(playerPos, playerPos.m_82549_(lookVec.m_82542_(10.0, 10.0, 10.0)));
                    if (!clickPos.isPresent()) continue;
                    boolean moveBounds = player.m_6144_();
                    BuildingToolItem.setMovingBounds(stack, moveBounds);
                    BuildingToolItem.setSelectedCorner(stack, corner.type);
                    BuildingToolItem.setSelectedCornerDistance(stack, (float)playerPos.m_82554_((Vec3)clickPos.get()));
                    BuildingToolMode.sendMessage(player, moveBounds ? "info.structure_gel.building_tool.message.grabbed_bounds" : "info.structure_gel.building_tool.message.grabbed_corner", new Object[0]);
                    BuildingToolMode.playSound(player, BlockPos.m_274446_((Position)((Position)clickPos.get())), SoundEvents.f_12016_);
                    return true;
                }
            } else {
                BlockPos pos = BuildingToolBounds.placeGrabbedCorner(stack, true, selectedCorner, player, (Vec3i)posA, (Vec3i)posB);
                BuildingToolItem.setSelectedCorner(stack, null);
                BuildingToolMode.playSound(player, pos, SoundEvents.f_12013_);
                return true;
            }
        }
        return false;
    }

    public static boolean tick(ItemStack stack, Player player) {
        SmartBoundingBox.CornerType selectedCorner;
        BuildingToolMode.ForCorners cornerMode;
        BuildingToolMode buildingToolMode = BuildingToolItem.getMode(stack);
        if (buildingToolMode instanceof BuildingToolMode.ForCorners && (cornerMode = (BuildingToolMode.ForCorners)buildingToolMode).hasSelectionBox() && BuildingToolItem.hasCompleteSelection(stack) && (selectedCorner = BuildingToolItem.getSelectedCorner(stack)) != null) {
            BuildingToolBounds.placeGrabbedCorner(stack, false, selectedCorner, player, (Vec3i)BuildingToolItem.getPos(stack, 0).get(), (Vec3i)BuildingToolItem.getPos(stack, 1).get());
            return true;
        }
        return false;
    }

    public static BlockPos placeGrabbedCorner(ItemStack stack, boolean sendMessage, SmartBoundingBox.CornerType selectedCorner, Player player, Vec3i posA, Vec3i posB) {
        float cornerDistance = BuildingToolItem.getSelectedCornerDistance(stack);
        SmartBoundingBox bb = SmartBoundingBox.fromCorners(posA, posB);
        Vec3 lookVec = player.m_146892_().m_82549_(player.m_20154_().m_82542_((double)cornerDistance, (double)cornerDistance, (double)cornerDistance));
        BlockPos newPos = BlockPos.m_274561_((double)(Math.round(lookVec.f_82479_) + (long)(selectedCorner.xPositive ? -1 : 0)), (double)(Math.round(lookVec.f_82480_) + (long)(selectedCorner.yPositive ? -1 : 0)), (double)(Math.round(lookVec.f_82481_) + (long)(selectedCorner.zPositive ? -1 : 0)));
        boolean movingBounds = BuildingToolItem.isMovingBounds(stack);
        if (movingBounds) {
            bb.moveTo(selectedCorner, (Vec3i)newPos);
        } else {
            bb.setCorner(selectedCorner, (Vec3i)newPos);
        }
        BuildingToolItem.setPos(stack, 0, bb.getPosA());
        BuildingToolItem.setPos(stack, 1, bb.getPosB());
        if (sendMessage) {
            BuildingToolMode.sendMessage(player, movingBounds ? "info.structure_gel.building_tool.message.placed_bounds" : "info.structure_gel.building_tool.message.placed_corner", new Object[0]);
        }
        return newPos;
    }

    public static void releaseGrabbedCorner(ItemStack stack, Player player) {
        BuildingToolMode.ForCorners cornerMode;
        BuildingToolMode mode = BuildingToolItem.getMode(stack);
        SmartBoundingBox.CornerType selectedCorner = BuildingToolItem.getSelectedCorner(stack);
        if (selectedCorner != null && mode instanceof BuildingToolMode.ForCorners && (cornerMode = (BuildingToolMode.ForCorners)mode).hasSelectionBox() && BuildingToolItem.hasCompleteSelection(stack)) {
            BuildingToolBounds.placeGrabbedCorner(stack, false, selectedCorner, player, (Vec3i)BuildingToolItem.getPos(stack, 0).get(), (Vec3i)BuildingToolItem.getPos(stack, 1).get());
            BuildingToolItem.setSelectedCorner(stack, null);
        }
    }
}

