/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.data_handler.handlers;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.LootTableAlias;
import com.legacy.structure_gel.api.data_handler.handlers.ProbabilityDataHandler;
import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.api.data_handler.parsing.DataParser;
import com.legacy.structure_gel.api.entity.EntityAccessHelper;
import com.legacy.structure_gel.core.SGAccessor;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

public class EntityHandler
extends ProbabilityDataHandler<EntityHandler> {
    private static final DataParser PARSER = DataParser.of(DataHandlerType.ENTITY, parser -> {
        parser.add("entity", Registries.f_256939_, EntityType.f_20510_);
        parser.add("helmet", (ItemStack)null);
        parser.add("chestplate", (ItemStack)null);
        parser.add("leggings", (ItemStack)null);
        parser.add("boots", (ItemStack)null);
        parser.add("main_hand", (ItemStack)null);
        parser.add("off_hand", (ItemStack)null);
        parser.add("loot", (ResourceLocation)null).setSuggestions(LootTableAlias.REGISTRY::getKeys, ResourceLocation::toString);
        parser.add("persistent", true);
        parser.add("spawn_chance", 1.0f, 0.0f, 1.0f);
        parser.add("tag", new CompoundTag());
    });
    private final ResourceKey<EntityType<?>> entityType;
    private final EnumMap<EquipmentSlot, ItemStack> equipment = new EnumMap(EquipmentSlot.class);
    @Nullable
    private final ResourceLocation loot;
    private final boolean persistent;
    private final CompoundTag tag;

    public EntityHandler(DataMap data) {
        super(data, "spawn_chance");
        this.entityType = data.get("entity", Registries.f_256939_);
        this.equipment.put(EquipmentSlot.HEAD, data.get("helmet", ItemStack.class));
        this.equipment.put(EquipmentSlot.CHEST, data.get("chestplate", ItemStack.class));
        this.equipment.put(EquipmentSlot.LEGS, data.get("leggings", ItemStack.class));
        this.equipment.put(EquipmentSlot.FEET, data.get("boots", ItemStack.class));
        this.equipment.put(EquipmentSlot.MAINHAND, data.get("main_hand", ItemStack.class));
        this.equipment.put(EquipmentSlot.OFFHAND, data.get("off_hand", ItemStack.class));
        this.loot = data.get("loot", ResourceLocation.class);
        this.persistent = data.get("persistent", Boolean.class);
        this.tag = data.get("tag", CompoundTag.class);
    }

    public static DataParser parser() {
        return PARSER;
    }

    @Override
    protected void handle(BlockState dataHandler, BlockPos pos, WorldGenLevel level, RandomSource rand, BoundingBox bounds, StructurePiece piece) {
        CompoundTag entityTag = this.tag.m_6426_();
        entityTag.m_128359_("id", this.entityType.m_135782_().toString());
        Entity entity = EntityType.m_20645_((CompoundTag)entityTag, (Level)level.m_6018_(), e -> {
            Direction facing = dataHandler.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)dataHandler.m_61143_((Property)BlockStateProperties.f_61372_) : Direction.SOUTH;
            float yRot = facing.m_122434_() != Direction.Axis.Y ? facing.m_122435_() : e.m_146908_();
            e.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, yRot, e.m_146909_());
            if (e instanceof HangingEntity) {
                SGAccessor.HANGING_ENTITY_SET_DIRECTION.invoke((HangingEntity)e, facing);
            }
            return e;
        });
        if (entity == null) {
            return;
        }
        for (Map.Entry<EquipmentSlot, ItemStack> entry : this.equipment.entrySet()) {
            ItemStack stack = entry.getValue();
            if (stack == null) continue;
            entity.m_8061_(entry.getKey(), stack);
            if (!(entity instanceof ItemFrame)) continue;
            ItemFrame itemFrame = (ItemFrame)entity;
            itemFrame.m_31805_(stack);
        }
        if (entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            mobEntity.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
            if (this.loot != null) {
                EntityAccessHelper.setDeathLootTable(mobEntity, LootTableAlias.getLootTable(this.loot));
            }
            if (this.persistent) {
                mobEntity.m_21530_();
            }
        }
        level.m_47205_(entity);
    }
}

