/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.screen;

import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.core.block_entity.DynamicSpawnerBlockEntity;
import com.legacy.structure_gel.core.client.widget.SuggestionEditBox;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.network.UpdateDynamicSpawnerPacket;
import com.legacy.structure_gel.core.util.SGText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class DynamicSpawnerScreen
extends Screen {
    private static final Component EXP_RANGE_LABEL = Component.m_237115_((String)"gui.structure_gel.dynamic_spawner.exp_range").m_130940_(ChatFormatting.UNDERLINE);
    private final DynamicSpawnerBlockEntity spawner;
    private SuggestionEditBox typeEdit;
    private Button doneButton;
    private EditBox minEdit;
    private EditBox maxEdit;

    public DynamicSpawnerScreen(DynamicSpawnerBlockEntity spawner) {
        super((Component)Component.m_237119_());
        this.spawner = spawner;
    }

    public void m_86600_() {
        this.typeEdit.m_94120_();
    }

    private void onDone(byte flag) {
        this.sendToServer();
        this.f_96541_.m_91152_((Screen)null);
    }

    private void onCancel() {
        this.f_96541_.m_91152_((Screen)null);
    }

    private void sendToServer() {
        DynamicSpawnerBlockEntity.ExpRange range = new DynamicSpawnerBlockEntity.ExpRange(Integer.parseInt(this.minEdit.m_94155_()), Integer.parseInt(this.maxEdit.m_94155_()));
        PacketHandler.sendToServer(new UpdateDynamicSpawnerPacket(this.spawner.m_58899_(), new ResourceLocation(this.typeEdit.m_94155_()), range));
    }

    public void m_7379_() {
        this.onCancel();
    }

    protected void m_7856_() {
        int editHeight = 20;
        int editSpacing = editHeight + 20;
        int typeWidth = 300;
        this.typeEdit = new SuggestionEditBox(this.f_96547_, this.f_96543_ / 2 - typeWidth / 2, this.f_96544_ / 2 - 60, typeWidth, editHeight, (Component)SGText.TYPE_LABEL, 10, DynamicSpawnerType.REGISTRY.getKeys());
        this.typeEdit.m_94199_(128);
        ResourceLocation type = this.spawner.getSpawnerID();
        if (type != null) {
            this.typeEdit.m_94144_(type.toString());
        }
        this.typeEdit.m_94151_(s -> this.updateWidgets());
        this.m_7787_((GuiEventListener)this.typeEdit);
        DynamicSpawnerBlockEntity.ExpRange expRange = this.spawner.getExpRange();
        int minMaxWidth = 60;
        this.minEdit = new EditBox(this.f_96547_, this.typeEdit.m_252754_(), this.typeEdit.m_252907_() + (editSpacing + 20), minMaxWidth, editHeight, (Component)SGText.MIN_LABEL);
        this.minEdit.m_94199_(8);
        this.minEdit.m_94144_("" + expRange.min);
        this.minEdit.m_94151_(s -> this.updateWidgets());
        this.m_7787_((GuiEventListener)this.minEdit);
        this.maxEdit = new EditBox(this.f_96547_, this.minEdit.m_252754_() + this.minEdit.m_5711_() + 10, this.minEdit.m_252907_(), minMaxWidth, editHeight, (Component)SGText.MAX_LABEL);
        this.maxEdit.m_94199_(8);
        this.maxEdit.m_94144_("" + expRange.max);
        this.maxEdit.m_94151_(s -> this.updateWidgets());
        this.m_7787_((GuiEventListener)this.maxEdit);
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.onDone((byte)0)).m_252794_(this.f_96543_ / 2 - 3 - 150, this.f_96544_ - 30).m_253046_(150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.onCancel()).m_252794_(this.f_96543_ / 2 + 4, this.f_96544_ - 30).m_253046_(150, 20).m_253136_());
        this.updateWidgets();
    }

    private boolean isValid() {
        boolean isValid = true;
        this.typeEdit.m_94202_(0xE0E0E0);
        this.minEdit.m_94202_(0xE0E0E0);
        this.maxEdit.m_94202_(0xE0E0E0);
        if (!ResourceLocation.m_135830_((String)this.typeEdit.m_94155_())) {
            this.typeEdit.m_94202_(14703708);
            isValid = false;
        }
        String minStr = this.minEdit.m_94155_();
        String maxStr = this.maxEdit.m_94155_();
        if (minStr.isBlank() || maxStr.isBlank()) {
            isValid = false;
        }
        try {
            int min = Integer.parseInt(minStr);
            int max = Integer.parseInt(maxStr);
            if (max < min || min < 0 || max < 0) {
                this.minEdit.m_94202_(14703708);
                this.maxEdit.m_94202_(14703708);
                isValid = false;
            }
        }
        catch (Exception e) {
            try {
                Integer.parseInt(minStr);
            }
            catch (Exception minE) {
                this.minEdit.m_94202_(14703708);
            }
            try {
                Integer.parseInt(maxStr);
            }
            catch (Exception maxE) {
                this.maxEdit.m_94202_(14703708);
            }
            isValid = false;
        }
        return isValid;
    }

    private void updateWidgets() {
        this.doneButton.f_93623_ = this.isValid();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280430_(this.f_96547_, (Component)SGText.TYPE_LABEL, this.typeEdit.m_252754_(), this.typeEdit.m_252907_() - 14, 0xA0A0A0);
        graphics.m_280430_(this.f_96547_, EXP_RANGE_LABEL, this.minEdit.m_252754_(), this.minEdit.m_252907_() - 28, 0xA0A0A0);
        graphics.m_280430_(this.f_96547_, (Component)SGText.MIN_LABEL, this.minEdit.m_252754_(), this.minEdit.m_252907_() - 14, 0xA0A0A0);
        graphics.m_280430_(this.f_96547_, (Component)SGText.MAX_LABEL, this.maxEdit.m_252754_(), this.maxEdit.m_252907_() - 14, 0xA0A0A0);
        this.minEdit.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.maxEdit.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.typeEdit.m_88315_(graphics, mouseX, mouseY, partialTicks);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_6574_(Minecraft mc, int mouseX, int mouseY) {
        String type = this.typeEdit.m_94155_();
        String min = this.minEdit.m_94155_();
        String max = this.maxEdit.m_94155_();
        this.m_6575_(mc, mouseX, mouseY);
        this.typeEdit.m_94144_(type);
        this.minEdit.m_94144_(min);
        this.maxEdit.m_94144_(max);
    }

    public boolean m_7933_(int keyCode, int keyB, int modifiers) {
        if (this.typeEdit.m_93696_() && this.typeEdit.m_7933_(keyCode, keyB, modifiers)) {
            return true;
        }
        if (super.m_7933_(keyCode, keyB, modifiers)) {
            return true;
        }
        if (this.doneButton.f_93623_ && (keyCode == 257 || keyCode == 335)) {
            this.onDone((byte)0);
            return true;
        }
        return false;
    }
}

