/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.renderers;

import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.client.renderers.BuildingToolRenderer;
import com.legacy.structure_gel.core.client.renderers.IRenderBase;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class BuildingToolRenderers {
    public static void init() {
    }

    static {
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.REPLACE, () -> new BuildingToolRenderer(){

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                Vec3i renderPos = this.renderPos;
                if (this.hitPos != null) {
                    renderPos = this.hitPos;
                    int r = BuildingToolItem.getProperty(stack, ToolModeProperty.MEDIUM_RADIUS);
                    Set<BlockPos> poses = BuildingToolMode.getReplacePositions((Level)mc.f_91073_, this.hitPos, r);
                    Direction[] dirs = Direction.values();
                    BlockPos[] posesList = (BlockPos[])poses.stream().toArray(BlockPos[]::new);
                    for (int i = posesList.length - 1; i > -1; --i) {
                        BlockPos p = posesList[i];
                        boolean shouldDraw = false;
                        for (Direction d : dirs) {
                            if (poses.contains(p.m_121945_(d))) continue;
                            shouldDraw = true;
                            break;
                        }
                        if (!shouldDraw) continue;
                        Vec3 pos = Vec3.m_82512_((Vec3i)p).m_82492_((double)renderPos.m_123341_(), (double)renderPos.m_123342_(), (double)renderPos.m_123343_());
                        double width = 0.51;
                        IRenderBase.makeBox(poseStack, buffBuilder, pos.m_82492_(width, width, width), pos.m_82520_(width, width, width), 0.75f, 0.0f, 0.75f, 0.3f);
                    }
                    IRenderBase.makeLineBox(poseStack, buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)Vec3i.f_123288_), 0.75f, 0.0f, 0.75f, 0.3f);
                }
                renderInfo.renderPos = renderPos;
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.FILL, () -> new BuildingToolRenderer.ForCorners(){

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.75f, 0.0f, 0.75f};
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.CLONE, () -> new BuildingToolRenderer.ForCorners(){
            @Nullable
            private CapturedBlocks capturedBlocksCache = null;
            @Nullable
            private VertexBuffer destBuffer = null;
            private final Tesselator destTesselator = new Tesselator();
            @Nullable
            private CompletableFuture<BuildingToolRenderer.RenderResult> destFutureRender = null;
            private BuildingToolRenderer.RenderInfo destLastRenderInfo = new BuildingToolRenderer.RenderInfo();

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.0f, 0.85f, 0.0f};
            }

            @Override
            protected void updateData(Minecraft mc, ItemStack stack) {
                super.updateData(mc, stack);
                if (this.needsCompiled && BuildingToolItem.getSelectedCorner(stack) == null) {
                    if (this.pos != null && this.secondPos != null && mc.f_91073_.m_46749_(this.pos) && mc.f_91073_.m_46749_(this.secondPos)) {
                        RandomSource rand = mc.f_91073_.f_46441_;
                        ToolModeProperty.SGMirror mirror = BuildingToolItem.getProperty(stack, ToolModeProperty.MIRROR);
                        ToolModeProperty.SGRotation rotation = BuildingToolItem.getProperty(stack, ToolModeProperty.ROTATION);
                        this.capturedBlocksCache = new CapturedBlocks((Level)mc.f_91073_, this.pos, this.secondPos, (mirror == ToolModeProperty.SGMirror.RANDOM ? ToolModeProperty.SGMirror.NONE : mirror).toVanilla(rand), (rotation == ToolModeProperty.SGRotation.RANDOM ? ToolModeProperty.SGRotation.R_0 : rotation).toVanilla(rand));
                        this.capturedBlocksCache.compressForRender((Level)mc.f_91073_, this.pos);
                    } else {
                        this.capturedBlocksCache = null;
                    }
                }
            }

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                super.compileInfo(mc, stack, poseStack, buffBuilder, camX, camY, camZ, renderInfo);
            }

            protected void compileDest(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                if (this.hitPos != null && this.pos != null && this.secondPos != null && this.capturedBlocksCache != null && BuildingToolItem.getSelectedCorner(stack) == null) {
                    BoundingBox destBB = BuildingToolMode.getCloneDestBounds(this.capturedBlocksCache, BlockPos.f_121853_, Blocks.f_50016_.m_49966_(), Vec3.f_82478_, false);
                    BlockPos worldPos = new BlockPos(destBB.m_162395_(), destBB.m_162396_(), destBB.m_162398_());
                    for (CapturedBlocks.BlockInfo info : this.capturedBlocksCache.getBlockInfos()) {
                        BlockPos p = worldPos.m_121955_((Vec3i)info.pos());
                        info.state().m_60808_((BlockGetter)mc.f_91073_, p).m_83286_((x, y, z, mx, my, mz) -> {
                            double o = 0.001;
                            IRenderBase.makeBox(poseStack, buffBuilder, new Vec3((double)p.m_123341_() - o + x, (double)p.m_123342_() - o + y, (double)p.m_123343_() - o + z), new Vec3((double)p.m_123341_() + o + mx, (double)p.m_123342_() + o + my, (double)p.m_123343_() + o + mz), 0.6f, 0.0f, 0.9f, 0.7f);
                        });
                    }
                    IRenderBase.makeLineBox(poseStack, buffBuilder, destBB, -0.01, 0.75f, 0.0f, 0.75f, 0.3f);
                }
            }

            @Override
            protected BuildingToolRenderer.RenderInfo compile(Minecraft mc, LocalPlayer player, ItemStack stack, double camX, double camY, double camZ) {
                BuildingToolRenderer.RenderInfo ret = super.compile(mc, player, stack, camX, camY, camZ);
                if (SGConfig.CLIENT.threadBuildingTool()) {
                    if (this.destFutureRender == null) {
                        this.destLastRenderInfo.isFinished = false;
                        this.destFutureRender = CompletableFuture.supplyAsync(() -> {
                            PoseStack poseStack = new PoseStack();
                            BufferBuilder buffBuilder = this.destTesselator.m_85915_();
                            buffBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
                            BuildingToolRenderer.RenderInfo renderInfo = new BuildingToolRenderer.RenderInfo();
                            this.compileDest(mc, stack, poseStack, buffBuilder, camX, camY, camZ, renderInfo);
                            return new BuildingToolRenderer.RenderResult(renderInfo, buffBuilder);
                        }, Util.m_183991_());
                    }
                    if (this.destFutureRender != null && this.destFutureRender.isDone()) {
                        try {
                            BuildingToolRenderer.RenderResult result = this.destFutureRender.get();
                            result.renderInfo().isFinished = true;
                            if (this.destBuffer != null) {
                                this.destBuffer.close();
                            }
                            this.destBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                            this.destBuffer.m_85921_();
                            this.destBuffer.m_231221_(result.buffBuilder().m_231175_());
                            this.destFutureRender = null;
                            VertexBuffer.m_85931_();
                            this.destLastRenderInfo = result.renderInfo();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                } else {
                    PoseStack poseStack = new PoseStack();
                    BufferBuilder buffBuilder = Tesselator.m_85913_().m_85915_();
                    buffBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
                    BuildingToolRenderer.RenderInfo renderInfo = new BuildingToolRenderer.RenderInfo();
                    this.compileDest(mc, stack, poseStack, buffBuilder, camX, camY, camZ, renderInfo);
                    if (this.destBuffer != null) {
                        this.destBuffer.close();
                    }
                    this.destBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                    this.destBuffer.m_85921_();
                    this.destBuffer.m_231221_(buffBuilder.m_231175_());
                    VertexBuffer.m_85931_();
                    renderInfo.isFinished = true;
                    this.destLastRenderInfo = renderInfo;
                }
                ret.isFinished = ret.isFinished && this.destLastRenderInfo.isFinished;
                return ret;
            }

            @Override
            protected void render(Minecraft mc, LocalPlayer player, ItemStack stack, PoseStack poseStack, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
                super.render(mc, player, stack, poseStack, projectionMatrix, camX, camY, camZ);
                if (this.destBuffer != null && this.hitPos != null && this.capturedBlocksCache != null) {
                    poseStack.m_85836_();
                    RenderSystem.setShader(GameRenderer::m_172811_);
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    RenderSystem.enableDepthTest();
                    poseStack.m_85837_(camX, camY, camZ);
                    BoundingBox destBB = BuildingToolMode.getCloneDestBounds(this.capturedBlocksCache, this.hitPos, player.m_9236_().m_8055_(this.hitPos), player.m_20182_(), player.m_6144_());
                    poseStack.m_85837_((double)destBB.m_162395_() - camX, (double)destBB.m_162396_() - camY, (double)destBB.m_162398_() - camZ);
                    this.destBuffer.m_85921_();
                    this.destBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, RenderSystem.getShader());
                    VertexBuffer.m_85931_();
                    RenderSystem.disableBlend();
                    RenderSystem.disableDepthTest();
                    poseStack.m_85849_();
                }
            }

            @Override
            protected void close() {
                super.close();
                if (this.destBuffer != null) {
                    this.destBuffer.close();
                }
                this.destBuffer = null;
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.FLOOD, () -> new BuildingToolRenderer(){

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                Vec3i renderPos = this.renderPos;
                if (this.hitPos != null && this.hitFace != null && this.hitBlock) {
                    renderPos = this.hitPos;
                    IRenderBase.highlightBlockPos(poseStack, buffBuilder, 4.mapPosesTo(BuildingToolMode.getFloodPositions((Level)mc.f_91073_, this.hitPos, this.hitFace, BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_AIR_LIQUID)), renderPos), 0.75f, 0.0f, 0.75f, 0.3f);
                }
                renderInfo.renderPos = renderPos;
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.EXTEND, () -> new BuildingToolRenderer(){
            private Set<BlockPos> extendPoses = new HashSet<BlockPos>();

            @Override
            protected void updateData(Minecraft mc, ItemStack stack) {
                super.updateData(mc, stack);
                if (this.hitPos != null && this.hitFace != null && this.extendPoses.size() != BuildingToolMode.getExtendPositions((Level)mc.f_91073_, this.hitPos, this.hitFace).size()) {
                    this.needsCompiled = true;
                }
            }

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                Vec3i renderPos = this.renderPos;
                if (this.hitPos != null && this.hitFace != null && this.hitBlock) {
                    renderPos = this.hitPos;
                    this.extendPoses = BuildingToolMode.getExtendPositions((Level)mc.f_91073_, this.hitPos, this.hitFace);
                    IRenderBase.highlightBlockPos(poseStack, buffBuilder, 5.mapPosesTo(this.extendPoses, renderPos), 0.75f, 0.0f, 0.75f, 0.3f);
                }
                renderInfo.renderPos = renderPos;
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.MOVE, () -> new BuildingToolRenderer.ForCorners(){

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.75f, 0.0f, 0.75f};
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.LINE, () -> new BuildingToolRenderer.ForCorners(){

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.75f, 0.0f, 0.75f};
            }

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                boolean hasPosA = this.pos != null;
                boolean hasPosB = this.secondPos != null;
                float selectionPointAlpha = 0.5f;
                Vec3i renderPos = this.renderPos;
                renderInfo.renderFlagA = false;
                if (hasPosA && !hasPosB) {
                    renderPos = this.pos;
                    IRenderBase.makeLineBox(poseStack, buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)Vec3i.f_123288_), 0.75f, 0.0f, 0.0f, selectionPointAlpha);
                }
                if (!hasPosA && hasPosB) {
                    renderPos = this.secondPos;
                    IRenderBase.makeLineBox(poseStack, buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)Vec3i.f_123288_), 0.0f, 0.0f, 0.75f, selectionPointAlpha);
                }
                if (hasPosA && hasPosB) {
                    Vec3i bbMin;
                    float[] rgb = this.getOutlineRGB();
                    float a = 0.3f;
                    BoundingBox fullBounds = BoundingBox.m_162375_((Vec3i)this.pos, (Vec3i)this.secondPos);
                    renderPos = bbMin = new Vec3i(fullBounds.m_162395_(), fullBounds.m_162396_(), fullBounds.m_162398_());
                    BlockPos posA = this.pos.m_121996_(bbMin);
                    BlockPos posB = this.secondPos.m_121996_(bbMin);
                    IRenderBase.makeLineBox(poseStack, buffBuilder, BoundingBox.m_162375_((Vec3i)posA, (Vec3i)posA), 0.75f, 0.0f, 0.0f, selectionPointAlpha);
                    IRenderBase.makeLineBox(poseStack, buffBuilder, BoundingBox.m_162375_((Vec3i)posB, (Vec3i)posB), 0.0f, 0.0f, 0.75f, selectionPointAlpha);
                    IRenderBase.highlightBlockPos(poseStack, buffBuilder, 7.mapPosesTo(BuildingToolMode.getLinePositions(this.pos, this.secondPos), renderPos), rgb[0], rgb[1], rgb[2], a);
                }
                renderInfo.renderPos = renderPos;
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.SHAPE, () -> new BuildingToolRenderer(){

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                Vec3i renderPos = this.renderPos;
                if (this.hitPos != null) {
                    int r = BuildingToolItem.getProperty(stack, ToolModeProperty.RADIUS);
                    BoundingBox destBB = BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_.m_7918_(-r, -r, -r), (Vec3i)Vec3i.f_123288_.m_7918_(r, r, r));
                    renderPos = this.hitPos;
                    if (r <= 20) {
                        BlockPos pos;
                        ToolModeProperty.Shape shape = BuildingToolItem.getProperty(stack, ToolModeProperty.SHAPE);
                        ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE);
                        HashSet<BlockPos> poses = new HashSet<BlockPos>();
                        HashMap<BlockPos, Boolean> shouldDrawCache = new HashMap<BlockPos, Boolean>();
                        BlockState clickedState = mc.f_91073_.m_8055_(this.hitPos);
                        for (int x = -r; x <= r; ++x) {
                            for (int z = -r; z <= r; ++z) {
                                for (int y = -r; y <= r; ++y) {
                                    pos = new BlockPos(x, y, z);
                                    this.addPos(poses, shouldDrawCache, pos, this.hitPos.m_121955_((Vec3i)pos), (Level)mc.f_91073_, shape, replace, r, clickedState);
                                }
                            }
                        }
                        BlockPos[] posArray = (BlockPos[])poses.stream().toArray(BlockPos[]::new);
                        int size = posArray.length;
                        for (int i = 0; i < size; ++i) {
                            pos = Vec3.m_82512_((Vec3i)posArray[i]);
                            double width = 0.51;
                            IRenderBase.makeBox(poseStack, buffBuilder, pos.m_82492_(width, width, width), pos.m_82520_(width, width, width), 0.75f, 0.0f, 0.75f, 0.3f);
                        }
                    }
                    IRenderBase.makeLineBox(poseStack, buffBuilder, destBB, 0.75f, 0.0f, 0.75f, 0.3f);
                }
                renderInfo.renderPos = renderPos;
            }

            private void addPos(Set<BlockPos> poses, Map<BlockPos, Boolean> shouldDrawCache, BlockPos pos, BlockPos worldPos, Level level, ToolModeProperty.Shape shape, ToolModeProperty.Replace replace, int radius, BlockState clickedState) {
                if (shouldDrawCache.computeIfAbsent(pos, p -> this.canPlace(level, pos, worldPos, shape, replace, radius, clickedState)).booleanValue()) {
                    boolean shouldDraw = false;
                    for (Direction d : Direction.values()) {
                        BlockPos offset = pos.m_121945_(d);
                        if (shouldDrawCache.computeIfAbsent(offset, p -> this.canPlace(level, offset, worldPos.m_121945_(d), shape, replace, radius, clickedState)).booleanValue()) continue;
                        shouldDraw = true;
                        break;
                    }
                    if (shouldDraw) {
                        poses.add(pos);
                    }
                }
            }

            private boolean canPlace(Level level, BlockPos pos, BlockPos worldPos, ToolModeProperty.Shape shape, ToolModeProperty.Replace replace, int radius, BlockState clickedState) {
                return shape.isInside((Vec3i)pos, radius) && replace.shouldReplace(level, clickedState, worldPos);
            }
        });
    }
}

