/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.capability.level;

import com.legacy.structure_gel.core.capability.GelCapability;
import com.legacy.structure_gel.core.capability.level.GelLevel;
import com.legacy.structure_gel.core.capability.level.IGelLevel;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class GelLevelProvider
implements ICapabilitySerializable<CompoundTag> {
    private final Supplier<Level> level;
    private final GelLevel gelLevel = new GelLevel();
    private final LazyOptional<IGelLevel> levelOptional = LazyOptional.of(() -> this.gelLevel);

    public GelLevelProvider(Supplier<Level> level) {
        this.level = level;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == GelCapability.LEVEL_INSTANCE ? this.levelOptional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (GelCapability.LEVEL_INSTANCE != null) {
            this.gelLevel.writeToNBT(tag, this.level.get());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (GelCapability.LEVEL_INSTANCE != null) {
            this.gelLevel.readFromNBT(tag, this.level.get());
        }
    }
}

