/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import customskinloader.CustomSkinLoader;
import customskinloader.fake.FakeCapeBuffer;
import customskinloader.fake.FakeMinecraftProfileTexture;
import customskinloader.fake.FakeSkinBuffer;
import customskinloader.utils.HttpTextureUtil;
import customskinloader.utils.MinecraftUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_1071;
import net.minecraft.class_2960;
import net.minecraft.class_760;

public class FakeSkinManager {
    private final class_1060 textureManager;
    private final Map<class_2960, MinecraftProfileTexture> modelCache = new ConcurrentHashMap<class_2960, MinecraftProfileTexture>();
    private static final String KEY = "CustomSkinLoaderInfo";

    public FakeSkinManager(class_1060 textureManagerInstance, File skinCacheDirectory, MinecraftSessionService sessionService) {
        this.textureManager = textureManagerInstance;
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory;
    }

    public static class_2960 setResourceLocation(class_2960 resourceLocation, MinecraftProfileTexture profileTexture) {
        if (profileTexture instanceof FakeMinecraftProfileTexture) {
            ((FakeMinecraftProfileTexture)profileTexture).setResourceLocation(resourceLocation);
        }
        return resourceLocation;
    }

    public static MinecraftProfileTexture getModelCache(MinecraftProfileTexture profileTexture, FakeSkinManager fakeManager, class_2960 location) {
        return fakeManager.modelCache.getOrDefault(location, profileTexture);
    }

    public static Object[] createThreadDownloadImageData(ImmutableList<Object> list, FakeSkinManager fakeManager, MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType, class_1071.class_1072 skinAvailableCallback) {
        Object[] params = list.toArray();
        if (profileTexture instanceof FakeMinecraftProfileTexture && params.length > 1) {
            FakeMinecraftProfileTexture fakeProfileTexture = (FakeMinecraftProfileTexture)profileTexture;
            class_2960 resourcelocation = fakeProfileTexture.getResourceLocation();
            if (fakeProfileTexture.getResourceLocation() != null) {
                params[0] = fakeProfileTexture.getCacheFile();
                if (params[params.length - 2] instanceof Boolean) {
                    params[params.length - 2] = true;
                }
                int n = params.length - 1;
                FakeSkinManager fakeSkinManager = fakeManager;
                fakeSkinManager.getClass();
                params[n] = fakeSkinManager.new BaseBuffer(skinAvailableCallback, textureType, resourcelocation, fakeProfileTexture);
            }
        }
        return params;
    }

    public static void loadProfileTextures(Runnable runnable, GameProfile profile) {
        CustomSkinLoader.loadProfileTextures(() -> CustomSkinLoader.loadProfileLazily(profile, m -> {
            profile.getProperties().put((Object)KEY, m);
            runnable.run();
        }));
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getUserProfile(MinecraftSessionService sessionService, GameProfile profile, boolean requireSecure) {
        return profile.getProperties().removeAll((Object)KEY).stream().findFirst().orElse(Maps.newHashMap());
    }

    public static void loadElytraTexture(class_1071 skinManager, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map, class_1071.class_1072 skinAvailableCallback) {
        for (int i = 2; i < MinecraftProfileTexture.Type.values().length; ++i) {
            MinecraftProfileTexture.Type type = MinecraftProfileTexture.Type.values()[i];
            if (!map.containsKey(type)) continue;
            skinManager.loadSkin(map.get(type), type, skinAvailableCallback);
        }
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(GameProfile profile) {
        Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map = CustomSkinLoader.loadProfileFromCache(profile);
        Iterator<Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTexture>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTexture> entry = it.next();
            MinecraftProfileTexture texture = entry.getValue();
            if (!FakeSkinManager.shouldJudgeType(texture)) continue;
            texture = this.modelCache.get(MinecraftUtil.getSkinManager().method_4656(texture, entry.getKey()));
            if (texture == null) {
                it.remove();
                continue;
            }
            map.put(entry.getKey(), texture);
        }
        return map;
    }

    private static void makeCallback(class_1071.class_1072 callback, MinecraftProfileTexture.Type type, class_2960 location, MinecraftProfileTexture texture) {
        if (callback != null) {
            callback.onSkinTextureAvailable(type, location, texture);
        }
    }

    private static boolean shouldJudgeType(MinecraftProfileTexture texture) {
        return texture != null && "auto".equals(texture.getMetadata("model"));
    }

    private class BaseBuffer
    implements class_760 {
        private class_760 buffer;
        private class_1071.class_1072 callback;
        private MinecraftProfileTexture.Type type;
        private class_2960 location;
        private FakeMinecraftProfileTexture texture;

        public BaseBuffer(class_1071.class_1072 callback, MinecraftProfileTexture.Type type, class_2960 location, FakeMinecraftProfileTexture texture) {
            switch (type) {
                case SKIN: {
                    this.buffer = new FakeSkinBuffer();
                    break;
                }
                case CAPE: {
                    this.buffer = new FakeCapeBuffer(location);
                }
            }
            this.callback = callback;
            this.type = type;
            this.location = location;
            this.texture = texture;
        }

        @Override
        public class_1011 method_3237(class_1011 image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).method_3237(image) : image;
        }

        @Override
        public BufferedImage func_78432_a(BufferedImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).func_78432_a(image) : image;
        }

        @Override
        public void method_3238() {
            if (this.buffer != null) {
                this.buffer.method_3238();
                if (FakeSkinManager.shouldJudgeType(this.texture) && this.buffer instanceof FakeSkinBuffer) {
                    HashMap metadata = Maps.newHashMap();
                    String type = ((FakeSkinBuffer)this.buffer).judgeType();
                    metadata.put("model", type);
                    this.texture = new FakeMinecraftProfileTexture(this.texture.getRawUrl(), metadata);
                    FakeSkinManager.this.modelCache.put(this.location, this.texture);
                }
            }
            FakeSkinManager.makeCallback(this.callback, this.type, this.location, this.texture);
        }
    }
}

