/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fabric;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import customskinloader.fabric.DevEnvRemapper;
import customskinloader.log.LogManager;
import customskinloader.log.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    public static Logger logger = LogManager.getLogger("Fabric");
    private long world_version;
    private long protocol_version;

    public void onLoad(String mixinPackage) {
        LogManager.setLogFile(Paths.get("./CustomSkinLoader/CustomSkinLoader.log", new String[0]));
        URL versionJson = this.getClass().getResource("/version.json");
        if (versionJson != null) {
            logger.info("\"version.json\": " + versionJson.toString());
            try (InputStream is = versionJson.openStream();
                 InputStreamReader isr = new InputStreamReader(is);){
                JsonObject object = new JsonParser().parse((Reader)isr).getAsJsonObject();
                String name = object.get("name").getAsString();
                this.world_version = object.get("world_version").getAsLong();
                this.protocol_version = object.get("protocol_version").getAsLong();
                logger.info("MinecraftVersion: {name='" + name + "', world_version='" + this.world_version + "', protocol_version='" + this.protocol_version + "'}");
            }
            catch (Throwable t) {
                logger.warning("An exception occurred when reading \"version.json\"!");
                logger.warning(t);
            }
        } else {
            logger.warning("Can't read \"version.json\"! Ignore this message if the version you start is earlier than 18w47b.");
        }
        DevEnvRemapper.initRemapper();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean result = true;
        if (mixinClassName.endsWith(".MixinThreadDownloadImageDataV2")) {
            result = this.world_version >= 2205L && this.world_version <= 2722L && (this.protocol_version >= 554L && this.protocol_version <= 754L || this.protocol_version >= 801L && this.protocol_version <= 803L || this.protocol_version >= 0x40000001L && this.protocol_version <= 0x40000022L);
        } else if (mixinClassName.endsWith(".MixinSkinManager$V2")) {
            result = this.world_version >= 2205L && this.protocol_version >= 554L;
        } else if (mixinClassName.endsWith(".MixinLayerCape") || mixinClassName.endsWith(".MixinRenderPlayer")) {
            result = this.world_version >= 2210L && this.protocol_version >= 558L;
        } else if (mixinClassName.endsWith(".MixinThreadDownloadImageDataV3")) {
            result = this.world_version >= 2723L && (this.protocol_version >= 755L && this.protocol_version < 801L || this.protocol_version > 803L && this.protocol_version < 0x40000001L || this.protocol_version >= 1073741859L);
        }
        logger.info("target: " + targetClassName + ", mixin: " + mixinClassName + ", result: " + result);
        return result;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void preApply(String targetClassName, org.spongepowered.asm.lib.tree.ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, org.spongepowered.asm.lib.tree.ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

