/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class GetStructuresCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"getstructures").requires(source -> source.m_6761_(2));
        command.executes(GetStructuresCommand::getStructures);
        return command;
    }

    private static int getStructures(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        Holder biome = level.m_204166_(new BlockPos(source.m_81371_()));
        Optional opName = biome.m_203543_();
        if (opName.isPresent()) {
            ResourceLocation name = ((ResourceKey)opName.get()).m_135782_();
            source.m_81354_((Component)Component.m_237113_((String)("[" + name.toString() + "]")).m_130940_(ChatFormatting.GREEN), true);
            ArrayList structures = new ArrayList();
            ChunkGenerator chunkGen = level.m_7726_().m_8481_();
            chunkGen.m_207969_().forEach(holder -> {
                StructureSet structureSet = (StructureSet)holder.m_203334_();
                for (StructureSet.StructureSelectionEntry entry : structureSet.f_210003_()) {
                    Structure structure = (Structure)entry.f_210026_().m_203334_();
                    if (!structure.m_226559_().m_203333_(biome)) continue;
                    structures.add(structure);
                }
            });
            if (structures.isEmpty()) {
                source.m_81354_((Component)Component.m_237113_((String)(name.toString() + " has no structures.")), true);
            } else {
                Registry registry = level.m_5962_().m_175515_(Registry.f_235725_);
                structures.forEach(structure -> source.m_81354_((Component)Component.m_237113_((String)(" - " + registry.m_7981_(structure))), true));
            }
            return structures.size();
        }
        source.m_81352_((Component)Component.m_237113_((String)"The biome you're in doesn't have a registry name."));
        return 0;
    }
}

