/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.registry.SGSimpleRegistry;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.structure.ExtendedJigsawPlacement;
import com.legacy.structure_gel.core.structure.jigsaw.GelStructurePiece;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public final class ExtendedJigsawStructure
extends JigsawStructure {
    public static final Codec<ExtendedJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtendedJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(jigsaw -> jigsaw.f_227605_), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(jigsaw -> jigsaw.f_227606_), (App)Codec.intRange((int)0, (int)32).fieldOf("size").forGetter(jigsaw -> jigsaw.f_227607_), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(jigsaw -> jigsaw.f_227608_), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(jigsaw -> jigsaw.f_227609_), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(jigsaw -> jigsaw.f_227610_), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(jigsaw -> jigsaw.f_227611_), (App)ResourceLocation.f_135803_.optionalFieldOf("piece_factory_type", (Object)StructureGelMod.locate("default")).forGetter(jigsaw -> PIECE_FACTORY_REGISTRY.getKey(jigsaw.pieceFactory)), (App)ResourceLocation.f_135803_.optionalFieldOf("placement_test", (Object)StructureGelMod.locate("noop")).forGetter(jigsaw -> PLACEMENT_TEST_REGISTRY.getKey(jigsaw.placementTest))).apply((Applicative)instance, ExtendedJigsawStructure::new)).flatXmap(ExtendedJigsawStructure::verifyRange, ExtendedJigsawStructure::verifyRange).codec();
    private static final SGSimpleRegistry<ResourceLocation, IPieceFactory> PIECE_FACTORY_REGISTRY = new SGSimpleRegistry(StructureGelMod.locate("structure_piece_factory"), () -> IPieceFactory.DEFAULT, null);
    private IPieceFactory pieceFactory = IPieceFactory.DEFAULT;
    private static final SGSimpleRegistry<ResourceLocation, IPlacementTest> PLACEMENT_TEST_REGISTRY = new SGSimpleRegistry(StructureGelMod.locate("placement_test"), () -> IPlacementTest.NOOP, null);
    private IPlacementTest placementTest = IPlacementTest.NOOP;

    private DataResult<ExtendedJigsawStructure> verifyRange() {
        int dist = switch (this.m_226620_()) {
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
            default -> throw new IncompatibleClassChangeError();
        };
        return this.f_227611_ + dist > 128 ? DataResult.error((String)"Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)((Object)this));
    }

    private ExtendedJigsawStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, ResourceLocation pieceFactoryTypeName, ResourceLocation placementTestName) {
        this(settings, startPool, startJigsawName, maxDepth, startHeight, useExpansionHack, projectStartToHeightmap, maxDistanceFromCenter);
        this.pieceFactory = PIECE_FACTORY_REGISTRY.get(pieceFactoryTypeName);
        this.placementTest = PLACEMENT_TEST_REGISTRY.get(placementTestName);
    }

    public ExtendedJigsawStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(settings, startPool, startJigsawName, maxDepth, startHeight, useExpansionHack, projectStartToHeightmap, maxDistanceFromCenter);
    }

    public ExtendedJigsawStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, boolean useExpansionHack, Heightmap.Types projectStartToHeightmap) {
        super(settings, startPool, maxDepth, startHeight, useExpansionHack, projectStartToHeightmap);
    }

    public ExtendedJigsawStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, boolean useExpansionHack) {
        super(settings, startPool, maxDepth, startHeight, useExpansionHack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedJigsawStructure withPieceFactory(ResourceLocation key, IPieceFactory pieceFactory) throws IllegalStateException {
        if (this.pieceFactory != IPieceFactory.DEFAULT) {
            throw new IllegalStateException("Cannot set a piece factory for a structure more than once.");
        }
        SGSimpleRegistry<ResourceLocation, IPieceFactory> sGSimpleRegistry = PIECE_FACTORY_REGISTRY;
        synchronized (sGSimpleRegistry) {
            PIECE_FACTORY_REGISTRY.register(key, pieceFactory);
        }
        this.pieceFactory = pieceFactory;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedJigsawStructure withPlacementTest(ResourceLocation key, IPlacementTest placementTest) throws IllegalStateException {
        if (this.placementTest != IPlacementTest.NOOP) {
            throw new IllegalStateException("Cannot set a piece factory for a structure more than once.");
        }
        SGSimpleRegistry<ResourceLocation, IPlacementTest> sGSimpleRegistry = PLACEMENT_TEST_REGISTRY;
        synchronized (sGSimpleRegistry) {
            PLACEMENT_TEST_REGISTRY.register(key, placementTest);
        }
        this.placementTest = placementTest;
        return this;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        int height = this.f_227608_.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos pos = new BlockPos(chunkPos.m_45604_(), height, chunkPos.m_45605_());
        Pools.m_236491_((Registry)BuiltinRegistries.f_123864_);
        if (this.getPlacementTest().canPlace(context, pos, new JigsawContext((Holder<StructureTemplatePool>)this.f_227605_, this.f_227606_, this.f_227607_, this.f_227609_, this.f_227610_, this.f_227611_))) {
            return new ExtendedJigsawPlacement(this).addPieces(context, (Holder<StructureTemplatePool>)this.f_227605_, this.f_227606_, this.f_227607_, pos, this.f_227609_, this.f_227610_, this.f_227611_);
        }
        return Optional.empty();
    }

    public StructureType<?> m_213658_() {
        return SGRegistry.StructureTypes.EXTENDED_JIGSAW.get();
    }

    public IPieceFactory getPieceFactory() {
        return this.pieceFactory;
    }

    public IPlacementTest getPlacementTest() {
        return this.placementTest;
    }

    static {
        PIECE_FACTORY_REGISTRY.register(StructureGelMod.locate("default"), IPieceFactory.DEFAULT);
        PLACEMENT_TEST_REGISTRY.register(StructureGelMod.locate("noop"), IPlacementTest.NOOP);
    }

    public static interface IPieceFactory {
        public static final IPieceFactory DEFAULT = GelStructurePiece::new;

        public PoolElementStructurePiece create(StructureTemplateManager var1, StructurePoolElement var2, BlockPos var3, int var4, Rotation var5, BoundingBox var6);
    }

    public static interface IPlacementTest {
        public static final IPlacementTest NOOP = (genCtx, pos, jigCtx) -> true;

        public boolean canPlace(Structure.GenerationContext var1, BlockPos var2, JigsawContext var3);
    }

    public record JigsawContext(Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
    }
}

