/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.api.util.LazyOptional;
import com.legacy.structure_gel.core.StructureGelMod;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

public abstract class Registrar<T> {
    private final ResourceLocation name;
    private final ResourceKey<Registry<T>> registryKey;
    private final ResourceKey<T> key;

    protected Registrar(ResourceKey<Registry<T>> registry, ResourceLocation registryName) {
        this.name = registryName;
        this.registryKey = registry;
        this.key = ResourceKey.m_135785_(registry, (ResourceLocation)this.name);
    }

    public static <T, V extends T> Pointer<V> createPointer(ResourceKey<Registry<T>> registry, ResourceLocation registryName, Supplier<V> value) {
        return new Pointer<T>(registry, registryName, value);
    }

    public static <T, V extends T> Static<V> createStatic(ResourceKey<Registry<T>> registry, ResourceLocation registryName, Supplier<V> value) {
        if (RegistryAccess.f_123048_.containsKey(registry)) {
            StructureGelMod.LOGGER.warn("Obtained a static registrar for a datapack registry. This should be avoided as the data stored within a static registrar won't reflect the data in the server's active registry. Registry = {}, Key = {}", registry.m_135782_(), registryName);
        }
        return new Static<T>(registry, registryName, value);
    }

    private void validateRegistry(ResourceKey<? extends Registry<?>> registryKey) throws IllegalArgumentException {
        if (!this.registryKey.equals(registryKey)) {
            throw new IllegalArgumentException("[Structure Gel] Tried to access " + this.key + " from " + registryKey + " but it belongs to " + this.registryKey);
        }
    }

    @Nullable
    public T get(RegistryAccess registryAccess) {
        return this.get(registryAccess.m_175515_(this.registryKey));
    }

    @Nullable
    public T get(CommonLevelAccessor level) {
        return this.get(level.m_5962_());
    }

    @Nullable
    public T get(Registry<?> registry) {
        this.validateRegistry(registry.m_123023_());
        return (T)registry.m_6246_(this.getKey());
    }

    @Nullable
    public T get(IForgeRegistry<?> registry) {
        this.validateRegistry(registry.getRegistryKey());
        return (T)registry.getValue(this.getName());
    }

    @Nullable
    public T orElseGet(Registry<?> registry, Supplier<T> orElse) {
        T val = this.get(registry);
        return val != null ? val : orElse.get();
    }

    @Nullable
    public T orElseGet(IForgeRegistry<?> registry, Supplier<T> orElse) {
        T val = this.get(registry);
        return val != null ? val : orElse.get();
    }

    public boolean isPresent(Registry<?> registry) {
        return registry.m_7804_(this.getName());
    }

    public boolean isPresent(IForgeRegistry<?> registry) {
        return registry.containsKey(this.getName());
    }

    @Nullable
    public <R> R map(Registry<?> registry, Function<T, R> mapFunc) {
        if (this.isPresent(registry)) {
            return mapFunc.apply(this.get(registry));
        }
        return null;
    }

    @Nullable
    public <R> R map(IForgeRegistry<?> registry, Function<T, R> mapFunc) {
        if (this.isPresent(registry)) {
            return mapFunc.apply(this.get(registry));
        }
        return null;
    }

    public Optional<Holder<T>> getHolder(Registry<?> registry) {
        this.validateRegistry(registry.m_123023_());
        return registry.m_203636_(this.getKey());
    }

    public Optional<Holder<T>> getHolder(IForgeRegistry<?> registry) {
        this.validateRegistry(registry.getRegistryKey());
        return registry.getHolder(this.getKey());
    }

    public ResourceKey<? extends Registry<?>> getRegistryKey() {
        return this.registryKey;
    }

    public ResourceKey<T> getKey() {
        return this.key;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public void register(RegisterEvent event) {
        ResourceKey registryKey = event.getRegistryKey();
        if (registryKey.m_135782_().equals((Object)this.getKey().m_211136_())) {
            this.registerValue(event, registryKey);
        }
    }

    protected abstract void registerValue(RegisterEvent var1, ResourceKey<? extends Registry<?>> var2);

    public static class Pointer<T>
    extends Registrar<T> {
        @Nullable
        protected Supplier<T> valueSupplier;

        private Pointer(ResourceKey<Registry<T>> registry, ResourceLocation registryName, Supplier<T> value) {
            super(registry, registryName);
            this.valueSupplier = value;
        }

        @Override
        public void registerValue(RegisterEvent event, ResourceKey<? extends Registry<?>> registryKey) {
            if (this.valueSupplier != null) {
                event.register(registryKey, this.getName(), this.valueSupplier);
                this.valueSupplier = null;
            }
        }
    }

    public static class Static<T>
    extends Registrar<T>
    implements Supplier<T> {
        private final LazyOptional<T> valueLazy;

        private Static(ResourceKey<Registry<T>> registry, ResourceLocation registryName, Supplier<T> value) {
            super(registry, registryName);
            this.valueLazy = LazyOptional.of(value);
        }

        @Override
        public void registerValue(RegisterEvent event, ResourceKey<? extends Registry<?>> registryKey) {
            if (!this.valueLazy.isPresent()) {
                event.register(registryKey, this.getName(), this.valueLazy);
            }
        }

        @Override
        @Nullable
        public T get() {
            return this.valueLazy.getOrThrow("Attempted to get a value from a Registrar before it was registered. " + this.getKey(), new Object[0]);
        }

        public T orElseGet(Supplier<T> orElse) {
            return this.valueLazy.orElseGet(orElse);
        }

        public boolean isPresent() {
            return this.valueLazy.isPresent();
        }

        @Nullable
        public <R> R map(Function<T, R> mapFunc) {
            if (this.isPresent()) {
                return mapFunc.apply(this.get());
            }
            return null;
        }
    }
}

