/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.module.biome_ambience;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import svenhjol.charmonium.annotation.ClientModule;
import svenhjol.charmonium.annotation.Config;
import svenhjol.charmonium.api.event.AddBiomeAmbienceCallback;
import svenhjol.charmonium.handler.SoundHandler;
import svenhjol.charmonium.loader.CharmModule;
import svenhjol.charmonium.module.biome_ambience.BiomeSound;
import svenhjol.charmonium.module.biome_ambience.sounds.Badlands;
import svenhjol.charmonium.module.biome_ambience.sounds.Beach;
import svenhjol.charmonium.module.biome_ambience.sounds.Caves;
import svenhjol.charmonium.module.biome_ambience.sounds.Desert;
import svenhjol.charmonium.module.biome_ambience.sounds.Forest;
import svenhjol.charmonium.module.biome_ambience.sounds.Icy;
import svenhjol.charmonium.module.biome_ambience.sounds.Jungle;
import svenhjol.charmonium.module.biome_ambience.sounds.Mountains;
import svenhjol.charmonium.module.biome_ambience.sounds.Ocean;
import svenhjol.charmonium.module.biome_ambience.sounds.Plains;
import svenhjol.charmonium.module.biome_ambience.sounds.River;
import svenhjol.charmonium.module.biome_ambience.sounds.Savanna;
import svenhjol.charmonium.module.biome_ambience.sounds.Swamp;
import svenhjol.charmonium.module.biome_ambience.sounds.Taiga;
import svenhjol.charmonium.module.biome_ambience.sounds.TheEnd;

@ClientModule(mod="charmonium", description="Plays ambient background sound according to the biome and time of day.")
public class BiomeAmbience
extends CharmModule {
    public Handler handler;
    public static List<class_2960> VALID_DIMENSIONS = new ArrayList<class_2960>();
    @Config(name="Volume scaling", description="Affects the volume of all biome ambient sounds. 1.0 is full volume.")
    public static float volumeScaling = 0.55f;
    @Config(name="Above ground for ambience silencing", description="Number of blocks above the ground that biome ambience will be silenced.\nSet to zero to disable.")
    public static int cullSoundAboveGround = 32;
    @Config(name="Biome sound blending", description="Number of blocks to check for neighbouring biomes.\nSet to zero to disable.")
    public static int biomeBlend = 32;
    @Config(name="Valid dimensions", description="Dimensions in which biome ambience will be played.")
    public static List<String> configDimensions = Arrays.asList("minecraft:overworld", "minecraft:the_end");

    @Override
    public void register() {
        Beach.register();
        Badlands.register();
        Caves.register();
        Desert.register();
        Forest.register();
        Icy.register();
        Jungle.register();
        Mountains.register();
        Ocean.register();
        Plains.register();
        River.register();
        Savanna.register();
        Swamp.register();
        Taiga.register();
        TheEnd.register();
    }

    @Override
    public void runWhenEnabled() {
        ClientEntityEvents.ENTITY_LOAD.register(this::handleEntityLoad);
        ClientEntityEvents.ENTITY_UNLOAD.register(this::handleEntityUnload);
        ClientTickEvents.END_CLIENT_TICK.register(this::handleClientTick);
        configDimensions.forEach(dim -> VALID_DIMENSIONS.add(new class_2960(dim)));
    }

    private void handleEntityLoad(class_1297 entity, class_1937 level) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            boolean result = ((AddBiomeAmbienceCallback)AddBiomeAmbienceCallback.EVENT.invoker()).interact(level);
            class_2960 id = level.method_27983().method_29177();
            if (result && !VALID_DIMENSIONS.contains(id)) {
                VALID_DIMENSIONS.add(id);
            }
            this.trySetupSoundHandler(player);
        }
    }

    private void handleEntityUnload(class_1297 entity, class_1937 level) {
        if (entity instanceof class_746 && this.handler != null) {
            this.handler.stop();
        }
    }

    private void handleClientTick(class_310 client) {
        if (this.handler != null && !client.method_1493()) {
            this.handler.tick();
        }
    }

    public void trySetupSoundHandler(class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        if (this.handler == null) {
            this.handler = new Handler(player);
        }
        this.handler.updatePlayer(player);
    }

    public static class Handler
    extends SoundHandler<BiomeSound> {
        private Handler(@NotNull class_1657 player) {
            super(player);
            Beach.init(this);
            Badlands.init(this);
            Caves.init(this);
            Desert.init(this);
            Forest.init(this);
            Icy.init(this);
            Jungle.init(this);
            Mountains.init(this);
            Ocean.init(this);
            Plains.init(this);
            River.init(this);
            Savanna.init(this);
            Swamp.init(this);
            Taiga.init(this);
            TheEnd.init(this);
        }
    }
}

