/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.common.registration.AoACreativeModeTabs;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.library.object.MutableSupplier;

public final class FluidUtil {

    public record RegisteredFluidHolder(RegistryObject<BucketItem> bucket, RegistryObject<LiquidBlock> fluidBlock, RegistryObject<ForgeFlowingFluid.Source> fluid) {
    }

    public static class Builder {
        private final String id;
        private final Supplier<FluidType> fluidType;
        private final MutableSupplier<ForgeFlowingFluid.Source> sourceFluid = new MutableSupplier(null);
        private final MutableSupplier<ForgeFlowingFluid.Flowing> flowingFluid = new MutableSupplier(null);
        private BiFunction<MutableSupplier<ForgeFlowingFluid.Flowing>, BlockBehaviour.Properties, Supplier<LiquidBlock>> blockCreationFunction = (flowingFluid, blockProperties) -> () -> new LiquidBlock((Supplier)flowingFluid, blockProperties);
        private BiFunction<MutableSupplier<ForgeFlowingFluid.Source>, Item.Properties, Supplier<BucketItem>> bucketCreationFunction = (sourceFluid, itemProperties) -> () -> new BucketItem((Supplier)sourceFluid, itemProperties);
        private Function<ForgeFlowingFluid.Properties, Supplier<ForgeFlowingFluid.Source>> sourceFluidFunction = properties -> () -> new ForgeFlowingFluid.Source(properties);
        private Function<ForgeFlowingFluid.Properties, Supplier<ForgeFlowingFluid.Flowing>> flowingFluidFunction = properties -> () -> new ForgeFlowingFluid.Flowing(properties);
        private ForgeFlowingFluid.Properties fluidProperties;
        private Material material = Material.f_76305_;
        private int tickRate = 5;
        private ToIntFunction<BlockState> lightFunction = state -> 0;
        private String localeKey;

        public Builder(String id, Supplier<FluidType> fluidType) {
            this.id = id;
            this.localeKey = "block.aoa3." + id;
            this.fluidType = fluidType;
        }

        public Builder material(Material material) {
            this.material = material;
            return this;
        }

        public Builder localeKey(String key) {
            this.localeKey = key;
            return this;
        }

        public Builder luminosity(int lightLevel) {
            return this.luminosity(state -> lightLevel);
        }

        public Builder luminosity(ToIntFunction<BlockState> lightFunction) {
            this.lightFunction = lightFunction;
            return this;
        }

        public Builder tickRate(int tickRate) {
            this.tickRate = tickRate;
            return this;
        }

        public Builder noBucket() {
            this.bucketCreationFunction = null;
            return this;
        }

        public Builder noBlock() {
            this.blockCreationFunction = null;
            return this;
        }

        public Builder customBlock(BiFunction<MutableSupplier<ForgeFlowingFluid.Flowing>, BlockBehaviour.Properties, Supplier<LiquidBlock>> blockCreationFunction) {
            this.blockCreationFunction = blockCreationFunction;
            return this;
        }

        public Builder customBucket(BiFunction<MutableSupplier<ForgeFlowingFluid.Source>, Item.Properties, Supplier<BucketItem>> bucketCreationFunction) {
            this.bucketCreationFunction = bucketCreationFunction;
            return this;
        }

        public Builder customSourceFluid(Function<ForgeFlowingFluid.Properties, Supplier<ForgeFlowingFluid.Source>> sourceFluidCreationFunction) {
            this.sourceFluidFunction = sourceFluidCreationFunction;
            return this;
        }

        public Builder customFlowingFluid(Function<ForgeFlowingFluid.Properties, Supplier<ForgeFlowingFluid.Flowing>> flowingFluidCreationFunction) {
            this.flowingFluidFunction = flowingFluidCreationFunction;
            return this;
        }

        public RegistryObject<LiquidBlock> defaultRegisterAll() {
            return this.registerAll(AoARegistries.ITEMS.deferredRegister(), AoARegistries.BLOCKS.deferredRegister(), AoARegistries.FLUIDS.deferredRegister()).fluidBlock();
        }

        public RegisteredFluidHolder registerAll(DeferredRegister<Item> itemRegistry, DeferredRegister<Block> blockRegistry, DeferredRegister<Fluid> fluidRegistry) {
            RegistryObject<BucketItem> bucket = this.registerBucket(itemRegistry);
            RegistryObject<ForgeFlowingFluid.Source> fluid = this.registerFluid(fluidRegistry);
            RegistryObject<LiquidBlock> fluidBlock = this.registerBlock(blockRegistry);
            return new RegisteredFluidHolder(bucket, fluidBlock, fluid);
        }

        @Nullable
        public RegistryObject<LiquidBlock> registerBlock(DeferredRegister<Block> blockRegistry) {
            if (this.blockCreationFunction == null) {
                return null;
            }
            this.makeFluidProperties();
            RegistryObject block = blockRegistry.register(this.id, this.blockCreationFunction.apply(this.flowingFluid, BlockBehaviour.Properties.m_60939_((Material)this.material).m_60910_().m_60978_(100.0f).m_222994_().m_60953_(this.lightFunction)));
            this.fluidProperties.block((Supplier)block);
            return block;
        }

        @Nullable
        public RegistryObject<BucketItem> registerBucket(DeferredRegister<Item> itemRegistry) {
            if (this.bucketCreationFunction == null) {
                return null;
            }
            this.makeFluidProperties();
            RegistryObject bucket = itemRegistry.register(this.id + "_bucket", this.bucketCreationFunction.apply(this.sourceFluid, new Item.Properties().m_41491_(AoACreativeModeTabs.MISC_ITEMS).m_41487_(16).m_41495_(Items.f_42446_)));
            this.fluidProperties.bucket((Supplier)bucket);
            return bucket;
        }

        public RegistryObject<ForgeFlowingFluid.Source> registerFluid(DeferredRegister<Fluid> fluidRegistry) {
            this.makeFluidProperties();
            RegistryObject fluid = fluidRegistry.register(this.id, this.sourceFluidFunction.apply(this.fluidProperties));
            this.sourceFluid.update((Supplier<ForgeFlowingFluid.Source>)fluid);
            this.flowingFluid.update((Supplier<ForgeFlowingFluid.Flowing>)fluidRegistry.register(this.id + "_flowing", this.flowingFluidFunction.apply(this.fluidProperties)));
            return fluid;
        }

        private void makeFluidProperties() {
            if (this.fluidProperties == null) {
                this.fluidProperties = new ForgeFlowingFluid.Properties(this.fluidType, this.sourceFluid, this.flowingFluid).tickRate(this.tickRate);
            }
        }
    }
}

