/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public final class EntityRetrievalUtil {
    @Nullable
    public static <T extends Entity> T getNearest(Vec3 origin, List<T> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        double dist = Double.MAX_VALUE;
        Entity closest = null;
        for (Entity entity : entities) {
            double entityDist = entity.m_20238_(origin);
            if (!(entityDist < dist)) continue;
            dist = entityDist;
            closest = entity;
        }
        return (T)closest;
    }

    @Nullable
    public static Entity getNearestEntity(Entity origin, double radius, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius, predicate);
    }

    @Nullable
    public static Entity getNearestEntity(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin.f_19853_, new AABB(origin.m_20185_() - radiusX, origin.m_20186_() - radiusY, origin.m_20189_() - radiusZ, origin.m_20185_() + radiusX, origin.m_20186_() + radiusY, origin.m_20189_() + radiusZ), origin.m_20182_(), predicate);
    }

    @Nullable
    public static Entity getNearestEntity(Level level, AABB area, Vec3 origin, Predicate<Entity> predicate) {
        MutableDouble dist = new MutableDouble(Double.MAX_VALUE);
        MutableObject closest = new MutableObject(null);
        level.m_142646_().m_142232_(area, entity -> {
            double entityDist;
            if (predicate.test((Entity)entity) && (entityDist = entity.m_20238_(origin)) < dist.getValue()) {
                dist.setValue(entityDist);
                closest.setValue(entity);
            }
        });
        return (Entity)closest.getValue();
    }

    @Nullable
    public static Player getNearestPlayer(Entity origin, double radius, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin, radius, radius, radius, predicate);
    }

    @Nullable
    public static Player getNearestPlayer(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin.f_19853_, new AABB(origin.m_20185_() - radiusX, origin.m_20186_() - radiusY, origin.m_20189_() - radiusZ, origin.m_20185_() + radiusX, origin.m_20186_() + radiusY, origin.m_20189_() + radiusZ), origin.m_20182_(), predicate);
    }

    @Nullable
    public static Player getNearestPlayer(Level level, AABB area, Vec3 origin, Predicate<Player> predicate) {
        double dist = Double.MAX_VALUE;
        Player closest = null;
        for (Player player : level.m_6907_()) {
            double playerDist;
            if (!area.m_82390_(player.m_20182_()) || !predicate.test(player) || !((playerDist = player.m_20238_(origin)) < dist)) continue;
            dist = playerDist;
            closest = player;
        }
        return closest;
    }

    public static List<Player> getPlayers(Level level, AABB area) {
        return EntityRetrievalUtil.getPlayers(level, area, (Player pl) -> true);
    }

    public static List<Player> getPlayers(Entity origin, double radius, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getPlayers(origin, radius, radius, radius, predicate);
    }

    public static List<Player> getPlayers(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<Player> predicate) {
        return EntityRetrievalUtil.getPlayers(origin.f_19853_, new AABB(origin.m_20185_() - radiusX, origin.m_20186_() - radiusY, origin.m_20189_() - radiusZ, origin.m_20185_() + radiusX, origin.m_20186_() + radiusY, origin.m_20189_() + radiusZ), predicate);
    }

    public static List<Player> getPlayers(Level level, AABB area, Predicate<Player> predicate) {
        ObjectArrayList players = new ObjectArrayList();
        for (Player player : level.m_6907_()) {
            if (!area.m_82390_(player.m_20182_()) || !predicate.test(player)) continue;
            players.add(player);
        }
        return players;
    }

    public static List<Entity> getEntities(Entity origin, double radius, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius, predicate);
    }

    public static List<Entity> getEntities(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<Entity> predicate) {
        return EntityRetrievalUtil.getEntities(origin.f_19853_, new AABB(origin.m_20185_() - radiusX, origin.m_20186_() - radiusY, origin.m_20189_() - radiusZ, origin.m_20185_() + radiusX, origin.m_20186_() + radiusY, origin.m_20189_() + radiusZ), predicate.and(entity -> entity != origin));
    }

    public static List<Entity> getEntities(Level level, AABB area, Predicate<? extends Entity> predicate) {
        Predicate<? extends Entity> typeSafePredicate = predicate;
        ObjectArrayList entities = new ObjectArrayList();
        level.m_142646_().m_142232_(area, arg_0 -> EntityRetrievalUtil.lambda$getEntities$3(typeSafePredicate, (List)entities, arg_0));
        for (PartEntity part : level.getPartEntities()) {
            if (!part.m_20191_().m_82381_(area) || !typeSafePredicate.test((Entity)part)) continue;
            entities.add(part);
        }
        return entities;
    }

    private static /* synthetic */ void lambda$getEntities$3(Predicate typeSafePredicate, List entities, Entity entity) {
        if (typeSafePredicate.test(entity)) {
            entities.add(entity);
        }
    }
}

