/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.tslat.aoa3.content.entity.misc.HaulingFishingBobberEntity;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RandomUtil;

public final class DamageUtil {
    public static void doScaledKnockback(LivingEntity target, Entity attacker, float strength, double xRatio, double zRatio) {
        if (target instanceof Player && !PlayerUtil.shouldPlayerBeAffected((Player)target)) {
            return;
        }
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)strength, (double)xRatio, (double)zRatio);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength() * (float)(1.0 - target.m_21051_(Attributes.f_22278_).m_22135_());
        xRatio = event.getRatioX();
        zRatio = event.getRatioZ();
        target.f_19812_ = true;
        target.f_19864_ = true;
        double vec = Math.sqrt(xRatio * xRatio + zRatio * zRatio);
        Vec3 targetMotion = target.m_20184_();
        double motionX = targetMotion.m_7096_() / 2.0 - xRatio / vec * (double)strength;
        double motionZ = targetMotion.m_7094_() / 2.0 - zRatio / vec * (double)strength;
        double motionY = targetMotion.m_7098_();
        if (target.m_20096_()) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        target.m_20256_(new Vec3(motionX, motionY, motionZ));
        target.f_19864_ = true;
    }

    public static void doBodySlamKnockback(LivingEntity target, Entity attacker, float xModifier, float yModifier, float zModifier) {
        double zVelocity;
        double yVelocity;
        if (target instanceof Player && !PlayerUtil.shouldPlayerBeAffected((Player)target)) {
            return;
        }
        Vec3 attackerVelocity = attacker.m_20184_();
        double xVelocity = attackerVelocity.m_7096_() * (double)xModifier;
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)((float)NumberUtil.average(xVelocity, yVelocity = attackerVelocity.m_7098_() * (double)yModifier, zVelocity = attackerVelocity.m_7094_() * (double)zModifier)), (double)xVelocity, (double)zVelocity);
        if (event.isCanceled()) {
            return;
        }
        double resist = 1.0;
        AttributeInstance attrib = target.m_21051_(Attributes.f_22278_);
        if (attrib != null) {
            resist -= attrib.m_22135_();
        }
        target.m_5997_(event.getRatioX() * resist, yVelocity * resist, event.getRatioZ() * resist);
        target.f_19864_ = true;
    }

    public static void killEntityCleanly(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            entity.m_6469_(DamageSource.f_19317_, Float.MAX_VALUE);
            entity.m_146870_();
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        target.m_6469_(new DamageSource("magic").m_19380_().m_19382_().m_19389_(), ((LivingEntity)entity).m_21223_());
        if (target.m_21223_() > 0.0f) {
            target.m_21153_(0.0f);
        }
    }

    public static boolean dealAoeDamage(@Nullable Entity indirectSource, LivingEntity attacker, Entity target, float dmg, boolean bypassProtections) {
        DamageSource damageSource;
        if (indirectSource != null) {
            damageSource = new IndirectEntityDamageSource("aoe", indirectSource, (Entity)attacker).m_19389_();
        } else {
            DamageSource damageSource2 = damageSource = attacker instanceof Player ? DamageSource.m_19344_((Player)((Player)attacker)) : DamageSource.m_19370_((LivingEntity)attacker);
        }
        if (bypassProtections) {
            damageSource.m_19380_();
            damageSource.m_19382_();
        }
        if (target.m_6673_(damageSource)) {
            return false;
        }
        target.f_19802_ = 0;
        return target.m_6469_(damageSource, dmg);
    }

    public static boolean dealBlasterDamage(LivingEntity attacker, Entity target, Entity shot, float dmg, boolean bypassProtections) {
        IndirectEntityDamageSource damageSource = new IndirectEntityDamageSource("blaster", shot, (Entity)attacker);
        damageSource.m_19389_();
        if (!(target instanceof Player)) {
            damageSource.m_19380_();
        }
        if (bypassProtections) {
            damageSource.m_19382_();
            damageSource.m_19380_();
        }
        if (target.m_6673_((DamageSource)damageSource)) {
            return false;
        }
        if (target instanceof EnderDragonPart || target instanceof EndCrystal) {
            return target.m_6469_((DamageSource)damageSource, dmg);
        }
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        target.f_19802_ = 0;
        Vec3 targetMotion = target.m_20184_();
        boolean success = target.m_6469_((DamageSource)damageSource, dmg);
        target.m_20256_(targetMotion);
        target.f_19864_ = false;
        return success;
    }

    public static boolean dealMeleeDamage(LivingEntity attacker, Entity target, float dmg, boolean bypassProtections) {
        DamageSource damageSource;
        DamageSource damageSource2 = damageSource = attacker instanceof Player ? DamageSource.m_19344_((Player)((Player)attacker)) : DamageSource.m_19370_((LivingEntity)attacker);
        if (target.m_6673_(damageSource)) {
            return false;
        }
        if (bypassProtections) {
            damageSource.m_19380_();
            damageSource.m_19382_();
        }
        target.f_19802_ = 0;
        boolean success = target.m_6469_(damageSource, dmg);
        target.f_19802_ = 0;
        return success;
    }

    public static boolean dealMagicDamage(@Nullable Entity indirectSource, LivingEntity attacker, Entity target, float dmg, boolean bypassProtections) {
        Object damageSource = indirectSource != null ? new IndirectEntityDamageSource("magic", indirectSource, (Entity)attacker) : (attacker instanceof Player ? DamageSource.m_19344_((Player)((Player)attacker)) : DamageSource.m_19370_((LivingEntity)attacker));
        damageSource.m_19389_();
        if (!(target instanceof Player)) {
            damageSource.m_19380_();
        }
        if (bypassProtections) {
            damageSource.m_19382_();
        }
        if (target.m_6673_(damageSource)) {
            return false;
        }
        if (target instanceof EnderDragonPart || target instanceof EndCrystal) {
            return target.m_6469_(damageSource, dmg);
        }
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        target.f_19802_ = 0;
        return target.m_6469_(damageSource, dmg);
    }

    public static void dealSelfHarmDamage(LivingEntity target, float dmg) {
        if (target instanceof Player && !PlayerUtil.shouldPlayerBeAffected((Player)target)) {
            return;
        }
        if (target.m_21223_() - dmg > 0.0f) {
            target.m_21153_(target.m_21223_() - dmg);
        } else {
            target.f_19802_ = 0;
            target.m_6469_(new DamageSource("selfharm").m_19382_().m_19380_(), dmg);
        }
    }

    public static boolean dealGunDamage(Entity target, LivingEntity attacker, ThrowableProjectile bullet, float dmg) {
        boolean success;
        DamageSource source = new IndirectEntityDamageSource("gun", (Entity)bullet, (Entity)attacker).m_19366_();
        if (target.m_6673_(source)) {
            return false;
        }
        if (target instanceof EnderDragonPart || target instanceof EndCrystal) {
            return target.m_6469_(source, dmg);
        }
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        target.f_19802_ = 0;
        if (RandomUtil.percentChance(0.6f)) {
            Vec3 targetMotion = target.m_20184_();
            success = target.m_6469_(source, dmg);
            target.m_20256_(targetMotion);
            target.f_19864_ = false;
        } else {
            success = target.m_6469_(source, dmg);
            target.f_19864_ = true;
        }
        return success;
    }

    public static boolean dealVulcaneDamage(LivingEntity target, Player attacker, float dmg) {
        DamageSource source = new EntityDamageSource("vulcane", (Entity)attacker){

            public Component m_6157_(LivingEntity livingEntity) {
                ItemStack itemstack = this.f_19391_ instanceof LivingEntity ? ((LivingEntity)this.f_19391_).m_21205_() : ItemStack.f_41583_;
                String prefix = "death.attack.player";
                return !itemstack.m_41619_() && itemstack.m_41788_() ? Component.m_237110_((String)(prefix + ".item"), (Object[])new Object[]{this.f_19391_.m_5446_(), this.f_19391_.m_5446_(), itemstack.m_41611_()}) : Component.m_237110_((String)prefix, (Object[])new Object[]{this.f_19391_.m_5446_(), this.f_19391_.m_5446_()});
            }
        }.m_19382_().m_19380_();
        if (target.m_6673_(source)) {
            return false;
        }
        target.f_19802_ = 0;
        return target.m_6469_(source, dmg);
    }

    public static boolean dealRangedDamage(Entity target, LivingEntity attacker, Entity projectile, float dmg) {
        DamageSource source = DamageSource.m_19361_((Entity)projectile, (Entity)attacker);
        if (target.m_6673_(source)) {
            return false;
        }
        if (target instanceof EnderDragonPart || target instanceof EndCrystal) {
            return target.m_6469_(source, dmg);
        }
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        target.f_19802_ = 0;
        target.f_19864_ = true;
        return target.m_6469_(source, dmg);
    }

    public static boolean dealHaulingDamage(Player player, HaulingFishingBobberEntity bobber, Entity target, float dmg) {
        DamageSource damageSource = new IndirectEntityDamageSource("hauling", (Entity)bobber, (Entity)player).m_19380_().m_19382_().m_19381_();
        if (target.m_6673_(damageSource)) {
            return false;
        }
        if (target instanceof EnderDragonPart || target instanceof EndCrystal) {
            return target.m_6469_(damageSource, dmg);
        }
        return target instanceof LivingEntity && target.m_6469_(damageSource, dmg);
    }

    public static boolean isMeleeDamage(DamageSource source) {
        return source.m_7639_() != null && !source.m_19360_() && !source.m_19385_().equals("thrown") && !source.m_19387_() && !source.m_19372_() && !source.m_19384_() && source.m_7640_() == source.m_7639_();
    }

    public static boolean isBlasterDamage(DamageSource source) {
        return source.m_19385_().equals("blaster") && source.m_19387_();
    }

    public static boolean isMagicDamage(DamageSource source, Entity target, float dmg) {
        return source.m_19387_() && !source.m_19385_().equals("blaster") && !source.m_19385_().equals("thorns") && (!(target instanceof LivingEntity) || !DamageUtil.isPoisonDamage(source, target, dmg));
    }

    public static boolean isRangedDamage(DamageSource source, Entity target, float dmg) {
        return (source.m_19360_() && !source.m_19385_().equals("gun") || source.m_19385_().equals("thrown")) && !DamageUtil.isMagicDamage(source, target, dmg);
    }

    public static boolean isGunDamage(DamageSource source) {
        return source.m_19385_().equals("gun") && source.m_19360_();
    }

    public static boolean isPoisonDamage(DamageSource source, Entity target, float dmg) {
        return source.m_19387_() && source.m_7639_() == null && !source.m_19385_().equals("thorns") && target instanceof LivingEntity && ((LivingEntity)target).m_21023_(MobEffects.f_19614_) && dmg == 1.0f;
    }

    public static boolean isPhysicalDamage(DamageSource source, Entity target, float dmg) {
        return !DamageUtil.isPoisonDamage(source, target, dmg) && !source.m_19387_() && !source.m_19372_() && source != DamageSource.f_19320_ && source != DamageSource.f_19317_ && !source.m_19384_() && source != DamageSource.f_19313_;
    }

    public static boolean isVulcaneDamage(DamageSource source) {
        return source.m_19385_().equals("vulcane");
    }

    public static boolean isEnvironmentalDamage(DamageSource source) {
        if (source.m_7639_() != null || source.m_19372_()) {
            return false;
        }
        return switch (source.m_19385_()) {
            case "onFire", "inFire", "cactus", "acid", "lightningBolt", "lava", "cramming", "inWall", "fallingBlock", "starve", "anvil", "outOfWorld" -> true;
            default -> false;
        };
    }

    public static boolean isPlayerEnvironmentallyProtected(ServerPlayer player) {
        Item helmet = ((ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.HEAD.m_20749_())).m_41720_();
        return helmet instanceof AdventArmour && ((AdventArmour)helmet).isHelmetAirTight(player);
    }
}

