/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.StringUtil;

public class PotionDurationReducer
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.POTION_APPLIED};
    private final float modifier;
    private final boolean useAddition;
    private final MobEffectCategory matchType;
    private final HashSet<ResourceLocation> matchEffects;
    private final Consumer<MobEffectInstance> modifierConsumer;

    public PotionDurationReducer(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.POTION_DURATION_REDUCER.get(), skill, data);
        this.modifier = GsonHelper.m_13915_((JsonObject)data, (String)"modifier");
        this.useAddition = GsonHelper.m_13855_((JsonObject)data, (String)"use_addition", (boolean)false);
        if (data.has("match_effect_type")) {
            this.matchType = MobEffectCategory.valueOf((String)data.get("match_effect_type").getAsString());
            this.matchEffects = null;
        } else {
            this.matchEffects = new HashSet();
            JsonElement effects = data.get("match_effects");
            if (effects.isJsonPrimitive()) {
                this.matchEffects.add(new ResourceLocation(effects.getAsString()));
            } else if (effects.isJsonArray()) {
                for (JsonElement element : effects.getAsJsonArray()) {
                    this.matchEffects.add(new ResourceLocation(element.getAsString()));
                }
            }
            this.matchType = null;
        }
        this.modifierConsumer = effect -> {
            effect.f_19503_ = this.useAddition ? (effect.f_19503_ += (int)this.modifier) : (int)((float)effect.f_19503_ * this.modifier);
        };
    }

    public PotionDurationReducer(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.POTION_DURATION_REDUCER.get(), skill, data);
        this.modifier = data.m_128457_("modifier");
        this.useAddition = data.m_128471_("use_addition");
        if (data.m_128441_("match_effect_type")) {
            this.matchType = MobEffectCategory.valueOf((String)data.m_128461_("match_effect_type"));
            this.matchEffects = null;
        } else {
            this.matchEffects = new HashSet();
            Tag effects = data.m_128423_("match_effects");
            if (effects.m_6458_() == StringTag.f_129288_) {
                this.matchEffects.add(new ResourceLocation(effects.m_7916_()));
            } else if (effects.m_6458_() == ListTag.f_128714_) {
                for (Tag element : (ListTag)effects) {
                    this.matchEffects.add(new ResourceLocation(element.m_7916_()));
                }
            }
            this.matchType = null;
        }
        this.modifierConsumer = null;
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        String value;
        String operationSuffix = this.useAddition ? ".addition" : ".multiply";
        String string = value = this.useAddition ? NumberUtil.roundToNthDecimalPlace(this.modifier, 2) : NumberUtil.roundToNthDecimalPlace((this.modifier - 1.0f) * 100.0f, 2);
        if (this.matchType != null) {
            super.updateDescription(Component.m_237110_((String)(((TranslatableContents)defaultDescription.m_214077_()).m_237508_() + operationSuffix + ".type"), (Object[])new Object[]{StringUtil.toTitleCase(this.matchType.toString()), value}));
        } else {
            super.updateDescription(Component.m_237110_((String)(((TranslatableContents)defaultDescription.m_214077_()).m_237508_() + operationSuffix + ".list"), (Object[])new Object[]{value}));
        }
    }

    @Override
    public void handleAppliedPotion(MobEffectEvent.Added ev) {
        MobEffectInstance effect = ev.getEffectInstance();
        if (!this.effectMatches(effect)) {
            return;
        }
        this.reduceEffectDuration(effect, this.modifierConsumer);
    }

    private boolean effectMatches(MobEffectInstance effect) {
        if (this.matchType != null) {
            return effect.m_19544_().m_19483_() == this.matchType;
        }
        return this.matchEffects.contains(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect.m_19544_()));
    }

    private void reduceEffectDuration(MobEffectInstance effect, Consumer<MobEffectInstance> modifier) {
        modifier.accept(effect);
        if (effect.f_19510_ != null) {
            this.reduceEffectDuration(effect.f_19510_, this.modifierConsumer);
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128350_("modifier", this.modifier);
            data.m_128379_("use_addition", this.useAddition);
            if (this.matchType != null) {
                data.m_128359_("match_effect_type", this.matchType.toString());
            } else {
                ListTag effects = new ListTag();
                for (ResourceLocation id : this.matchEffects) {
                    effects.add((Object)StringTag.m_129297_((String)id.toString()));
                }
                data.m_128365_("match_effects", (Tag)effects);
            }
        }
        return data;
    }
}

