/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class OneShotDamageLimiter
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.INCOMING_ATTACK_AFTER};
    private final float restoreHealthTo;
    private final float minActivationHealth;

    public OneShotDamageLimiter(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.ONE_SHOT_DAMAGE_LIMITER.get(), skill, data);
        this.restoreHealthTo = GsonHelper.m_13820_((JsonObject)data, (String)"health_restore_amount", (float)1.0f);
        this.minActivationHealth = GsonHelper.m_13820_((JsonObject)data, (String)"min_activation_health", (float)0.0f);
    }

    public OneShotDamageLimiter(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.ONE_SHOT_DAMAGE_LIMITER.get(), skill, data);
        this.restoreHealthTo = data.m_128457_("health_restore_amount");
        this.minActivationHealth = data.m_128457_("min_activation_health");
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        if (this.minActivationHealth <= 0.0f) {
            super.updateDescription(Component.m_237110_((String)(((TranslatableContents)defaultDescription.m_214077_()).m_237508_() + ".full"), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace(this.restoreHealthTo, 2)}));
        } else {
            super.updateDescription(Component.m_237110_((String)((TranslatableContents)defaultDescription.m_214077_()).m_237508_(), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace(this.minActivationHealth, 2), NumberUtil.roundToNthDecimalPlace(this.restoreHealthTo, 2)}));
        }
    }

    @Override
    public void handlePostIncomingAttack(LivingDamageEvent ev) {
        if (ev.getSource() == DamageSource.f_19317_) {
            return;
        }
        LivingEntity player = ev.getEntity();
        if (player instanceof ServerPlayer && player.m_21223_() - ev.getAmount() <= 0.0f) {
            float f = player.m_21223_();
            float f2 = this.minActivationHealth == 0.0f ? player.m_21233_() : this.minActivationHealth;
            if (f >= f2) {
                ev.setCanceled(true);
                player.m_21153_(this.restoreHealthTo);
                this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.ENERGY.get()).setValue(0.0f);
                if (this.skill.canGainXp(true)) {
                    this.skill.adjustXp(PlayerUtil.getTimeBasedXpForLevel(this.skill.getLevel(true), 500.0f), false, false);
                }
            }
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128350_("health_restore_amount", this.restoreHealthTo);
            data.m_128350_("min_activation_health", this.minActivationHealth);
        }
        return data;
    }
}

