/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;

public class OnKillDamageBoost
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.OUTGOING_ATTACK_DURING, AoAPlayerEventListener.ListenerType.ENTITY_KILL};
    private long boostExpiry;
    private final float modifier;
    private final int postKillDuration;

    public OnKillDamageBoost(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.ON_KILL_DAMAGE_BOOST.get(), skill, data);
        this.modifier = GsonHelper.m_13915_((JsonObject)data, (String)"modifier");
        this.postKillDuration = GsonHelper.m_13927_((JsonObject)data, (String)"post_kill_ticks");
    }

    public OnKillDamageBoost(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.ON_KILL_DAMAGE_BOOST.get(), skill, data);
        this.modifier = data.m_128457_("modifier");
        this.postKillDuration = data.m_128451_("post_kill_ticks");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.m_237110_((String)((TranslatableContents)defaultDescription.m_214077_()).m_237508_(), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace((this.modifier - 1.0f) * 100.0f, 2), NumberUtil.roundToNthDecimalPlace((float)this.postKillDuration / 20.0f, 2)}));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleOutgoingAttack(LivingHurtEvent ev) {
        if (ev.getEntity().f_19853_.m_46467_() < this.boostExpiry && !ev.getSource().m_19372_()) {
            ev.setAmount(ev.getAmount() * this.modifier);
        }
    }

    @Override
    public void handleEntityKill(LivingDeathEvent ev) {
        this.boostExpiry = ev.getEntity().f_19853_.m_46467_() + (long)this.postKillDuration;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128350_("modifier", this.modifier);
            data.m_128405_("post_kill_ticks", this.postKillDuration);
        }
        return data;
    }
}

