/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.PlayerLevelChangeEvent;
import net.tslat.aoa3.library.object.SupplierContents;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.StringUtil;

public class AttributeModification
extends ScalableModAbility {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.ATTRIBUTE_MODIFIERS, AoAPlayerEventListener.ListenerType.LEVEL_CHANGE};
    private final Attribute attribute;
    private final AttributeModifier modifier;
    private float loginHealth = -1.0f;

    public AttributeModification(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.ATTRIBUTE_MODIFICATION.get(), skill, data);
        this.attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)data, (String)"attribute")));
        this.modifier = new AttributeModifier(UUID.randomUUID(), this.getUniqueIdentifier(), 0.0, AttributeModifier.Operation.m_22236_((int)GsonHelper.m_13927_((JsonObject)data, (String)"operation"))){

            public double m_22218_() {
                return AttributeModification.this.getScaledValue();
            }
        };
    }

    public AttributeModification(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.ATTRIBUTE_MODIFICATION.get(), skill, data);
        this.attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(data.m_128461_("attribute")));
        this.modifier = new AttributeModifier(data.m_128342_("uuid"), this.getUniqueIdentifier(), 0.0, AttributeModifier.Operation.m_22236_((int)data.m_128451_("operation"))){

            public double m_22218_() {
                return AttributeModification.this.getScaledValue();
            }
        };
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        Object amount = "";
        String perLevel = "";
        switch (this.modifier.m_22217_()) {
            case MULTIPLY_BASE: 
            case MULTIPLY_TOTAL: {
                if (this.baseValue != 0.0f) {
                    amount = "+" + NumberUtil.roundToNthDecimalPlace(this.baseValue * 100.0f, 3);
                }
                if (this.perLevelMod == 0.0f) break;
                perLevel = NumberUtil.roundToNthDecimalPlace(this.perLevelMod * 100.0f, 3);
                break;
            }
            default: {
                if (this.baseValue != 0.0f) {
                    amount = NumberUtil.roundToNthDecimalPlace(this.baseValue, 3);
                }
                if (this.perLevelMod == 0.0f) break;
                perLevel = NumberUtil.roundToNthDecimalPlace(this.perLevelMod, 3);
            }
        }
        super.updateDescription(Component.m_237110_((String)((TranslatableContents)defaultDescription.m_214077_()).m_237508_(), (Object[])new Object[]{StringUtil.toTitleCase(this.attribute.m_22087_().substring(this.attribute.m_22087_().lastIndexOf(".") + 1)), LocaleUtil.getAbilityValueDesc(this.baseValue != 0.0f, this.perLevelMod != 0.0f, this.modifier.m_22217_() != AttributeModifier.Operation.ADDITION, amount, perLevel, SupplierContents.toComponent(() -> NumberUtil.roundToNthDecimalPlace((float)this.modifier.m_22218_() * (float)(this.modifier.m_22217_() == AttributeModifier.Operation.ADDITION ? 1 : 100), 3)))}));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void applyAttributeModifiers(ServerPlayerDataManager plData) {
        EntityUtil.reapplyAttributeModifier((LivingEntity)plData.player(), this.attribute, this.modifier, false);
        if (this.loginHealth > 0.0f) {
            plData.player().m_21153_(this.loginHealth);
            this.loginHealth = -1.0f;
        }
    }

    @Override
    public void removeAttributeModifiers(ServerPlayerDataManager plData) {
        EntityUtil.removeAttributeModifier((LivingEntity)plData.player(), this.attribute, this.modifier.m_22209_());
    }

    @Override
    public void handleLevelChange(PlayerLevelChangeEvent ev) {
        EntityUtil.reapplyAttributeModifier((LivingEntity)ev.getEntity(), this.attribute, this.modifier, false);
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128359_("attribute", ForgeRegistries.ATTRIBUTES.getKey((Object)this.attribute).toString());
            data.m_128405_("operation", this.modifier.m_22217_().m_22235_());
            data.m_128362_("uuid", this.modifier.m_22209_());
        }
        return data;
    }

    @Override
    public CompoundTag saveToNbt() {
        double health;
        CompoundTag data = super.saveToNbt();
        if (this.attribute == Attributes.f_22276_ && (health = (double)this.getPlayer().m_21223_()) > 0.0) {
            data.m_128347_("current_health", (double)this.getPlayer().m_21223_());
        }
        return data;
    }

    @Override
    public void loadFromNbt(CompoundTag data) {
        super.loadFromNbt(data);
        if (this.attribute == Attributes.f_22276_ && this.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE && data.m_128441_("current_health")) {
            if (this.getLevelReq() == 1) {
                this.loginHealth = (float)data.m_128459_("current_health");
            } else {
                this.getPlayer().m_21153_((float)data.m_128459_("current_health"));
            }
        }
    }
}

