/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player;

import com.google.common.collect.ArrayListMultimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.PlayerDataSyncPacket;
import net.tslat.aoa3.common.packet.packets.PlayerDataUpdatePacket;
import net.tslat.aoa3.common.packet.packets.ToastPopupPacket;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.content.world.teleporter.PortalCoordinatesContainer;
import net.tslat.aoa3.data.server.AoAResourcesReloadListener;
import net.tslat.aoa3.data.server.AoASkillReqReloadListener;
import net.tslat.aoa3.data.server.AoASkillsReloadListener;
import net.tslat.aoa3.event.custom.events.PlayerLevelChangeEvent;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.library.object.PositionAndRotation;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.PlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RandomUtil;

public final class ServerPlayerDataManager
implements AoAPlayerEventListener,
PlayerDataManager {
    private ServerPlayer player;
    private PlayerEquipment equipment;
    private final Object2ObjectOpenHashMap<AoASkill, AoASkill.Instance> skills = new Object2ObjectOpenHashMap(10);
    private final Object2ObjectOpenHashMap<AoAResource, AoAResource.Instance> resources = new Object2ObjectOpenHashMap(1);
    private final ArrayListMultimap<AoAPlayerEventListener.ListenerType, AoAPlayerEventListener> activeEventListeners = ArrayListMultimap.create();
    private final ArrayListMultimap<AoAPlayerEventListener.ListenerType, AoAPlayerEventListener> disabledEventListeners = ArrayListMultimap.create();
    private final ObjectOpenHashSet<AoAPlayerEventListener> dirtyListeners = new ObjectOpenHashSet();
    private Object2ObjectOpenHashMap<ResourceKey<Level>, PortalCoordinatesContainer> portalCoordinatesMap = new Object2ObjectOpenHashMap();
    private ObjectOpenHashSet<ItemStack> itemStorage = null;
    private PositionAndRotation checkpoint = null;
    private CopyOnWriteArraySet<ResourceLocation> patchouliBooks = null;
    private boolean syncBooks = false;
    private boolean isLegitimate = true;
    private boolean abilitiesRegionLocked = false;

    public ServerPlayerDataManager(ServerPlayer player) {
        this.player = player;
        this.equipment = new PlayerEquipment(this);
        this.populateSkillsAndResources();
        this.gatherListeners();
    }

    public ServerPlayer player() {
        return this.player;
    }

    public PlayerEquipment equipment() {
        return this.equipment;
    }

    @Override
    public Collection<AoASkill.Instance> getSkills() {
        return this.skills.values();
    }

    @Override
    @Nonnull
    public AoASkill.Instance getSkill(AoASkill skill) {
        return (AoASkill.Instance)this.skills.getOrDefault((Object)skill, (Object)AoASkills.DEFAULT);
    }

    @Nullable
    public AoAAbility.Instance getAbility(String abilityId) {
        for (AoASkill.Instance skill : this.getSkills()) {
            if (!skill.getAbilityMap().containsKey(abilityId)) continue;
            return skill.getAbilityMap().get(abilityId);
        }
        return null;
    }

    @Override
    public Collection<AoAResource.Instance> getResources() {
        return this.resources.values();
    }

    @Override
    @Nonnull
    public AoAResource.Instance getResource(AoAResource resource) {
        return (AoAResource.Instance)this.resources.getOrDefault((Object)resource, (Object)AoAResources.DEFAULT);
    }

    @Override
    public void loadFromNbt(CompoundTag baseTag) {
        String id;
        this.isLegitimate = baseTag.m_128471_("legitimate");
        int hash = baseTag.m_128451_("hash");
        if (hash == 0) {
            this.applyLegitimacyPenalties();
        } else {
            baseTag.m_128473_("hash");
            if (hash != baseTag.hashCode()) {
                this.applyLegitimacyPenalties();
            }
        }
        if (baseTag.m_128441_("skills")) {
            CompoundTag skillsNbt = baseTag.m_128469_("skills");
            for (AoASkill.Instance skill : this.skills.values()) {
                id = AoARegistries.AOA_SKILLS.getId(skill.type()).toString();
                if (!skillsNbt.m_128441_(id)) continue;
                skill.loadFromNbt(skillsNbt.m_128469_(id));
            }
        }
        if (baseTag.m_128441_("resources")) {
            CompoundTag resourcesNbt = baseTag.m_128469_("resources");
            for (AoAResource.Instance resource : this.resources.values()) {
                id = AoARegistries.AOA_RESOURCES.getId(resource.type()).toString();
                if (!resourcesNbt.m_128441_(id)) continue;
                resource.loadFromNbt(resourcesNbt.m_128469_(id));
            }
        }
        if (baseTag.m_128441_("ItemStorage")) {
            this.itemStorage = new ObjectOpenHashSet();
            CompoundTag itemStorage = baseTag.m_128469_("ItemStorage");
            int i = 0;
            while (itemStorage.m_128441_(String.valueOf(i))) {
                this.itemStorage.add((Object)ItemStack.m_41712_((CompoundTag)itemStorage.m_128469_(String.valueOf(i))));
                ++i;
            }
        }
        if (baseTag.m_128441_("PortalMap")) {
            CompoundTag portalMapTag = baseTag.m_128469_("PortalMap");
            for (String s : portalMapTag.m_128431_()) {
                try {
                    CompoundTag portalReturnTag = portalMapTag.m_128469_(s);
                    ResourceLocation fromDim = new ResourceLocation(portalReturnTag.m_128461_("FromDim"));
                    double x = portalReturnTag.m_128459_("PosX");
                    double y = portalReturnTag.m_128459_("PosY");
                    double z = portalReturnTag.m_128459_("PosZ");
                    ResourceKey toDimKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(s));
                    ResourceKey fromDimKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)fromDim);
                    this.portalCoordinatesMap.put((Object)toDimKey, (Object)new PortalCoordinatesContainer((ResourceKey<Level>)fromDimKey, x, y, z));
                }
                catch (NumberFormatException e) {
                    Logging.logMessage(org.apache.logging.log4j.Level.WARN, "Found invalid portal map data, has someone been tampering with files? Data: " + s);
                }
            }
        }
        if (baseTag.m_128441_("Checkpoint")) {
            try {
                CompoundTag checkpointTag = baseTag.m_128469_("Checkpoint");
                double x = checkpointTag.m_128459_("x");
                double y = checkpointTag.m_128459_("y");
                double z = checkpointTag.m_128459_("z");
                float pitch = checkpointTag.m_128457_("pitch");
                float yaw = checkpointTag.m_128457_("yaw");
                this.checkpoint = new PositionAndRotation(x, y, z, pitch, yaw);
            }
            catch (NumberFormatException e) {
                Logging.logMessage(org.apache.logging.log4j.Level.WARN, "Found invalid checkpoint data, has someone been tampering with files?");
            }
        }
        if (baseTag.m_128441_("PatchouliBooks")) {
            ListTag booksNbt = baseTag.m_128437_("PatchouliBooks", 8);
            if (this.patchouliBooks == null) {
                this.patchouliBooks = new CopyOnWriteArraySet();
            } else if (!this.patchouliBooks.isEmpty()) {
                this.patchouliBooks.clear();
            }
            for (Tag book : booksNbt) {
                this.patchouliBooks.add(new ResourceLocation(book.m_7916_()));
            }
        }
        this.checkAndUpdateLegitimacy();
        baseTag.m_128405_("hash", baseTag.hashCode());
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.PLAYER_DEATH, AoAPlayerEventListener.ListenerType.PLAYER_RESPAWN, AoAPlayerEventListener.ListenerType.PLAYER_CLONE, AoAPlayerEventListener.ListenerType.EQUIPMENT_CHANGE, AoAPlayerEventListener.ListenerType.LEVEL_CHANGE};
    }

    @Override
    public void addListener(AoAPlayerEventListener listener, boolean active, AoAPlayerEventListener.ListenerType ... types) {
        ArrayListMultimap<AoAPlayerEventListener.ListenerType, AoAPlayerEventListener> holder;
        ArrayListMultimap<AoAPlayerEventListener.ListenerType, AoAPlayerEventListener> arrayListMultimap = holder = active ? this.activeEventListeners : this.disabledEventListeners;
        if (types.length > 0) {
            for (AoAPlayerEventListener.ListenerType type : types) {
                holder.put((Object)type, (Object)listener);
            }
        } else {
            holder.put(null, (Object)listener);
        }
    }

    public void removeListener(AoAPlayerEventListener listener, boolean active, AoAPlayerEventListener.ListenerType ... types) {
        ArrayListMultimap<AoAPlayerEventListener.ListenerType, AoAPlayerEventListener> holder;
        ArrayListMultimap<AoAPlayerEventListener.ListenerType, AoAPlayerEventListener> arrayListMultimap = holder = active ? this.activeEventListeners : this.disabledEventListeners;
        if (types.length > 0) {
            for (AoAPlayerEventListener.ListenerType type : types) {
                holder.remove((Object)type, (Object)listener);
            }
        } else {
            holder.remove(null, (Object)listener);
        }
    }

    @Override
    public List<AoAPlayerEventListener> getListeners(AoAPlayerEventListener.ListenerType eventType) {
        return this.activeEventListeners.get((Object)eventType);
    }

    public void markListenerDirty(AoAPlayerEventListener listener) {
        this.dirtyListeners.add((Object)listener);
    }

    @Override
    public void updatePlayerInstance(Player player) {
        this.player = (ServerPlayer)player;
    }

    private void selfDestruct() {
        this.player = null;
        this.equipment = null;
        this.patchouliBooks = null;
        this.checkpoint = null;
        this.skills.clear();
        this.resources.clear();
        this.portalCoordinatesMap.clear();
        this.activeEventListeners.clear();
        if (this.itemStorage != null) {
            this.itemStorage.clear();
        }
    }

    private void populateSkillsAndResources() {
        AoASkillsReloadListener.populateSkillMap(this, this.skills);
        AoAResourcesReloadListener.populateResourceMap(this, this.resources);
    }

    private void gatherListeners() {
        this.addListener(this, true, this.getListenerTypes());
        this.addListener(this.equipment, true, this.equipment.getListenerTypes());
        for (AoASkill.Instance skill : this.skills.values()) {
            this.addListener(skill, true, skill.getListenerTypes());
            for (AoAAbility.Instance ability : skill.getAbilityMap().values()) {
                this.addListener(ability, ability.meetsRequirements(), ability.getListenerTypes());
            }
        }
        for (AoAResource.Instance resource : this.resources.values()) {
            this.addListener(resource, resource.meetsRequirements(), resource.getListenerTypes());
        }
    }

    public static void syncNewPlayer(ServerPlayer pl) {
        ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
        if (plData.patchouliBooks == null && IntegrationManager.isPatchouliActive()) {
            plData.patchouliBooks = new CopyOnWriteArraySet();
            plData.patchouliBooks.add(new ResourceLocation("aoa3", "aoa_essentia"));
        }
        AoAPackets.messagePlayer(pl, new PlayerDataSyncPacket(plData.savetoNbt(true)));
    }

    public void doPlayerTick() {
        if (this.player == null || this.player.m_5833_() || this.player.f_19853_.f_46443_) {
            return;
        }
        if (!this.dirtyListeners.isEmpty()) {
            ObjectIterator listeners = this.dirtyListeners.iterator();
            while (listeners.hasNext()) {
                AoAPlayerEventListener listener = (AoAPlayerEventListener)listeners.next();
                if (listener.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE) {
                    this.addListener(listener, true, listener.getListenerTypes());
                    this.removeListener(listener, false, listener.getListenerTypes());
                } else {
                    this.addListener(listener, false, listener.getListenerTypes());
                    this.removeListener(listener, true, listener.getListenerTypes());
                }
                listeners.remove();
            }
        }
        this.equipment.handleEquipmentCheck(this);
        CompoundTag syncData = null;
        CompoundTag skillData = null;
        CompoundTag resourceData = null;
        for (AoASkill.Instance skill : this.getSkills()) {
            if (!skill.needsSync) continue;
            if (skillData == null) {
                skillData = new CompoundTag();
            }
            skillData.m_128365_(AoARegistries.AOA_SKILLS.getId(skill.type()).toString(), (Tag)skill.getSyncData(false));
        }
        for (AoAResource.Instance resource : this.getResources()) {
            if (!resource.needsSync) continue;
            if (resourceData == null) {
                resourceData = new CompoundTag();
            }
            resourceData.m_128365_(AoARegistries.AOA_RESOURCES.getId(resource.type()).toString(), (Tag)resource.getSyncData(false));
        }
        if (skillData != null) {
            if (syncData == null) {
                syncData = new CompoundTag();
            }
            syncData.m_128365_("skills", (Tag)skillData);
        }
        if (resourceData != null) {
            if (syncData == null) {
                syncData = new CompoundTag();
            }
            syncData.m_128365_("resources", resourceData);
        }
        if (this.syncBooks) {
            if (syncData == null) {
                syncData = new CompoundTag();
            }
            ListTag booksNbt = new ListTag();
            for (ResourceLocation id : this.patchouliBooks) {
                booksNbt.add((Object)StringTag.m_129297_((String)id.toString()));
            }
            syncData.m_128365_("PatchouliBooks", (Tag)booksNbt);
        }
        if (syncData != null) {
            syncData.m_128379_("legitimate", this.isLegitimate);
            AoAPackets.messagePlayer(this.player, new PlayerDataUpdatePacket(syncData));
        }
    }

    private void storeInterventionItems() {
        ItemStack stack;
        int i;
        if (this.itemStorage == null) {
            this.itemStorage = new ObjectOpenHashSet();
        }
        for (i = 0; i < this.player.m_150109_().m_6643_(); ++i) {
            stack = this.player.m_150109_().m_8020_(i);
            if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.INTERVENTION.get()), (ItemStack)stack) <= 0) continue;
            if (RandomUtil.oneInNChance(5)) {
                stack = ItemUtil.removeEnchantment(stack, (Enchantment)AoAEnchantments.INTERVENTION.get());
            }
            this.itemStorage.add((Object)stack);
            this.player.m_150109_().m_6836_(i, ItemStack.f_41583_);
        }
        for (i = 0; i < 4; ++i) {
            stack = (ItemStack)this.player.m_150109_().f_35975_.get(i);
            if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.INTERVENTION.get()), (ItemStack)stack) <= 0) continue;
            if (RandomUtil.oneInNChance(5)) {
                stack = ItemUtil.removeEnchantment(stack, (Enchantment)AoAEnchantments.INTERVENTION.get());
            }
            this.itemStorage.add((Object)stack);
            this.player.m_150109_().f_35975_.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public void returnItemStorage() {
        if (this.itemStorage != null) {
            for (ItemStack stack : this.itemStorage) {
                ItemUtil.givePlayerItemOrDrop((Player)this.player, stack);
            }
            this.itemStorage = null;
        }
    }

    public void storeItems(@Nonnull Collection<ItemStack> stacks) {
        if (this.itemStorage == null) {
            this.itemStorage = new ObjectOpenHashSet();
        }
        this.itemStorage.addAll(stacks);
    }

    public void storeItems(ItemStack ... stacks) {
        this.storeItems(Arrays.asList(stacks));
    }

    public void setPortalReturnLocation(ResourceKey<Level> toDim, PortalCoordinatesContainer coords) {
        this.portalCoordinatesMap.put(toDim, (Object)coords);
    }

    public void removePortalReturnLocation(ResourceKey<Level> toDim) {
        this.portalCoordinatesMap.remove(toDim);
    }

    public void flushPortalReturnLocations() {
        this.portalCoordinatesMap.clear();
    }

    public PortalCoordinatesContainer getPortalReturnLocation(ResourceKey<Level> toDim) {
        return (PortalCoordinatesContainer)this.portalCoordinatesMap.get(toDim);
    }

    public void setCheckpoint(PositionAndRotation pos) {
        this.checkpoint = pos;
    }

    public void clearCheckpoint() {
        this.checkpoint = null;
    }

    @Nullable
    public PositionAndRotation getCheckpoint() {
        return this.checkpoint;
    }

    @Override
    public void handlePlayerDeath(LivingDeathEvent ev) {
        this.storeInterventionItems();
    }

    @Override
    public void handlePlayerRespawn(PlayerEvent.PlayerRespawnEvent ev) {
        this.returnItemStorage();
    }

    @Override
    public void handleLevelChange(PlayerLevelChangeEvent ev) {
        if (!this.abilitiesRegionLocked) {
            this.recheckSkills();
        }
    }

    private void recheckSkills() {
        Consumer<Collection> updateHandler = collection -> collection.forEach(listener -> {
            if (listener.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE) {
                if (!listener.meetsRequirements()) {
                    listener.disable(AoAPlayerEventListener.ListenerState.DEACTIVATED, false);
                }
            } else if (listener.getListenerState() == AoAPlayerEventListener.ListenerState.DEACTIVATED && listener.meetsRequirements()) {
                listener.reenable(false);
                if (listener instanceof AoAAbility.Instance) {
                    AoAAbility.Instance ability = (AoAAbility.Instance)listener;
                    AoAPackets.messagePlayer(this.player, new ToastPopupPacket(ability.getSkill().type(), ability.type()));
                }
            }
        });
        updateHandler.accept(this.activeEventListeners.values());
        updateHandler.accept(this.disabledEventListeners.values());
    }

    public void setInAbilityLockRegion() {
        if (this.activeEventListeners.isEmpty()) {
            return;
        }
        for (AoAPlayerEventListener listener : this.activeEventListeners.values()) {
            listener.disable(AoAPlayerEventListener.ListenerState.REGION_LOCKED, false);
        }
        this.abilitiesRegionLocked = true;
    }

    public void leaveAbilityLockRegion() {
        if (!this.abilitiesRegionLocked) {
            return;
        }
        this.recheckSkills();
        this.abilitiesRegionLocked = false;
    }

    public boolean areAbilitiesRegionLocked() {
        return this.abilitiesRegionLocked;
    }

    public void checkAndUpdateLegitimacy() {
        if (this.player != null) {
            Advancement adv = AdvancementUtil.getAdvancement(new ResourceLocation("aoa3", "completionist/by_the_books"));
            if (adv == null) {
                return;
            }
            PlayerAdvancements plAdv = this.player.m_8960_();
            boolean hasAdvancement = plAdv.m_135996_(adv).m_8193_();
            if (hasAdvancement && !this.isLegitimate) {
                plAdv.m_135998_(adv, "legitimate");
            }
        }
    }

    public void applyLegitimacyPenalties() {
        this.isLegitimate = false;
        this.checkAndUpdateLegitimacy();
    }

    @Override
    public void handleArmourChange(LivingEquipmentChangeEvent ev) {
        this.equipment().markDirty();
    }

    @Override
    public boolean isLegitimate() {
        return this.isLegitimate;
    }

    @Override
    public int getTotalLevel() {
        return 0;
    }

    public void addPatchouliBook(ResourceLocation book) {
        if (this.patchouliBooks == null) {
            this.patchouliBooks = new CopyOnWriteArraySet();
        }
        this.patchouliBooks.add(book);
        this.syncBooks = true;
    }

    @Override
    public void handlePlayerDataClone(PlayerEvent.Clone ev) {
        AoAPlayerEventListener newInstance;
        ev.getOriginal().reviveCaps();
        ServerPlayerDataManager sourceData = PlayerUtil.getAdventPlayer((ServerPlayer)ev.getOriginal());
        for (Map.Entry entry : sourceData.skills.entrySet()) {
            newInstance = (AoASkill.Instance)this.skills.get(entry.getKey());
            if (newInstance == null) continue;
            ((AoASkill.Instance)newInstance).loadFromNbt(((AoASkill.Instance)entry.getValue()).saveToNbt());
        }
        for (Map.Entry entry : sourceData.resources.entrySet()) {
            newInstance = (AoAResource.Instance)this.resources.get(entry.getKey());
            if (newInstance == null) continue;
            ((AoAResource.Instance)newInstance).loadFromNbt(((AoAResource.Instance)entry.getValue()).saveToNbt());
        }
        this.equipment.cooldowns = sourceData.equipment.cooldowns;
        this.portalCoordinatesMap = sourceData.portalCoordinatesMap;
        this.checkpoint = sourceData.checkpoint;
        this.itemStorage = sourceData.itemStorage;
        this.patchouliBooks = sourceData.patchouliBooks;
        this.isLegitimate = sourceData.isLegitimate;
        AoAScheduler.scheduleSyncronisedTask(sourceData::selfDestruct, 1);
        ev.getOriginal().invalidateCaps();
    }

    public CompoundTag savetoNbt(boolean forClientSync) {
        CompoundTag baseTag = new CompoundTag();
        if (!this.skills.isEmpty()) {
            CompoundTag skillsNbt = new CompoundTag();
            for (AoASkill.Instance skill : this.skills.values()) {
                skillsNbt.m_128365_(AoARegistries.AOA_SKILLS.getId(skill.type()).toString(), (Tag)(forClientSync ? skill.getSyncData(true) : skill.saveToNbt()));
            }
            if (!skillsNbt.m_128456_()) {
                baseTag.m_128365_("skills", (Tag)skillsNbt);
            }
        }
        if (!this.resources.isEmpty()) {
            CompoundTag resourcesNbt = new CompoundTag();
            for (AoAResource.Instance resource : this.resources.values()) {
                resourcesNbt.m_128365_(AoARegistries.AOA_RESOURCES.getId(resource.type()).toString(), (Tag)(forClientSync ? resource.getSyncData(true) : resource.saveToNbt()));
            }
            if (!resourcesNbt.m_128456_()) {
                baseTag.m_128365_("resources", (Tag)resourcesNbt);
            }
        }
        if (this.patchouliBooks != null) {
            ListTag booksNbt = new ListTag();
            for (ResourceLocation id : this.patchouliBooks) {
                booksNbt.add((Object)StringTag.m_129297_((String)id.toString()));
            }
            baseTag.m_128365_("PatchouliBooks", (Tag)booksNbt);
        }
        if (!forClientSync) {
            if (this.itemStorage != null) {
                CompoundTag itemStorage = new CompoundTag();
                int i = 0;
                for (ItemStack stack : this.itemStorage) {
                    itemStorage.m_128365_(String.valueOf(i), (Tag)stack.serializeNBT());
                    ++i;
                }
                baseTag.m_128365_("ItemStorage", (Tag)itemStorage);
            }
            if (!this.portalCoordinatesMap.isEmpty()) {
                CompoundTag portalCoordinatesNBT = new CompoundTag();
                for (Map.Entry entry : this.portalCoordinatesMap.entrySet()) {
                    CompoundTag portalReturnTag = new CompoundTag();
                    PortalCoordinatesContainer container = (PortalCoordinatesContainer)entry.getValue();
                    portalReturnTag.m_128359_("FromDim", container.fromDim().m_135782_().toString());
                    portalReturnTag.m_128347_("PosX", container.x());
                    portalReturnTag.m_128347_("PosY", container.y());
                    portalReturnTag.m_128347_("PosZ", container.z());
                    portalCoordinatesNBT.m_128365_(((ResourceKey)entry.getKey()).m_135782_().toString(), (Tag)portalReturnTag);
                }
                baseTag.m_128365_("PortalMap", (Tag)portalCoordinatesNBT);
            }
            if (this.checkpoint != null) {
                CompoundTag checkpointTag = new CompoundTag();
                checkpointTag.m_128347_("x", this.checkpoint.x());
                checkpointTag.m_128347_("y", this.checkpoint.y());
                checkpointTag.m_128347_("z", this.checkpoint.z());
                checkpointTag.m_128350_("pitch", this.checkpoint.pitch());
                checkpointTag.m_128350_("yaw", this.checkpoint.yaw());
                baseTag.m_128365_("Checkpoint", (Tag)checkpointTag);
            }
        }
        baseTag.m_128379_("legitimate", this.isLegitimate);
        baseTag.m_128405_("hash", baseTag.hashCode());
        return baseTag;
    }

    public final class PlayerEquipment
    implements AoAPlayerEventListener {
        private final ServerPlayerDataManager playerDataManager;
        private HashMap<String, Integer> cooldowns = new HashMap(1);
        private HashMap<AdventArmour.Type, ArmourEffectWrapper> armourMap = new HashMap(4);
        private boolean checkEquipment = true;
        private AdventArmour currentFullSet = null;
        private AdventArmour helmet = null;
        private AdventArmour body = null;
        private AdventArmour legs = null;
        private AdventArmour boots = null;

        private PlayerEquipment(ServerPlayerDataManager playerData) {
            this.playerDataManager = playerData;
        }

        public void markDirty() {
            this.checkEquipment = true;
        }

        @Override
        public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
            return new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.INCOMING_ATTACK_BEFORE, AoAPlayerEventListener.ListenerType.INCOMING_ATTACK_DURING, AoAPlayerEventListener.ListenerType.INCOMING_ATTACK_AFTER, AoAPlayerEventListener.ListenerType.OUTGOING_ATTACK_DURING, AoAPlayerEventListener.ListenerType.PLAYER_FALL, AoAPlayerEventListener.ListenerType.PLAYER_DEATH, AoAPlayerEventListener.ListenerType.PLAYER_TICK};
        }

        public boolean isCooledDown(String counter) {
            return !this.cooldowns.containsKey(counter);
        }

        public int getCooldown(String counter) {
            return this.cooldowns.getOrDefault(counter, 0);
        }

        public void setCooldown(String counter, int cooldownTicks) {
            this.cooldowns.put(counter, cooldownTicks);
        }

        public AdventArmour.Type getCurrentFullArmourSet() {
            return this.currentFullSet != null ? this.currentFullSet.setType() : AdventArmour.Type.NONE;
        }

        @Override
        public void handlePreIncomingAttack(LivingAttackEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onPreAttackReceived(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onPreAttackReceived(this.playerDataManager, wrapper.currentSlots, ev);
            }
        }

        @Override
        public void handleIncomingAttack(LivingHurtEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onAttackReceived(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onAttackReceived(this.playerDataManager, wrapper.currentSlots, ev);
            }
        }

        @Override
        public void handleOutgoingAttack(LivingHurtEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onDamageDealt(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onDamageDealt(this.playerDataManager, wrapper.currentSlots, ev);
            }
        }

        @Override
        public void handlePostIncomingAttack(LivingDamageEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onPostAttackReceived(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onPostAttackReceived(this.playerDataManager, wrapper.currentSlots, ev);
            }
        }

        @Override
        public void handlePlayerFall(LivingFallEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onPlayerLandingFall(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onPlayerLandingFall(this.playerDataManager, wrapper.currentSlots, ev);
            }
        }

        @Override
        public void handlePlayerDeath(LivingDeathEvent ev) {
            if (this.currentFullSet != null) {
                this.currentFullSet.onPlayerDeath(this.playerDataManager, null, ev);
            }
            for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                wrapper.armour.onPlayerDeath(this.playerDataManager, wrapper.currentSlots, ev);
            }
        }

        void handleEquipmentCheck(ServerPlayerDataManager playerDataManager) {
            if (!this.checkEquipment) {
                return;
            }
            boolean armourChanged = this.checkAndHandleArmourSwap(this.boots, ((ItemStack)ServerPlayerDataManager.this.player.m_150109_().f_35975_.get(0)).m_41720_(), EquipmentSlot.FEET);
            armourChanged |= this.checkAndHandleArmourSwap(this.legs, ((ItemStack)ServerPlayerDataManager.this.player.m_150109_().f_35975_.get(1)).m_41720_(), EquipmentSlot.LEGS);
            armourChanged |= this.checkAndHandleArmourSwap(this.body, ((ItemStack)ServerPlayerDataManager.this.player.m_150109_().f_35975_.get(2)).m_41720_(), EquipmentSlot.CHEST);
            AdventArmour oldSet = this.currentFullSet;
            if (armourChanged |= this.checkAndHandleArmourSwap(this.helmet, ((ItemStack)ServerPlayerDataManager.this.player.m_150109_().f_35975_.get(3)).m_41720_(), EquipmentSlot.HEAD)) {
                if (this.boots != null && this.legs != null && this.body != null && this.helmet != null && this.boots.setType() == this.legs.setType() && this.legs.setType() == this.body.setType() && this.body.isSetHelmet(this.helmet)) {
                    this.currentFullSet = this.boots;
                    if (this.currentFullSet != oldSet) {
                        if (oldSet != null) {
                            this.unequipAdventArmour(playerDataManager, oldSet, null);
                        }
                        this.equipAdventArmour(playerDataManager, this.currentFullSet, null);
                    }
                } else {
                    this.currentFullSet = null;
                    if (oldSet != null) {
                        this.unequipAdventArmour(playerDataManager, oldSet, null);
                    }
                }
            }
            this.checkEquipment = false;
        }

        private boolean checkAndHandleArmourSwap(@Nullable AdventArmour currentPiece, @Nonnull Item newPiece, @Nonnull EquipmentSlot slot) {
            boolean changed = false;
            if (newPiece != currentPiece) {
                changed = true;
                if (currentPiece != null) {
                    this.unequipAdventArmour(this.playerDataManager, currentPiece, slot);
                }
                switch (slot) {
                    case FEET: {
                        AdventArmour adventArmour = this.boots = newPiece instanceof AdventArmour ? (AdventArmour)newPiece : null;
                        if (this.boots == null || !AoASkillReqReloadListener.canEquip(this.playerDataManager, (Item)this.boots, false)) break;
                        this.equipAdventArmour(this.playerDataManager, this.boots, slot);
                        break;
                    }
                    case LEGS: {
                        AdventArmour adventArmour = this.legs = newPiece instanceof AdventArmour ? (AdventArmour)newPiece : null;
                        if (this.legs == null || !AoASkillReqReloadListener.canEquip(this.playerDataManager, (Item)this.legs, false)) break;
                        this.equipAdventArmour(this.playerDataManager, this.legs, slot);
                        break;
                    }
                    case CHEST: {
                        AdventArmour adventArmour = this.body = newPiece instanceof AdventArmour ? (AdventArmour)newPiece : null;
                        if (this.body == null || !AoASkillReqReloadListener.canEquip(this.playerDataManager, (Item)this.body, false)) break;
                        this.equipAdventArmour(this.playerDataManager, this.body, slot);
                        break;
                    }
                    case HEAD: {
                        AdventArmour adventArmour = this.helmet = newPiece instanceof AdventArmour ? (AdventArmour)newPiece : null;
                        if (this.helmet == null || !AoASkillReqReloadListener.canEquip(this.playerDataManager, (Item)this.helmet, false)) break;
                        this.equipAdventArmour(this.playerDataManager, this.helmet, slot);
                    }
                }
            }
            return changed;
        }

        @Override
        public void handlePlayerTick(TickEvent.PlayerTickEvent ev) {
            if (!ServerPlayerDataManager.this.player.m_6084_() || ServerPlayerDataManager.this.player.m_5833_()) {
                return;
            }
            boolean doArmourTick = true;
            if (PlayerUtil.shouldPlayerBeAffected((Player)ServerPlayerDataManager.this.player)) {
                for (InteractionHand hand : InteractionHand.values()) {
                    ItemStack heldStack = ServerPlayerDataManager.this.player.m_21120_(hand);
                    if (AoASkillReqReloadListener.canEquip(this.playerDataManager, heldStack.m_41720_(), true)) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)ServerPlayerDataManager.this.player, (ItemStack)heldStack);
                    ServerPlayerDataManager.this.player.m_21008_(hand, ItemStack.f_41583_);
                }
                if (this.boots != null && !AoASkillReqReloadListener.canEquip(this.playerDataManager, (Item)this.boots, true)) {
                    doArmourTick = false;
                    ItemHandlerHelper.giveItemToPlayer((Player)ServerPlayerDataManager.this.player, (ItemStack)((ItemStack)ServerPlayerDataManager.this.player.m_150109_().f_35975_.get(0)));
                    ServerPlayerDataManager.this.player.m_150109_().f_35975_.set(0, (Object)ItemStack.f_41583_);
                    this.unequipAdventArmour(this.playerDataManager, this.boots, EquipmentSlot.FEET);
                }
                if (this.legs != null && !AoASkillReqReloadListener.canEquip(this.playerDataManager, (Item)this.legs, true)) {
                    doArmourTick = false;
                    ItemHandlerHelper.giveItemToPlayer((Player)ServerPlayerDataManager.this.player, (ItemStack)((ItemStack)ServerPlayerDataManager.this.player.m_150109_().f_35975_.get(1)));
                    ServerPlayerDataManager.this.player.m_150109_().f_35975_.set(1, (Object)ItemStack.f_41583_);
                    this.unequipAdventArmour(this.playerDataManager, this.legs, EquipmentSlot.LEGS);
                }
                if (this.body != null && !AoASkillReqReloadListener.canEquip(this.playerDataManager, (Item)this.body, true)) {
                    doArmourTick = false;
                    ItemHandlerHelper.giveItemToPlayer((Player)ServerPlayerDataManager.this.player, (ItemStack)((ItemStack)ServerPlayerDataManager.this.player.m_150109_().f_35975_.get(2)));
                    ServerPlayerDataManager.this.player.m_150109_().f_35975_.set(2, (Object)ItemStack.f_41583_);
                    this.unequipAdventArmour(this.playerDataManager, this.body, EquipmentSlot.CHEST);
                }
                if (this.helmet != null && !AoASkillReqReloadListener.canEquip(this.playerDataManager, (Item)this.helmet, true)) {
                    doArmourTick = false;
                    ItemHandlerHelper.giveItemToPlayer((Player)ServerPlayerDataManager.this.player, (ItemStack)((ItemStack)ServerPlayerDataManager.this.player.m_150109_().f_35975_.get(3)));
                    ServerPlayerDataManager.this.player.m_150109_().f_35975_.set(3, (Object)ItemStack.f_41583_);
                    this.unequipAdventArmour(this.playerDataManager, this.helmet, EquipmentSlot.HEAD);
                }
            }
            if (doArmourTick) {
                if (this.currentFullSet != null) {
                    this.currentFullSet.onEffectTick(this.playerDataManager, null);
                }
                for (ArmourEffectWrapper wrapper : this.armourMap.values()) {
                    wrapper.armour.onEffectTick(this.playerDataManager, wrapper.currentSlots);
                }
            }
            this.handleCooldowns();
            ServerPlayerDataManager.this.player.f_36095_.m_38946_();
        }

        private void equipAdventArmour(ServerPlayerDataManager plData, AdventArmour item, @Nullable EquipmentSlot slot) {
            item.onEquip(plData, slot);
            ArmourEffectWrapper armourEffectWrapper = this.armourMap.get((Object)item.setType());
            if (slot != null) {
                if (armourEffectWrapper == null) {
                    this.armourMap.put(item.setType(), new ArmourEffectWrapper(item, slot));
                } else {
                    armourEffectWrapper.currentSlots.add(slot);
                }
            }
        }

        private void unequipAdventArmour(ServerPlayerDataManager plData, AdventArmour item, @Nullable EquipmentSlot slot) {
            item.onUnequip(plData, slot);
            ArmourEffectWrapper armourEffectWrapper = this.armourMap.get((Object)item.setType());
            if (armourEffectWrapper != null && slot != null) {
                if (armourEffectWrapper.currentSlots.size() <= 1) {
                    this.armourMap.remove((Object)item.setType());
                } else {
                    armourEffectWrapper.currentSlots.remove(slot);
                }
            }
        }

        private void handleCooldowns() {
            Iterator<Map.Entry<String, Integer>> cooldownsIterator = this.cooldowns.entrySet().iterator();
            while (cooldownsIterator.hasNext()) {
                Map.Entry<String, Integer> entry = cooldownsIterator.next();
                if (entry.getValue() <= 1) {
                    cooldownsIterator.remove();
                    continue;
                }
                entry.setValue(entry.getValue() - 1);
            }
        }

        private class ArmourEffectWrapper {
            private final AdventArmour armour;
            private final HashSet<EquipmentSlot> currentSlots = new HashSet(4);

            private ArmourEffectWrapper(AdventArmour armour, EquipmentSlot firstSlotEquipped) {
                this.armour = armour;
                this.currentSlots.add(firstSlotEquipped);
            }
        }
    }
}

