/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabLore;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.PlayerAbilityKeybindPacket;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.PlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;

public final class ClientPlayerDataManager
implements PlayerDataManager {
    private LocalPlayer player;
    private final ConcurrentSkipListMap<AoASkill, AoASkill.Instance> skills = new ConcurrentSkipListMap(Comparator.comparing(AoARegistries.AOA_SKILLS::getId));
    private final ConcurrentSkipListMap<AoAResource, AoAResource.Instance> resources = new ConcurrentSkipListMap(Comparator.comparing(AoARegistries.AOA_RESOURCES::getId));
    private final ArrayListMultimap<AoAPlayerEventListener.ListenerType, AoAPlayerEventListener> eventListeners = ArrayListMultimap.create();
    private final ConcurrentHashMap<Integer, ArrayList<AoAPlayerEventListener>> keyListeners = new ConcurrentHashMap(1);
    private boolean isLegitimate = true;
    private int totalLevel = 0;

    public static ClientPlayerDataManager get() {
        return ClientOperations.CLIENT_PLAYER_DATA;
    }

    @Override
    public void updatePlayerInstance(Player pl) {
        this.player = (LocalPlayer)pl;
    }

    public void reset() {
        this.player = null;
        this.isLegitimate = true;
        this.totalLevel = 0;
        this.skills.clear();
        this.resources.clear();
        this.keyListeners.clear();
    }

    public LocalPlayer player() {
        return this.player;
    }

    @Override
    public boolean isLegitimate() {
        return this.isLegitimate;
    }

    @Override
    public int getTotalLevel() {
        return this.totalLevel;
    }

    @Override
    public Collection<AoASkill.Instance> getSkills() {
        return this.skills.values();
    }

    @Override
    @Nonnull
    public AoASkill.Instance getSkill(AoASkill skill) {
        return this.skills.getOrDefault(skill, AoASkills.DEFAULT);
    }

    @Override
    public Collection<AoAResource.Instance> getResources() {
        return this.resources.values();
    }

    @Override
    @Nonnull
    public AoAResource.Instance getResource(AoAResource resource) {
        return this.resources.getOrDefault(resource, AoAResources.DEFAULT);
    }

    public void handleKeyInput(int keycode) {
        if (Minecraft.m_91087_().f_91074_ == null || this.keyListeners.isEmpty() || !this.keyListeners.containsKey(keycode)) {
            return;
        }
        ArrayList<AoAPlayerEventListener> listeners = this.keyListeners.get(keycode);
        ArrayList<String> abilities = new ArrayList<String>(listeners.size());
        for (AoAPlayerEventListener listener : listeners) {
            if (listener.getListenerState() != AoAPlayerEventListener.ListenerState.ACTIVE || !listener.shouldSendKeyPress()) continue;
            abilities.add(((AoAAbility.Instance)listener).getUniqueIdentifier());
        }
        if (!abilities.isEmpty()) {
            AoAPackets.messageServer(new PlayerAbilityKeybindPacket(abilities));
        }
    }

    private void updateTotalLevel() {
        this.totalLevel = 0;
        for (AoASkill.Instance skill : this.skills.values()) {
            this.totalLevel += 100 * skill.getCycles();
            this.totalLevel += skill.getLevel(true);
        }
    }

    @Override
    public void loadFromNbt(CompoundTag baseTag) {
        AoAPlayerEventListener instance;
        this.isLegitimate = baseTag.m_128471_("legitimate");
        int hash = baseTag.m_128451_("hash");
        if (hash == 0) {
            this.isLegitimate = false;
        }
        this.skills.clear();
        this.resources.clear();
        if (baseTag.m_128441_("skills")) {
            CompoundTag skillsNbt = baseTag.m_128469_("skills");
            for (String id : skillsNbt.m_128431_()) {
                AoASkill skill = AoASkills.getSkill(new ResourceLocation(id));
                instance = skill.buildClientInstance(skillsNbt.m_128469_(id));
                this.skills.put(skill, (AoASkill.Instance)instance);
                this.checkForListeners(instance);
                for (AoAAbility.Instance ability : ((AoASkill.Instance)instance).getAbilityMap().values()) {
                    this.checkForListeners(ability);
                }
            }
            this.updateTotalLevel();
        }
        if (baseTag.m_128441_("resources")) {
            CompoundTag resourcesNbt = baseTag.m_128469_("resources");
            for (String id : resourcesNbt.m_128431_()) {
                AoAResource resource = AoAResources.getResource(new ResourceLocation(id));
                instance = resource.buildClientInstance(resourcesNbt.m_128469_(id));
                this.resources.put(resource, (AoAResource.Instance)instance);
                this.checkForListeners(instance);
            }
        }
        if (baseTag.m_128441_("PatchouliBooks")) {
            ArrayList<ResourceLocation> books = new ArrayList<ResourceLocation>();
            ListTag booksNbt = baseTag.m_128437_("PatchouliBooks", 8);
            for (Tag book : booksNbt) {
                books.add(new ResourceLocation(book.m_7916_()));
            }
            AdventGuiTabLore.syncBooks(books);
        }
    }

    @Override
    public void addListener(AoAPlayerEventListener listener, boolean active, AoAPlayerEventListener.ListenerType ... types) {
        for (AoAPlayerEventListener.ListenerType type : types) {
            this.eventListeners.put((Object)type, (Object)listener);
        }
    }

    @Override
    public List<AoAPlayerEventListener> getListeners(AoAPlayerEventListener.ListenerType eventType) {
        return this.eventListeners.get((Object)eventType);
    }

    public void updateData(CompoundTag syncTag) {
        if (syncTag.m_128441_("skills")) {
            CompoundTag skillsData = syncTag.m_128469_("skills");
            for (String key : skillsData.m_128431_()) {
                this.getSkill(AoASkills.getSkill(new ResourceLocation(key))).receiveSyncData(skillsData.m_128469_(key));
            }
            this.updateTotalLevel();
        }
        if (syncTag.m_128441_("resources")) {
            CompoundTag resourcesData = syncTag.m_128469_("resources");
            for (String key : resourcesData.m_128431_()) {
                this.getResource(AoAResources.getResource(new ResourceLocation(key))).receiveSyncData(resourcesData.m_128469_(key));
            }
        }
        if (syncTag.m_128441_("PatchouliBooks")) {
            ArrayList<ResourceLocation> books = new ArrayList<ResourceLocation>();
            ListTag booksNbt = syncTag.m_128437_("PatchouliBooks", 8);
            for (Tag book : booksNbt) {
                books.add(new ResourceLocation(book.m_7916_()));
            }
            AdventGuiTabLore.syncBooks(books);
        }
        if (syncTag.m_128441_("legitimate")) {
            this.isLegitimate = syncTag.m_128471_("legitimate");
        }
    }

    private void checkForListeners(AoAPlayerEventListener listener) {
        for (AoAPlayerEventListener.ListenerType type : listener.getListenerTypes()) {
            if (type == AoAPlayerEventListener.ListenerType.KEY_INPUT) {
                int keyCode = listener.getKeybind().getKey().m_84873_();
                if (!this.keyListeners.containsKey(keyCode)) {
                    this.keyListeners.putIfAbsent(keyCode, new ArrayList(1));
                }
                this.keyListeners.get(keyCode).add(listener);
                return;
            }
            this.addListener(listener, listener.meetsRequirements(), type);
        }
    }
}

