/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.AoASoundBuilderPacket;
import net.tslat.aoa3.util.RandomUtil;

public final class SoundBuilder {
    private SoundEvent sound;
    private SoundSource category = SoundSource.MASTER;
    private Level world = null;
    private Vec3 location = null;
    private long seed = 0L;
    private Entity followingEntity = null;
    private float pitch = 1.0f;
    private float radius = 16.0f;
    private int scheduleDelay = 0;
    private boolean applyTimeDilation = false;
    private boolean inWorld = true;
    private boolean loop = false;
    private int loopDelay = 0;
    private Set<Player> playTo = null;
    private Set<Player> exclude = null;

    public SoundBuilder(Supplier<SoundEvent> sound) {
        this.sound = sound.get();
    }

    public SoundBuilder(SoundEvent sound) {
        this.sound = sound;
    }

    public SoundBuilder atEntity(Entity entity) {
        this.location = entity.m_20182_();
        this.world = entity.f_19853_;
        return this;
    }

    public SoundBuilder atBlock(Level world, BlockPos pos) {
        return this.atPos(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public SoundBuilder atPos(Level world, double x, double y, double z) {
        this.location = new Vec3(x, y, z);
        this.world = world;
        return this;
    }

    public SoundBuilder followEntity(Entity entity) {
        this.world = entity.f_19853_;
        this.followingEntity = entity;
        this.location = entity.m_20182_();
        return this;
    }

    public SoundBuilder radius(float radius) {
        this.radius = radius;
        return this;
    }

    public SoundBuilder pitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public SoundBuilder varyPitch(float scale) {
        this.pitch = Math.max(0.0f, this.pitch + (float)RandomUtil.randomScaledGaussianValue(scale));
        return this;
    }

    public SoundBuilder category(SoundSource category) {
        this.category = category;
        return this;
    }

    public SoundBuilder isMusic() {
        return this.category(SoundSource.MUSIC);
    }

    public SoundBuilder isRecord() {
        return this.category(SoundSource.RECORDS);
    }

    public SoundBuilder isWeather() {
        return this.category(SoundSource.WEATHER);
    }

    public SoundBuilder isBlocks() {
        return this.category(SoundSource.BLOCKS);
    }

    public SoundBuilder isMonster() {
        return this.category(SoundSource.HOSTILE);
    }

    public SoundBuilder isFriendlyMob() {
        return this.category(SoundSource.NEUTRAL);
    }

    public SoundBuilder isPlayer() {
        return this.category(SoundSource.PLAYERS);
    }

    public SoundBuilder isAmbience() {
        return this.category(SoundSource.AMBIENT);
    }

    public SoundBuilder isNarration() {
        return this.category(SoundSource.VOICE);
    }

    public SoundBuilder applyTimeDilation() {
        this.applyTimeDilation = true;
        return this;
    }

    public SoundBuilder schedule(int ticks) {
        this.scheduleDelay = ticks;
        return this;
    }

    public SoundBuilder notInWorld() {
        this.inWorld = false;
        return this;
    }

    public SoundBuilder loopSound() {
        return this.loopSound(0);
    }

    public SoundBuilder loopSound(int afterDelay) {
        this.loop = true;
        this.loopDelay = afterDelay;
        return this;
    }

    public SoundBuilder exclude(Player ... players) {
        if (this.exclude == null) {
            this.exclude = new HashSet<Player>();
        }
        if (this.world == null) {
            this.world = players[0].f_19853_;
        }
        Collections.addAll(this.exclude, players);
        return this;
    }

    public SoundBuilder include(Player ... players) {
        if (this.playTo == null) {
            this.playTo = new HashSet<Player>();
        }
        if (this.world == null) {
            this.world = players[0].f_19853_;
        }
        Collections.addAll(this.playTo, players);
        return this;
    }

    public SoundBuilder seed(long seed) {
        this.seed = seed;
        return this;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public SoundSource getCategory() {
        return this.category;
    }

    public Vec3 getLocation() {
        return this.location;
    }

    public Entity getFollowingEntity() {
        return this.followingEntity;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getScheduledDelay() {
        return this.scheduleDelay;
    }

    public boolean getApplyTimeDilation() {
        return this.applyTimeDilation;
    }

    public boolean getIsInWorld() {
        return this.inWorld;
    }

    public boolean getIsLooping() {
        return this.loop;
    }

    public int getLoopDelay() {
        return this.loopDelay;
    }

    public long getSeed() {
        return this.seed;
    }

    public void play() {
        PlayLevelSoundEvent.AtEntity event;
        if (this.inWorld && ((event = ForgeEventFactory.onPlaySoundAtEntity((Entity)this.followingEntity, (SoundEvent)this.sound, (SoundSource)this.category, (float)(this.radius / 16.0f), (float)this.pitch)).isCanceled() || (this.sound = event.getSound()) == null)) {
            return;
        }
        if (this.world == null || this.world.m_5776_()) {
            ClientOperations.playSoundFromBuilder(this);
        } else {
            AoASoundBuilderPacket packet = new AoASoundBuilderPacket(this);
            if (this.playTo != null) {
                for (Player pl : this.playTo) {
                    if (this.exclude != null && this.exclude.contains(pl)) continue;
                    AoAPackets.messagePlayer((ServerPlayer)pl, packet);
                }
            } else {
                for (ServerPlayer pl : this.world.m_7654_().m_6846_().m_11314_()) {
                    if (pl.f_19853_ != this.world || !(pl.m_20238_(this.location) <= (double)(this.radius * this.radius)) || this.exclude != null && this.exclude.contains(pl)) continue;
                    AoAPackets.messagePlayer(pl, packet);
                }
            }
        }
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(ForgeRegistries.SOUND_EVENTS.getKey((Object)this.sound));
        ArrayList<Section> sections = new ArrayList<Section>();
        for (Section section : Section.values()) {
            if (!section.shouldWrite.test(this)) continue;
            sections.add(section);
        }
        buffer.m_130130_(sections.size());
        for (Section section : sections) {
            buffer.m_130068_((Enum)section);
            section.writer.accept(this, buffer);
        }
    }

    public static SoundBuilder fromNetwork(FriendlyByteBuf buffer) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buffer.m_130281_());
        SoundBuilder builder = new SoundBuilder(sound);
        int sections = buffer.m_130242_();
        for (int i = 0; i < sections; ++i) {
            ((Section)buffer.m_130066_(Section.class)).reader.accept(builder, buffer);
        }
        return builder;
    }

    static enum Section {
        CATEGORY(builder -> builder.category != SoundSource.MASTER, (builder, buffer) -> buffer.m_130068_((Enum)builder.category), (builder, buffer) -> builder.category((SoundSource)buffer.m_130066_(SoundSource.class))),
        LOCATION(builder -> builder.location != null, (builder, buffer) -> {
            buffer.writeDouble(builder.location.m_7096_());
            buffer.writeDouble(builder.location.m_7098_());
            buffer.writeDouble(builder.location.m_7094_());
        }, (builder, buffer) -> builder.atPos(ClientOperations.getWorld(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble())),
        FOLLOWING_ENTITY(builder -> builder.followingEntity != null, (builder, buffer) -> buffer.m_130130_(builder.followingEntity.m_19879_()), (builder, buffer) -> builder.followEntity(ClientOperations.getWorld().m_6815_(buffer.m_130242_()))),
        PITCH(builder -> builder.pitch != 1.0f, (builder, buffer) -> buffer.writeFloat(builder.pitch), (builder, buffer) -> builder.pitch(buffer.readFloat())),
        RADIUS(builder -> builder.radius != 16.0f, (builder, buffer) -> buffer.writeFloat(builder.radius), (builder, buffer) -> builder.radius(buffer.readFloat())),
        SCHEDULE_DELAY(builder -> builder.scheduleDelay != 0, (builder, buffer) -> buffer.m_130130_(builder.scheduleDelay), (builder, buffer) -> builder.schedule(buffer.m_130242_())),
        TIME_DILATION(builder -> builder.applyTimeDilation, (builder, buffer) -> {}, (builder, buffer) -> builder.applyTimeDilation()),
        IN_WORLD(builder -> !builder.inWorld, (builder, buffer) -> {}, (builder, buffer) -> builder.notInWorld()),
        LOOP(builder -> builder.loop, (builder, buffer) -> {}, (builder, buffer) -> builder.loopSound()),
        LOOP_DELAY(builder -> builder.loopDelay != 0, (builder, buffer) -> buffer.m_130130_(builder.loopDelay), (builder, buffer) -> builder.loopSound(buffer.m_130242_()));

        final Predicate<SoundBuilder> shouldWrite;
        final BiConsumer<SoundBuilder, FriendlyByteBuf> writer;
        final BiConsumer<SoundBuilder, FriendlyByteBuf> reader;

        private Section(Predicate<SoundBuilder> shouldWrite, BiConsumer<SoundBuilder, FriendlyByteBuf> writer, BiConsumer<SoundBuilder, FriendlyByteBuf> reader) {
            this.shouldWrite = shouldWrite;
            this.writer = writer;
            this.reader = reader;
        }
    }
}

