/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event.dimension;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.block.functional.portal.NowhereActivityPortal;
import net.tslat.aoa3.content.block.functional.utility.TeaSink;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.content.item.tablet.TabletItem;
import net.tslat.aoa3.library.constant.BossDropsScheme;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.TagUtil;

public final class NowhereEvents {
    public static void doPlayerTick(TickEvent.PlayerTickEvent ev) {
        Player pl = ev.player;
        if (ev.phase == TickEvent.Phase.START) {
            if (pl instanceof ServerPlayer) {
                ServerPlayer serverPl = (ServerPlayer)pl;
                if (pl.m_20185_() > 10000.0 && pl.m_20189_() > 10000.0) {
                    if (PlayerUtil.shouldPlayerBeAffected((Player)serverPl)) {
                        PlayerUtil.getAdventPlayer(serverPl).setInAbilityLockRegion();
                    }
                } else {
                    PlayerUtil.getAdventPlayer(serverPl).leaveAbilityLockRegion();
                }
            }
        } else {
            pl.m_150110_().f_35938_ = pl.m_7500_();
            if (PlayerUtil.shouldPlayerBeAffected(pl)) {
                if (pl.m_20186_() < (double)pl.f_19853_.m_141937_()) {
                    pl.f_19789_ = -1.0f;
                    if (pl instanceof ServerPlayer) {
                        NowhereActivityPortal.Activity.RETURN.teleport((ServerPlayer)pl);
                    }
                }
                if (pl.m_21255_()) {
                    pl.m_36321_();
                }
                if (pl.m_20185_() > 0.0 && pl.m_20189_() > 0.0) {
                    FoodData foodData = pl.m_36324_();
                    foodData.m_38705_(20);
                    foodData.m_150378_(0.0f);
                    foodData.m_38717_(20.0f);
                }
            }
        }
    }

    public static void doDimensionChange(PlayerEvent.PlayerChangedDimensionEvent ev) {
        ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayer)ev.getEntity());
        plData.returnItemStorage();
        plData.clearCheckpoint();
        ItemUtil.clearInventoryOfItems(ev.getEntity(), new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()));
        ((ServerPlayer)ev.getEntity()).f_8941_.m_9290_().m_46398_(ev.getEntity().m_150110_());
    }

    public static void doDeathPrevention(LivingDamageEvent ev, ServerPlayerDataManager plData) {
        ServerPlayer player = plData.player();
        LivingEntity killer = player.m_21232_();
        player.m_36329_().m_83427_(ObjectiveCriteria.f_83590_, player.m_6302_(), Score::m_83392_);
        if (killer != null) {
            player.m_36246_(Stats.f_12987_.m_12902_((Object)killer.m_6095_()));
            killer.m_5993_((Entity)player, 1, ev.getSource());
        }
        player.m_36220_(Stats.f_12935_);
        player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12991_));
        player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_));
        NowhereActivityPortal.Activity.RETURN.teleport(plData.player());
        player.m_240418_((Component)LocaleUtil.getLocaleMessage("deathScreen.title", ChatFormatting.DARK_RED, new Component[0]), true);
        ev.setCanceled(true);
    }

    public static void handleNowhereRightClickItem(PlayerInteractEvent.RightClickItem ev) {
        Item item = ev.getItemStack().m_41720_();
        if (item instanceof MinecartItem || item instanceof BoatItem) {
            ev.setCanceled(true);
        }
    }

    public static void handleNowhereRightClickBlock(PlayerInteractEvent.RightClickBlock ev) {
        BlockState blockState = ev.getLevel().m_8055_(ev.getPos());
        Block block = blockState.m_60734_();
        Item heldItem = ev.getEntity().m_21120_(ev.getHand()).m_41720_();
        if (block == Blocks.f_50131_) {
            if (heldItem == Items.f_41852_ || heldItem instanceof RecordItem) {
                ev.setUseItem(Event.Result.ALLOW);
                ev.setUseBlock(Event.Result.ALLOW);
                ev.getEntity().m_150110_().f_35938_ = true;
            }
        } else if (TagUtil.isTaggedAs(block, AoATags.Blocks.NOWHERE_SAFE_GUI_BLOCK)) {
            ev.setUseItem(Event.Result.DENY);
        } else if (block == Blocks.f_152476_) {
            ev.setUseItem(Event.Result.DENY);
            AoAScheduler.scheduleSyncronisedTask(() -> ev.getLevel().m_7731_(ev.getPos(), (BlockState)blockState.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 2), 1);
        } else if (block == AoABlocks.TEA_SINK.get()) {
            ev.setUseItem(Event.Result.DENY);
            AoAScheduler.scheduleSyncronisedTask(() -> ev.getLevel().m_7731_(ev.getPos(), (BlockState)blockState.m_61124_((Property)TeaSink.FILLED, (Comparable)Boolean.valueOf(true)), 2), 1);
        } else if (heldItem instanceof TabletItem || heldItem == AoAItems.LOTTO_TOTEM.get()) {
            ev.setUseItem(Event.Result.ALLOW);
            ev.setUseBlock(Event.Result.DENY);
            ev.getEntity().m_150110_().f_35938_ = true;
        } else {
            ev.setCanceled(true);
        }
    }

    public static void handleLoot(LivingDropsEvent ev) {
        block3: {
            block2: {
                LivingEntity livingEntity = ev.getEntity();
                if (!(livingEntity instanceof AoABoss)) break block2;
                AoABoss boss = (AoABoss)livingEntity;
                if (!ev.isCanceled()) break block3;
            }
            ev.setCanceled(true);
            return;
        }
        ((BossDropsScheme)((Object)AoAConfigs.SERVER.bossDropsScheme.get())).handleDrops(ev);
    }
}

