/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.world.spawner.PixonSpawner;
import net.tslat.aoa3.content.world.spawner.TraderSpawner;
import net.tslat.aoa3.content.world.spawner.VisualentSpawner;
import net.tslat.aoa3.leaderboard.SkillsLeaderboard;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.WebUtil;

public final class GlobalEvents {
    public static int tick;

    public static void preInit() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, false, TickEvent.ServerTickEvent.class, GlobalEvents::serverTick);
        forgeBus.addListener(EventPriority.NORMAL, false, LevelEvent.Load.class, GlobalEvents::worldLoad);
        forgeBus.addListener(EventPriority.NORMAL, false, ServerStartingEvent.class, GlobalEvents::serverStarting);
        forgeBus.addListener(EventPriority.NORMAL, false, ServerStartedEvent.class, GlobalEvents::serverStarted);
        forgeBus.addListener(EventPriority.NORMAL, false, ServerStoppingEvent.class, GlobalEvents::serverStopping);
    }

    private static void serverTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            AoAScheduler.handleSyncScheduledTasks(++tick);
        }
    }

    private static void worldLoad(LevelEvent.Load ev) {
        LevelAccessor levelAccessor = ev.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            ArrayList<Object> spawners = new ArrayList<Object>(world.f_8558_);
            if (PixonSpawner.isValidSpawnWorld(world)) {
                spawners.add(new PixonSpawner());
            }
            if (world.m_46472_() == AoADimensions.LUNALUS.key) {
                spawners.add(new VisualentSpawner());
            }
            if (TraderSpawner.isValidSpawnWorld(world)) {
                spawners.add(new TraderSpawner());
            }
            world.f_8558_ = ImmutableList.copyOf(spawners);
        }
    }

    private static void serverStarting(ServerStartingEvent ev) {
        WebUtil.extraPlayerHalosFromWeb();
        AoAScheduler.serverStartupTasks();
    }

    private static void serverStarted(ServerStartedEvent ev) {
        if (ev.getServer().m_6982_()) {
            SkillsLeaderboard.init();
        }
    }

    private static void serverStopping(ServerStoppingEvent ev) {
        if (ev.getServer().m_6982_()) {
            AoAScheduler.serverShutdownTasks();
        }
    }
}

