/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.teleporter;

import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.portal.PortalBlock;
import net.tslat.aoa3.content.world.teleporter.PortalCoordinatesContainer;
import net.tslat.aoa3.content.world.teleporter.specific.NowhereTeleporter;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public abstract class AoATeleporter
implements ITeleporter {
    public abstract HashMap<Long, BlockPos> getCachedPortalMap();

    public abstract PortalBlock getPortalBlock();

    public abstract Block getBorderBlock();

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> entityPlacementFunction) {
        ServerPlayerDataManager plData = null;
        boolean failedPortalReturn = false;
        BlockPos startPos = entity.m_20183_();
        if (entity instanceof ServerPlayer) {
            entity.m_20242_(false);
            plData = PlayerUtil.getAdventPlayer((ServerPlayer)entity);
            PortalCoordinatesContainer loc = plData.getPortalReturnLocation((ResourceKey<Level>)currentWorld.m_46472_());
            if (loc != null) {
                BlockPos locPos = loc.asBlockPos();
                Block locationBlock = destWorld.m_8055_(locPos).m_60734_();
                if (locationBlock == this.getPortalBlock()) {
                    return this.positionPlayer((ServerPlayer)entity, new Vec3((double)((float)locPos.m_123341_() + 0.5f), (double)((float)locPos.m_123342_() + 0.5f), (double)((float)locPos.m_123343_() + 0.5f)), currentWorld, destWorld, false);
                }
                if (!(locationBlock instanceof PortalBlock)) {
                    plData.removePortalReturnLocation((ResourceKey<Level>)currentWorld.m_46472_());
                    failedPortalReturn = true;
                }
            }
        }
        if (currentWorld.m_8055_(entity.m_20183_()).m_60734_() == this.getPortalBlock()) {
            ChunkPos chunkPos = currentWorld.m_46865_(entity.m_20183_()).m_7697_();
            this.getCachedPortalMap().put(ChunkPos.m_45589_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_), entity.m_20183_());
        }
        BlockPos pos = null;
        if (failedPortalReturn && WorldUtil.isWorld((Level)destWorld, AoADimensions.NOWHERE.key) && !(this instanceof NowhereTeleporter)) {
            pos = new BlockPos(16, 1003, 16);
        }
        if (pos == null) {
            pos = this.findExistingPortal((Level)destWorld, entity);
        }
        if (pos == null) {
            pos = this.findSuitablePortalLocation((Level)destWorld, entity);
            pos = this.makePortal((Level)destWorld, entity, pos);
        }
        Vec3 teleportPos = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
        ChunkPos chunkPos = destWorld.m_46865_(pos).m_7697_();
        this.getCachedPortalMap().put(ChunkPos.m_45589_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_), pos);
        if (plData != null) {
            PortalCoordinatesContainer returnPortalLoc;
            PortalCoordinatesContainer portalLoc = plData.getPortalReturnLocation((ResourceKey<Level>)destWorld.m_46472_());
            if (portalLoc != null && (returnPortalLoc = plData.getPortalReturnLocation((ResourceKey<Level>)entity.f_19853_.m_46472_())) != null && returnPortalLoc.fromDim() == destWorld.m_46472_()) {
                return this.positionPlayer((ServerPlayer)entity, teleportPos, currentWorld, destWorld, false);
            }
            if (portalLoc == null || entity.f_19853_.m_46472_() == portalLoc.fromDim() || entity.m_20238_(BlockUtil.posToVec(portalLoc.asBlockPos())) > (double)((Integer)AoAConfigs.SERVER.portalSearchRadius.get()).intValue()) {
                plData.setPortalReturnLocation((ResourceKey<Level>)destWorld.m_46472_(), new PortalCoordinatesContainer((ResourceKey<Level>)currentWorld.m_46472_(), startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_()));
            }
        }
        return entity instanceof ServerPlayer ? this.positionPlayer((ServerPlayer)entity, teleportPos, currentWorld, destWorld, false) : this.positionNonPlayer(entity, teleportPos, destWorld, false);
    }

    private Entity positionPlayer(ServerPlayer entity, Vec3 position, ServerLevel fromWorld, ServerLevel toWorld, boolean spawnPortal) {
        fromWorld.m_46473_().m_6180_("moving");
        if (fromWorld.m_46472_() == Level.f_46428_ && toWorld.m_46472_() == Level.f_46429_) {
            entity.f_8933_ = entity.m_20182_();
        } else if (spawnPortal && toWorld.m_46472_() == Level.f_46430_) {
            BlockPos originPos = new BlockPos(position);
            BlockPos.MutableBlockPos mutablePos = originPos.m_122032_();
            for (int z = -2; z <= 2; ++z) {
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y < 3; ++y) {
                        BlockState state = y == -1 ? Blocks.f_50080_.m_49966_() : Blocks.f_50016_.m_49966_();
                        toWorld.m_46597_((BlockPos)mutablePos.m_122190_((Vec3i)originPos).m_122184_(x, y, z), state);
                    }
                }
            }
        }
        fromWorld.m_46473_().m_7238_();
        fromWorld.m_46473_().m_6180_("placing");
        entity.m_143425_(toWorld);
        toWorld.m_8817_(entity);
        entity.m_6027_(position.m_7096_(), position.m_7098_(), position.m_7094_());
        fromWorld.m_46473_().m_7238_();
        entity.m_9209_(fromWorld);
        return entity;
    }

    private Entity positionNonPlayer(Entity entity, Vec3 position, ServerLevel toWorld, boolean spawnPortal) {
        entity.f_19853_.m_46473_().m_6182_("reloading");
        Entity newEntity = entity.m_6095_().m_20615_((Level)toWorld);
        if (newEntity != null) {
            newEntity.m_20361_(entity);
            newEntity.m_7678_(position.m_7096_(), position.m_7098_(), position.m_7094_(), entity.m_146908_(), entity.m_146909_());
            newEntity.m_20256_(entity.m_20184_());
            toWorld.m_143334_(newEntity);
            if (spawnPortal && toWorld.m_46472_() == Level.f_46430_) {
                ServerLevel.m_8617_((ServerLevel)toWorld);
            }
        }
        return newEntity;
    }

    public BlockPos findExistingPortal(Level world, Entity entity) {
        int z;
        int x;
        int posX = (int)Math.floor(entity.m_20185_());
        int posY = (int)Math.floor(entity.m_20186_());
        int posZ = (int)Math.floor(entity.m_20189_());
        ChunkPos chunkPos = new ChunkPos(new BlockPos(posX, posY, posZ));
        Long chunkPosLong = ChunkPos.m_45589_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_);
        HashMap<Long, BlockPos> cachedPortalMap = this.getCachedPortalMap();
        if (cachedPortalMap.containsKey(chunkPosLong)) {
            BlockPos pos = cachedPortalMap.get(chunkPosLong);
            if (world.m_8055_(pos).m_60734_() == this.getPortalBlock()) {
                return cachedPortalMap.get(chunkPosLong);
            }
            cachedPortalMap.remove(chunkPosLong);
        }
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int searchRadius = (Integer)AoAConfigs.SERVER.portalSearchRadius.get();
        int worldHeight = world.m_6042_().f_63865_();
        if (posY >= worldHeight) {
            posY = 65;
        }
        if (world.m_8055_((BlockPos)checkPos.m_122178_(posX, posY, posZ)).m_60734_() == this.getPortalBlock()) {
            while (world.m_8055_((BlockPos)checkPos.m_122173_(Direction.DOWN)).m_60734_() == this.getPortalBlock()) {
            }
            ChunkAccess chunk = world.m_46865_((BlockPos)checkPos.m_122173_(Direction.UP));
            cachedPortalMap.put(ChunkPos.m_45589_((int)chunk.m_7697_().m_45605_(), (int)chunk.m_7697_().m_45605_()), (BlockPos)checkPos);
            return checkPos;
        }
        for (int i = 1; i <= searchRadius; ++i) {
            for (int y = -i; y <= i; y += i * 2) {
                int y2 = posY + y;
                if (y2 < 0 || y2 >= worldHeight) continue;
                int xNeg = -1;
                for (int x2 = 0; x2 <= i; ++x2) {
                    int x22 = posX + x2 * xNeg;
                    if (xNeg == 1 && x2 != 0) {
                        --x2;
                    }
                    xNeg *= -1;
                    int zNeg = -1;
                    for (int z2 = 0; z2 <= i; ++z2) {
                        int z22 = posZ + z2 * zNeg;
                        if (zNeg == 1 && z2 != 0) {
                            --z2;
                        }
                        zNeg *= -1;
                        checkPos.m_122178_(x22, y2, z22);
                        if (world.m_8055_((BlockPos)checkPos).m_60734_() != this.getPortalBlock()) continue;
                        while (world.m_8055_((BlockPos)checkPos.m_122173_(Direction.DOWN)).m_60734_() == this.getPortalBlock()) {
                        }
                        ChunkAccess chunk = world.m_46865_((BlockPos)checkPos.m_122173_(Direction.UP));
                        cachedPortalMap.put(ChunkPos.m_45589_((int)chunk.m_7697_().m_45604_(), (int)chunk.m_7697_().m_45605_()), (BlockPos)checkPos);
                        return checkPos;
                    }
                }
            }
            int yNeg = -1;
            for (int y = 0; y <= i - 1; ++y) {
                int y2 = posY + y * yNeg;
                if (y2 < 0 || y2 >= worldHeight) continue;
                if (yNeg == 1 && y != 0) {
                    --y;
                }
                yNeg *= -1;
                int zNeg = -1;
                for (int z3 = 0; z3 <= i; ++z3) {
                    int z2 = posZ + z3 * zNeg;
                    if (zNeg == 1 && z3 != 0) {
                        --z3;
                    }
                    zNeg *= -1;
                    for (int x3 = -i; x3 <= i; x3 += i * 2) {
                        int x2 = posX + x3;
                        checkPos.m_122178_(x2, y2, z2);
                        if (world.m_8055_((BlockPos)checkPos).m_60734_() != this.getPortalBlock()) continue;
                        while (world.m_8055_((BlockPos)checkPos.m_122173_(Direction.DOWN)).m_60734_() == this.getPortalBlock()) {
                        }
                        ChunkAccess chunk = world.m_46865_((BlockPos)checkPos.m_122173_(Direction.UP));
                        cachedPortalMap.put(ChunkPos.m_45589_((int)chunk.m_7697_().m_45604_(), (int)chunk.m_7697_().m_45605_()), (BlockPos)checkPos);
                        return checkPos;
                    }
                }
                int xNeg = 1;
                for (int x4 = 1; x4 <= i - 1; ++x4) {
                    int x2 = posX + x4 * xNeg;
                    if (xNeg == 1 && x4 != 0) {
                        --x4;
                    }
                    xNeg *= -1;
                    for (int z4 = -i; z4 <= i; z4 += i * 2) {
                        int z2 = posZ + z4;
                        checkPos.m_122178_(x2, y2, z2);
                        if (world.m_8055_((BlockPos)checkPos).m_60734_() != this.getPortalBlock()) continue;
                        while (world.m_8055_((BlockPos)checkPos.m_122173_(Direction.DOWN)).m_60734_() == this.getPortalBlock()) {
                        }
                        ChunkAccess chunk = world.m_46865_((BlockPos)checkPos.m_122173_(Direction.UP));
                        cachedPortalMap.put(ChunkPos.m_45589_((int)chunk.m_7697_().m_45604_(), (int)chunk.m_7697_().m_45605_()), (BlockPos)checkPos);
                        return checkPos;
                    }
                }
            }
        }
        for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
            for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                checkPos.m_122178_(x, posY - searchRadius, z);
                while (world.m_8055_((BlockPos)checkPos.m_122173_(Direction.DOWN)).m_60734_() != this.getPortalBlock() && checkPos.m_123342_() >= 0) {
                }
                if (world.m_8055_((BlockPos)checkPos).m_60734_() != this.getPortalBlock()) continue;
                while (world.m_8055_((BlockPos)checkPos.m_122173_(Direction.DOWN)).m_60734_() == this.getPortalBlock()) {
                }
                return checkPos.m_6630_(2).m_7949_();
            }
        }
        for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
            for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                checkPos.m_122178_(x, posY + searchRadius, z);
                while (world.m_8055_((BlockPos)checkPos.m_122173_(Direction.UP)).m_60734_() != this.getPortalBlock() && checkPos.m_123342_() < worldHeight) {
                }
                if (world.m_8055_((BlockPos)checkPos).m_60734_() != this.getPortalBlock()) continue;
                return checkPos.m_6630_(1).m_7949_();
            }
        }
        return null;
    }

    public BlockPos findSuitablePortalLocation(Level world, Entity entity) {
        int y2;
        int z2;
        int x2;
        int y;
        int z;
        int x;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int posX = (int)Math.floor(entity.m_20185_());
        int posY = (int)Math.floor(entity.m_20186_());
        int posZ = (int)Math.floor(entity.m_20189_());
        BlockPos planBPos = null;
        int searchRadius = (Integer)AoAConfigs.SERVER.portalSearchRadius.get();
        int worldHeight = world.m_6042_().f_63865_();
        if (posY >= worldHeight) {
            posY = 65;
        }
        boolean cleanSpawn = true;
        for (x = posX - 2; x <= posX + 2 && cleanSpawn; ++x) {
            for (z = posZ - 2; z <= posZ + 2 && cleanSpawn; ++z) {
                for (y = posY + 1; y <= posY + 6 && cleanSpawn; ++y) {
                    if (y < worldHeight && world.m_46859_((BlockPos)checkPos.m_122178_(x, y, z))) continue;
                    cleanSpawn = false;
                }
            }
        }
        if (cleanSpawn) {
            if (!world.m_46859_((BlockPos)checkPos.m_122178_(posX, posY, posZ))) {
                return checkPos.m_122178_(posX, posY + 2, posZ).m_7949_();
            }
            planBPos = checkPos.m_122178_(posX, posY + 2, posZ).m_7949_();
        }
        for (int i = 1; i <= searchRadius; ++i) {
            int y3;
            int z3;
            int x3;
            for (int y4 = -i; y4 <= i; y4 += i * 2) {
                int y22 = posY + y4;
                if (y22 < 0 || y22 >= worldHeight - 6) continue;
                int xNeg = -1;
                for (int x4 = 0; x4 <= i; ++x4) {
                    int x22 = posX + x4 * xNeg;
                    if (xNeg == 1 && x4 != 0) {
                        --x4;
                    }
                    xNeg *= -1;
                    int zNeg = -1;
                    for (int z4 = 0; z4 <= i; ++z4) {
                        int z22 = posZ + z4 * zNeg;
                        if (zNeg == 1 && z4 != 0) {
                            --z4;
                        }
                        zNeg *= -1;
                        if (!world.m_46859_((BlockPos)checkPos.m_122178_(x22, y22, z22))) {
                            cleanSpawn = true;
                            for (x3 = x22 - 2; x3 <= x22 + 2 && cleanSpawn; ++x3) {
                                for (z3 = z22 - 2; z3 <= z22 + 2 && cleanSpawn; ++z3) {
                                    for (y3 = y22 + 1; y3 <= y22 + 6 && cleanSpawn; ++y3) {
                                        if (world.m_46859_((BlockPos)checkPos.m_122178_(x3, y3, z3))) continue;
                                        cleanSpawn = false;
                                    }
                                }
                            }
                            if (!cleanSpawn) continue;
                            return checkPos.m_122178_(x22, y22 + 2, z22).m_7949_();
                        }
                        if (planBPos != null) continue;
                        cleanSpawn = true;
                        for (x3 = x22 - 2; x3 <= x22 + 2 && cleanSpawn; ++x3) {
                            for (z3 = z22 - 2; z3 <= z22 + 2 && cleanSpawn; ++z3) {
                                for (y3 = y22 + 1; y3 <= y22 + 6 && cleanSpawn; ++y3) {
                                    if (world.m_46859_((BlockPos)checkPos.m_122178_(x3, y3, z3))) continue;
                                    cleanSpawn = false;
                                }
                            }
                        }
                        if (!cleanSpawn) continue;
                        planBPos = checkPos.m_122178_(x22, y22 + 2, z22).m_7949_();
                    }
                }
            }
            int yNeg = -1;
            for (y = 0; y <= i - 1; ++y) {
                int y23 = posY + y * yNeg;
                if (y23 < 0 || y23 >= worldHeight - 6) continue;
                if (yNeg == 1 && y != 0) {
                    --y;
                }
                yNeg *= -1;
                int zNeg = -1;
                for (int z5 = 0; z5 <= i; ++z5) {
                    int z23 = posZ + z5 * zNeg;
                    if (zNeg == 1 && z5 != 0) {
                        --z5;
                    }
                    zNeg *= -1;
                    for (int x5 = -i; x5 <= i; x5 += i * 2) {
                        int x23 = posX + x5;
                        if (!world.m_46859_((BlockPos)checkPos.m_122178_(x23, y23, z23))) {
                            cleanSpawn = true;
                            for (x3 = x23 - 2; x3 <= x23 + 2 && cleanSpawn; ++x3) {
                                for (z3 = z23 - 2; z3 <= z23 + 2 && cleanSpawn; ++z3) {
                                    for (y3 = y23 + 1; y3 <= y23 + 6 && cleanSpawn; ++y3) {
                                        if (world.m_46859_((BlockPos)checkPos.m_122178_(x3, y3, z3))) continue;
                                        cleanSpawn = false;
                                    }
                                }
                            }
                            if (!cleanSpawn) continue;
                            return checkPos.m_122178_(x23, y23 + 2, z23).m_7949_();
                        }
                        if (planBPos != null) continue;
                        cleanSpawn = true;
                        for (x3 = x23 - 2; x3 <= x23 + 2 && cleanSpawn; ++x3) {
                            for (z3 = z23 - 2; z3 <= z23 + 2 && cleanSpawn; ++z3) {
                                for (y3 = y23 + 1; y3 <= y23 + 6 && cleanSpawn; ++y3) {
                                    if (world.m_46859_((BlockPos)checkPos.m_122178_(x3, y3, z3))) continue;
                                    cleanSpawn = false;
                                }
                            }
                        }
                        if (!cleanSpawn) continue;
                        planBPos = checkPos.m_122178_(x23, y23 + 2, z23).m_7949_();
                    }
                }
                int xNeg = 1;
                for (int x6 = 1; x6 <= i - 1; ++x6) {
                    int x24 = posX + x6 * xNeg;
                    if (xNeg == 1 && x6 != 0) {
                        --x6;
                    }
                    xNeg *= -1;
                    for (int z6 = -i; z6 <= i; z6 += i * 2) {
                        int y32;
                        int z32;
                        int x32;
                        int z24 = posZ + z6;
                        if (!world.m_46859_((BlockPos)checkPos.m_122178_(x24, y23, z24))) {
                            cleanSpawn = true;
                            for (x32 = x24 - 2; x32 <= x24 + 2 && cleanSpawn; ++x32) {
                                for (z32 = z24 - 2; z32 <= z24 + 2 && cleanSpawn; ++z32) {
                                    for (y32 = y23 + 1; y32 <= y23 + 6 && cleanSpawn; ++y32) {
                                        if (world.m_46859_((BlockPos)checkPos.m_122178_(x32, y32, z32))) continue;
                                        cleanSpawn = false;
                                    }
                                }
                            }
                            if (!cleanSpawn) continue;
                            return checkPos.m_122178_(x24, y23 + 2, z24).m_7949_();
                        }
                        if (planBPos != null) continue;
                        cleanSpawn = true;
                        for (x32 = x24 - 2; x32 <= x24 + 2 && cleanSpawn; ++x32) {
                            for (z32 = z24 - 2; z32 <= z24 + 2 && cleanSpawn; ++z32) {
                                for (y32 = y23 + 1; y32 <= y23 + 6 && cleanSpawn; ++y32) {
                                    if (world.m_46859_((BlockPos)checkPos.m_122178_(x32, y32, z32))) continue;
                                    cleanSpawn = false;
                                }
                            }
                        }
                        if (!cleanSpawn) continue;
                        planBPos = checkPos.m_122178_(x24, y23 + 2, z24).m_7949_();
                    }
                }
            }
        }
        for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
            for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                checkPos.m_122178_(x, posY - searchRadius, z);
                while (world.m_46859_((BlockPos)checkPos.m_122173_(Direction.DOWN)) && checkPos.m_123342_() >= 0) {
                }
                y = checkPos.m_123342_();
                cleanSpawn = true;
                for (x2 = x - 2; x2 <= x + 2 && cleanSpawn; ++x2) {
                    for (z2 = z - 2; z2 <= z + 2 && cleanSpawn; ++z2) {
                        for (y2 = y + 1; y2 <= y + 6 && cleanSpawn; ++y2) {
                            if (world.m_46859_((BlockPos)checkPos.m_122178_(x2, y2, z2)) && y2 < worldHeight - 6) continue;
                            cleanSpawn = false;
                        }
                    }
                }
                if (!cleanSpawn || y < 0) continue;
                return checkPos.m_122178_(x, y + 2, z).m_7949_();
            }
        }
        for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
            for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                checkPos.m_122178_(x, worldHeight - 7, z);
                while (world.m_46859_((BlockPos)checkPos.m_122173_(Direction.DOWN)) && checkPos.m_123342_() >= posY + searchRadius) {
                }
                y = checkPos.m_123342_();
                cleanSpawn = true;
                for (x2 = x - 2; x2 <= x + 2 && cleanSpawn; ++x2) {
                    for (z2 = z - 2; z2 <= z + 2 && cleanSpawn; ++z2) {
                        for (y2 = y + 1; y2 <= y + 6 && cleanSpawn; ++y2) {
                            if (world.m_46859_((BlockPos)checkPos.m_122178_(x2, y2, z2))) continue;
                            cleanSpawn = false;
                        }
                    }
                }
                if (!cleanSpawn) continue;
                return checkPos.m_122178_(x, y + 2, z).m_7949_();
            }
        }
        if (planBPos != null) {
            return planBPos;
        }
        BlockPos placementPos = entity.m_20183_().m_6630_(2).m_7949_();
        if (placementPos.m_123342_() >= worldHeight - 10) {
            return new BlockPos(placementPos.m_123341_(), worldHeight - 10, placementPos.m_123343_());
        }
        return placementPos;
    }

    public BlockPos makePortal(Level world, Entity entity, BlockPos pos) {
        int z;
        int x;
        if (WorldUtil.isWorld(world, AoADimensions.OVERWORLD.key)) {
            return pos;
        }
        BlockPos returnPos = pos;
        pos = pos.m_7495_();
        BlockState border = this.getBorderBlock().m_49966_();
        BlockState portal = this.getPortalBlock().m_49966_();
        Direction.Axis direction = EntityUtil.getDirectionFacing(entity, true).m_122434_();
        if (!world.m_46859_(pos)) {
            for (x = pos.m_123341_() - 3; x <= pos.m_123341_() + 3; ++x) {
                for (z = pos.m_123343_() - 3; z <= pos.m_123343_() + 3; ++z) {
                    for (int y = pos.m_123342_() + 1; y <= pos.m_123342_() + 4; ++y) {
                        world.m_7731_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_(), 2);
                    }
                }
            }
        }
        if (direction == Direction.Axis.X) {
            portal = (BlockState)portal.m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.X);
            for (int z2 = pos.m_123343_() - 2; z2 <= pos.m_123343_() + 2; ++z2) {
                world.m_7731_(new BlockPos(pos.m_123341_(), pos.m_123342_(), z2), border, 2);
                world.m_7731_(new BlockPos(pos.m_123341_(), pos.m_123342_() + 5, z2), border, 2);
            }
            for (y = pos.m_123342_() + 1; y <= pos.m_123342_() + 4; ++y) {
                world.m_7731_(new BlockPos(pos.m_123341_(), y, pos.m_123343_() - 2), border, 2);
                world.m_7731_(new BlockPos(pos.m_123341_(), y, pos.m_123343_() - 1), portal, 2);
                world.m_7731_(new BlockPos(pos.m_123341_(), y, pos.m_123343_()), portal, 2);
                world.m_7731_(new BlockPos(pos.m_123341_(), y, pos.m_123343_() + 1), portal, 2);
                world.m_7731_(new BlockPos(pos.m_123341_(), y, pos.m_123343_() + 2), border, 2);
            }
        } else {
            portal = (BlockState)portal.m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.Z);
            for (x = pos.m_123341_() - 2; x <= pos.m_123341_() + 2; ++x) {
                world.m_7731_(new BlockPos(x, pos.m_123342_(), pos.m_123343_()), border, 2);
                world.m_7731_(new BlockPos(x, pos.m_123342_() + 5, pos.m_123343_()), border, 2);
            }
            for (y = pos.m_123342_() + 1; y <= pos.m_123342_() + 4; ++y) {
                world.m_7731_(new BlockPos(pos.m_123341_() - 2, y, pos.m_123343_()), border, 2);
                world.m_7731_(new BlockPos(pos.m_123341_() - 1, y, pos.m_123343_()), portal, 2);
                world.m_7731_(new BlockPos(pos.m_123341_(), y, pos.m_123343_()), portal, 2);
                world.m_7731_(new BlockPos(pos.m_123341_() + 1, y, pos.m_123343_()), portal, 2);
                world.m_7731_(new BlockPos(pos.m_123341_() + 2, y, pos.m_123343_()), border, 2);
            }
        }
        pos = pos.m_7495_();
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                BlockPos checkPos = pos.m_7918_(x, 0, z);
                if (world.m_8055_(checkPos).m_60783_((BlockGetter)world, checkPos, Direction.UP)) continue;
                this.makePortalPlatformAndDecorate(world, pos, direction);
                return returnPos;
            }
        }
        return returnPos;
    }

    public void makePortalPlatformAndDecorate(Level world, BlockPos pos, Direction.Axis direction) {
        BlockState border = this.getBorderBlock().m_49966_();
        for (int x = pos.m_123341_() - 2; x <= pos.m_123341_() + 2; ++x) {
            for (int z = pos.m_123343_() - 2; z <= pos.m_123343_() + 2; ++z) {
                world.m_7731_(new BlockPos(x, pos.m_123342_(), z), border, 2);
            }
        }
    }

    public void placeInPortal(Level world, Entity entity, BlockPos pos) {
        entity.m_20334_(0.0, 0.0, 0.0);
        entity.m_6027_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
    }
}

