/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.tslat.aoa3.util.RandomUtil;

public class StructureFeatureConfig
implements FeatureConfiguration {
    public static final Codec<StructureFeatureConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.listOf().fieldOf("templates").forGetter(config -> config.templatePaths), (App)Codec.BOOL.optionalFieldOf("random_mirroring", (Object)true).forGetter(config -> config.doMirroring), (App)Codec.BOOL.optionalFieldOf("random_rotation", (Object)true).forGetter(config -> config.doRotations), (App)Codec.BOOL.optionalFieldOf("spawn_entities", (Object)true).forGetter(config -> config.spawnEntities), (App)Codec.BOOL.optionalFieldOf("require_ground", (Object)true).forGetter(config -> config.requireGround), (App)StructureProcessorType.f_74468_.fieldOf("processors").forGetter(config -> config.processors)).apply((Applicative)builder, StructureFeatureConfig::new));
    public final List<ResourceLocation> templatePaths;
    public final boolean doMirroring;
    public final boolean doRotations;
    public final boolean spawnEntities;
    public final boolean requireGround;
    public final Holder<StructureProcessorList> processors;

    public StructureFeatureConfig(List<ResourceLocation> templatePaths, boolean doMirroring, boolean doRotations, boolean spawnEntities, boolean requireGround, Holder<StructureProcessorList> processors) {
        this.templatePaths = templatePaths;
        this.doMirroring = doMirroring;
        this.doRotations = doRotations;
        this.spawnEntities = spawnEntities;
        this.requireGround = requireGround;
        this.processors = processors;
    }

    public StructureTemplate getTemplate(RandomSource rand) {
        ResourceLocation templatePath = this.templatePaths.get(rand.m_188503_(this.templatePaths.size()));
        return (StructureTemplate)ServerLifecycleHooks.getCurrentServer().m_236738_().m_230407_(templatePath).get();
    }

    public StructurePlaceSettings getPlacementSettings(RandomSource rand) {
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom(rand);
        StructurePlaceSettings settings = new StructurePlaceSettings();
        if (this.doMirroring) {
            settings.m_74377_(random.getRandomSelection(Mirror.values()));
        }
        if (this.doRotations) {
            settings.m_74379_(random.getRandomSelection(Rotation.values()));
        }
        settings.m_74392_(!this.spawnEntities);
        settings.m_74405_(this.spawnEntities);
        for (StructureProcessor processor : ((StructureProcessorList)this.processors.m_203334_()).m_74425_()) {
            settings.m_74383_(processor);
        }
        return settings;
    }

    public static class Builder {
        private final List<ResourceLocation> templatePaths;
        private boolean doMirroring = true;
        private boolean doRotations = true;
        private boolean spawnEntities = true;
        private boolean requireGround = true;
        private final ArrayList<StructureProcessor> processors = new ArrayList(1);

        public Builder(ResourceLocation ... templatePaths) {
            this.templatePaths = Arrays.asList(templatePaths);
        }

        public Builder dontMirror() {
            this.doMirroring = false;
            return this;
        }

        public Builder dontRotate() {
            this.doRotations = false;
            return this;
        }

        public Builder ignoreEntities() {
            this.spawnEntities = false;
            return this;
        }

        public Builder spawnInMidair() {
            this.requireGround = false;
            return this;
        }

        public Builder withProcessors(StructureProcessor ... processors) {
            this.processors.addAll(Arrays.asList(processors));
            return this;
        }

        public Builder withProcessors(StructureProcessorList processorList) {
            this.processors.addAll(processorList.m_74425_());
            return this;
        }

        public StructureFeatureConfig build() {
            return new StructureFeatureConfig(this.templatePaths, this.doMirroring, this.doRotations, this.spawnEntities, this.requireGround, (Holder<StructureProcessorList>)Holder.m_205709_((Object)new StructureProcessorList(this.processors)));
        }
    }
}

