/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.chunkgenerator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class SingleBlockChunkGenerator
extends ChunkGenerator {
    public static final Codec<SingleBlockChunkGenerator> CODEC = RecordCodecBuilder.create(codec -> SingleBlockChunkGenerator.m_208005_((RecordCodecBuilder.Instance)codec).and(codec.group((App)BlockState.f_61039_.fieldOf("block").forGetter(instance -> instance.block), (App)Biome.f_47431_.fieldOf("biome").forGetter(instance -> instance.biome))).apply((Applicative)codec, SingleBlockChunkGenerator::new));
    private final BlockState block;
    private final Holder<Biome> biome;

    public SingleBlockChunkGenerator(Registry<StructureSet> structureSetsRegistry, BlockState block, Holder<Biome> biome) {
        super(structureSetsRegistry, Optional.empty(), (BiomeSource)new FixedBiomeSource(biome));
        this.block = block;
        this.biome = biome;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public void m_213679_(WorldGenRegion region, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carvingStep) {
    }

    public void m_214194_(WorldGenRegion region, StructureManager structureManager, RandomState random, ChunkAccess chunkAccess) {
    }

    public void m_6929_(WorldGenRegion region) {
    }

    public int m_142062_() {
        return 0;
    }

    public int m_6331_() {
        return 384;
    }

    public int m_6337_() {
        return -63;
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState random, StructureManager structureManager, ChunkAccess chunkAccess) {
        if (this.block.m_60734_() != Blocks.f_50016_) {
            Heightmap oceanFloorHeightmap = chunkAccess.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
            Heightmap worldgenHeightMap = chunkAccess.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = chunkAccess.m_141937_(); y <= chunkAccess.m_151558_(); ++y) {
                        chunkAccess.m_6978_((BlockPos)pos.m_122178_(x, y, z), this.block, false);
                        oceanFloorHeightmap.m_64249_(x, y, z, this.block);
                        worldgenHeightMap.m_64249_(x, y, z, this.block);
                    }
                }
            }
        }
        return CompletableFuture.completedFuture(chunkAccess);
    }

    public int m_214096_(int posX, int posZ, Heightmap.Types heightmapType, LevelHeightAccessor heightAccessor, RandomState random) {
        return this.block.m_60795_() ? 0 : this.m_6331_() - this.m_142062_();
    }

    public NoiseColumn m_214184_(int posX, int posZ, LevelHeightAccessor heightAccessor, RandomState random) {
        Object[] columnData = new BlockState[this.m_6331_()];
        Arrays.fill(columnData, this.block);
        return new NoiseColumn(this.m_142062_(), (BlockState[])columnData);
    }

    public void m_213600_(List<String> debugLines, RandomState random, BlockPos pos) {
    }
}

