/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public record BiomeMatcher(Optional<List<HolderSet<Biome>>> ifAll, Optional<List<HolderSet<Biome>>> ifAny, Optional<List<HolderSet<Biome>>> excluding) implements Predicate<Holder<Biome>>
{
    public static final Codec<BiomeMatcher> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Biome.f_47432_.listOf().optionalFieldOf("if_all").forGetter(BiomeMatcher::ifAll), (App)Biome.f_47432_.listOf().optionalFieldOf("if_any").forGetter(BiomeMatcher::ifAny), (App)Biome.f_47432_.listOf().optionalFieldOf("excluding").forGetter(BiomeMatcher::excluding)).apply((Applicative)codec, BiomeMatcher::new));

    @Override
    public boolean test(Holder<Biome> biome) {
        if (this.ifAll.isPresent()) {
            for (HolderSet<Biome> holderSet : this.ifAll.get()) {
                if (holderSet.m_203333_(biome)) continue;
                return false;
            }
        }
        if (this.ifAny.isPresent()) {
            boolean found = false;
            for (HolderSet<Biome> biomeSet : this.ifAny.get()) {
                if (!biomeSet.m_203333_(biome)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if (this.excluding.isPresent()) {
            for (HolderSet<Biome> holderSet : this.excluding.get()) {
                if (!holderSet.m_203333_(biome)) continue;
                return false;
            }
        }
        return true;
    }

    public static class Builder {
        final Registry<Biome> biomeRegistry;
        List<HolderSet<Biome>> ifAll = new ObjectArrayList(1);
        List<HolderSet<Biome>> ifAny = new ObjectArrayList(1);
        List<HolderSet<Biome>> excluding = new ObjectArrayList(1);

        public Builder(ServerLevel level) {
            this(level.m_5962_());
        }

        public Builder(RegistryAccess registryAccess) {
            this.biomeRegistry = (Registry)registryAccess.m_6632_(Registry.f_122885_).get();
        }

        public Builder mustBe(TagKey<Biome> ... tags) {
            for (TagKey<Biome> tag : tags) {
                this.ifAll.add((HolderSet<Biome>)new HolderSet.Named(this.biomeRegistry, tag));
            }
            return this;
        }

        public Builder mustBe(ResourceKey<Biome> ... biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                this.ifAll.add((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[]{this.biomeRegistry.m_214121_(biome)}));
            }
            return this;
        }

        public Builder mustBe(Holder<Biome> ... biomes) {
            for (Holder<Biome> biome : biomes) {
                this.ifAll.add((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[]{biome}));
            }
            return this;
        }

        public Builder atLeastOneOf(TagKey<Biome> ... tags) {
            for (TagKey<Biome> tag : tags) {
                this.ifAny.add((HolderSet<Biome>)new HolderSet.Named(this.biomeRegistry, tag));
            }
            return this;
        }

        public Builder atLeastOneOf(ResourceKey<Biome> ... biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                this.ifAny.add((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[]{this.biomeRegistry.m_214121_(biome)}));
            }
            return this;
        }

        public Builder atLeastOneOf(Holder<Biome> ... biomes) {
            for (Holder<Biome> biome : biomes) {
                this.ifAny.add((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[]{biome}));
            }
            return this;
        }

        public Builder cannotBe(TagKey<Biome> ... tags) {
            for (TagKey<Biome> tag : tags) {
                this.excluding.add((HolderSet<Biome>)new HolderSet.Named(this.biomeRegistry, tag));
            }
            return this;
        }

        public Builder cannotBe(ResourceKey<Biome> ... biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                this.excluding.add((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[]{this.biomeRegistry.m_214121_(biome)}));
            }
            return this;
        }

        public Builder cannotBe(Holder<Biome> ... biomes) {
            for (Holder<Biome> biome : biomes) {
                this.excluding.add((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[]{biome}));
            }
            return this;
        }

        public BiomeMatcher build() {
            Optional<List<HolderSet<Biome>>> ifAll = this.ifAll.isEmpty() ? Optional.empty() : Optional.of(this.ifAll);
            Optional<List<HolderSet<Biome>>> ifAny = this.ifAny.isEmpty() ? Optional.empty() : Optional.of(this.ifAny);
            Optional<List<HolderSet<Biome>>> excluding = this.excluding.isEmpty() ? Optional.empty() : Optional.of(this.excluding);
            return new BiomeMatcher(ifAll, ifAny, excluding);
        }
    }
}

