/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;

public class WhitewashingRecipe
implements Recipe<Inventory> {
    private final ResourceLocation id;
    private final String group;
    private final ItemStack input;
    private final ItemStack washingMaterial;
    private final ItemStack output;

    public WhitewashingRecipe(ResourceLocation id, String group, ItemStack input, ItemStack washingMaterial, ItemStack output) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.washingMaterial = washingMaterial;
        this.output = output;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)AoABlocks.WHITEWASHING_TABLE.get());
    }

    public boolean matches(Inventory inv, Level world) {
        return ItemStack.m_41746_((ItemStack)this.input, (ItemStack)inv.m_8020_(0)) && ItemStack.m_41746_((ItemStack)this.washingMaterial, (ItemStack)inv.m_8020_(1));
    }

    public ItemStack assemble(Inventory inv) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<WhitewashingRecipe> m_7707_() {
        return (RecipeSerializer)AoARecipes.WHITEWASHING.serializer().get();
    }

    public RecipeType<WhitewashingRecipe> m_6671_() {
        return (RecipeType)AoARecipes.WHITEWASHING.type().get();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.input}));
        ingredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.washingMaterial}));
        return ingredients;
    }

    public String m_6076_() {
        return this.group;
    }

    public static class Factory
    implements RecipeSerializer<WhitewashingRecipe> {
        public WhitewashingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            ItemStack inputItem = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"input"), (boolean)false);
            ItemStack washingMaterial = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"washing_material"), (boolean)false);
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return new WhitewashingRecipe(recipeId, group, inputItem, washingMaterial, output);
        }

        @Nullable
        public WhitewashingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            ItemStack inputItem = buffer.m_130267_();
            ItemStack washingMaterial = buffer.m_130267_();
            ItemStack output = buffer.m_130267_();
            return new WhitewashingRecipe(recipeId, group, inputItem, washingMaterial, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, WhitewashingRecipe recipe) {
            buffer.m_130072_(recipe.m_6076_(), Short.MAX_VALUE);
            buffer.m_130055_(recipe.input);
            buffer.m_130055_(recipe.washingMaterial);
            buffer.m_130055_(recipe.output);
        }
    }
}

