/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoARecipes;

public class ToolInteractionRecipe
extends CustomRecipe {
    private final NonNullList<Ingredient> ingredients;
    private final Ingredient toolItem;
    private final ItemStack result;

    public ToolInteractionRecipe(ResourceLocation id, Ingredient toolItem, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(id);
        this.ingredients = ingredients;
        this.toolItem = toolItem;
        this.result = result;
    }

    public boolean matches(CraftingContainer inventory, Level level) {
        StackedContents itemHelper = new StackedContents();
        boolean hasTool = false;
        int ingredientCount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (!hasTool && this.toolItem.test(stack)) {
                hasTool = true;
            }
            ++ingredientCount;
            itemHelper.m_36468_(stack, 1);
        }
        return hasTool && ingredientCount == this.ingredients.size() && itemHelper.m_36475_((Recipe)this, null);
    }

    public ItemStack assemble(CraftingContainer inventory) {
        return this.result.m_41777_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        NonNullList returns = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        boolean hasTool = false;
        for (int i = 0; i < returns.size(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!hasTool && this.toolItem.test(stack)) {
                ItemStack toolCopy = stack.m_41777_();
                toolCopy.m_41721_(toolCopy.m_41773_() + 1);
                if (toolCopy.m_41773_() < toolCopy.m_41776_()) {
                    returns.set(i, (Object)toolCopy);
                }
                hasTool = true;
                continue;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            returns.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return returns;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredients.size() + 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AoARecipes.TOOL_INTERACTION.serializer().get();
    }

    public ItemStack m_8043_() {
        return this.result.m_41777_();
    }

    public static class Factory
    implements RecipeSerializer<ToolInteractionRecipe> {
        public ToolInteractionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList ingredients = NonNullList.m_122779_();
            Ingredient toolItem = Ingredient.m_43917_((JsonElement)json.get("tool"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            JsonArray ingredientsArray = json.getAsJsonArray("ingredients");
            for (JsonElement ingredientElement : ingredientsArray) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientElement);
                if (ingredient.m_43947_()) continue;
                ingredients.add((Object)ingredient);
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No valid ingredients for tool interaction recipe: " + recipeId.toString());
            }
            return new ToolInteractionRecipe(recipeId, toolItem, result, (NonNullList<Ingredient>)ingredients);
        }

        @Nullable
        public ToolInteractionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int ingredientsCount = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientsCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            Ingredient toolItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return new ToolInteractionRecipe(recipeId, toolItem, result, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, ToolInteractionRecipe recipe) {
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            recipe.toolItem.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
        }
    }
}

